/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.highlighting;

import org.eclipse.jface.text.Position;

public class HighlightedTypedPosition
extends Position
implements Comparable<Position> {
    public final HighlightKind kind;

    public HighlightedTypedPosition(Position pos, HighlightKind kind) {
        super(pos.getOffset(), pos.getLength());
        this.kind = kind;
    }

    public HighlightedTypedPosition(int offset, HighlightKind kind) {
        super(offset);
        this.kind = kind;
    }

    public HighlightedTypedPosition(int offset, int length, HighlightKind kind) {
        super(offset, length);
        this.kind = kind;
    }

    @Override
    public int compareTo(Position that) {
        return that == null ? 1 : this.offset - that.offset;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!super.equals(that) || !(that instanceof HighlightedTypedPosition)) {
            return false;
        }
        return this.kind == ((HighlightedTypedPosition)that).kind;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        return result;
    }

    public String toString() {
        return "HighlightedTypedPosition[kind=" + String.valueOf((Object)this.kind) + ", offset=" + this.offset + ", length=" + this.length + "]";
    }

    public static enum HighlightKind {
        COMMENT,
        DEFAULT,
        KEYWORD,
        RESERVED,
        NUMBER,
        STRING,
        REGEXP,
        MAP_KEY,
        TAG_KEY,
        CTOR,
        METHOD,
        STATIC_METHOD,
        CTOR_CALL,
        GROOVY_CALL,
        METHOD_CALL,
        STATIC_CALL,
        CLASS,
        ABSTRACT_CLASS,
        INTERFACE,
        TRAIT,
        ANNOTATION,
        ENUMERATION,
        PLACEHOLDER,
        FIELD,
        STATIC_FIELD,
        STATIC_VALUE,
        PARAMETER,
        VARIABLE,
        DEPRECATED,
        UNKNOWN;

    }
}

