/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.refactoring.actions.FormatKind;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.FormatterPreferences;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

public class FormatGroovyAction
extends SelectionDispatchAction {
    private final FormatKind kind;

    public FormatGroovyAction(IWorkbenchSite site, FormatKind kind) {
        super(site);
        this.kind = kind;
        if (kind == FormatKind.INDENT_ONLY) {
            this.setText("Correct Indentation");
            this.setToolTipText("Indent Groovy file");
            this.setDescription("Indent selection in Groovy file");
        } else if (kind == FormatKind.FORMAT) {
            this.setText("Format");
            this.setToolTipText("Format Groovy file");
            this.setDescription("Format selection in Groovy file");
        }
    }

    public void run(ITextSelection selection) {
        if (!(this.getSite() instanceof IEditorSite)) {
            return;
        }
        IWorkbenchPart part = ((IEditorSite)this.getSite()).getPart();
        if (!(part instanceof GroovyEditor)) {
            return;
        }
        GroovyEditor groovyEditor = (GroovyEditor)part;
        GroovyCompilationUnit unit = groovyEditor.getGroovyCompilationUnit();
        IDocument doc = groovyEditor.getDocumentProvider().getDocument((Object)groovyEditor.getEditorInput());
        if (doc != null && unit != null) {
            boolean isIndentOnly = this.kind == FormatKind.INDENT_ONLY;
            FormatterPreferences preferences = new FormatterPreferences((ICompilationUnit)unit);
            DefaultGroovyFormatter formatter = new DefaultGroovyFormatter(selection, doc, (IFormatterPreferences)preferences, isIndentOnly);
            TextEdit edit = formatter.format();
            try {
                unit.applyTextEdit(edit, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (MalformedTreeException e) {
                GroovyCore.logException((String)"Exception when formatting", (Throwable)e);
            }
            catch (JavaModelException e) {
                GroovyCore.logException((String)"Exception when formatting", (Throwable)e);
            }
        }
    }
}

