/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.composer.core.webview.browserfunction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.katalon.composer.core.webview.browserfunction.BaseRpcHandlerRegistry;
import com.katalon.composer.core.webview.browserfunction.QuadConsumer;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuadRpcHandlerRegistry<T, U, V, W>
extends BaseRpcHandlerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(QuadRpcHandlerRegistry.class);
    private final Class<T> clazzT;
    private final Class<U> clazzU;
    private final Class<V> clazzV;
    private final Class<W> clazzW;
    private final QuadConsumer<T, U, V, W> handler;

    public QuadRpcHandlerRegistry(String name, Class<T> clazzT, Class<U> clazzU, Class<V> clazzV, Class<W> clazzW, QuadConsumer<T, U, V, W> handler) {
        super(name);
        this.clazzT = clazzT;
        this.clazzU = clazzU;
        this.clazzV = clazzV;
        this.clazzW = clazzW;
        this.handler = handler;
    }

    @Override
    public void invoke(ArrayNode args) {
        if (args.size() < 4) {
            logger.error("Not enough arguments from browser function | name = {} | expected = 4 | actual = {}", (Object)this.name, (Object)args.size());
            return;
        }
        try {
            T argT = this.parseArgument(args.get(0), null, this.clazzT);
            U argU = this.parseArgument(args.get(1), null, this.clazzU);
            V argV = this.parseArgument(args.get(2), null, this.clazzV);
            W argW = this.parseArgument(args.get(3), null, this.clazzW);
            UISynchronizeService.asyncExec(() -> this.handler.accept(argT, argU, argV, argW));
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to parse data from browser function | name = %s | argT = %s | argU = %s | argV = %s | argW = %s".formatted(this.name, args.get(0).toString(), args.get(1).toString(), args.get(2).toString(), args.get(3).toString()), (Throwable)e);
        }
    }
}

