/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.component;

import com.kms.katalon.composer.execution.components.DriverPreferenceComposite;
import com.kms.katalon.composer.execution.components.DriverPropertyMapComposite;
import com.kms.katalon.composer.webui.constants.StringConstants;
import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class RemoteWebDriverPreferenceComposite
extends DriverPreferenceComposite {
    private Text txtRemoteServerUrl;
    private Combo cmbRemoteServerType;
    private Combo cbbAppiumDriver;
    private GridData gdMobileComposite;
    private GridData gdLblDriverType;
    private static final String[] MOBILE_DRIVER_NAMES = AppiumMobileDriver.driverNames().toArray(new String[0]);
    private static final String[] REMOTE_SERVER_TYPES = RemoteWebDriverConnector.RemoteWebDriverConnectorType.stringValues();

    public RemoteWebDriverPreferenceComposite(Composite parent, int style, RemoteWebDriverConnector remoteDriverConnector) {
        super(parent, style, (IDriverConnector)remoteDriverConnector);
    }

    protected void createContents(final IDriverConnector driverConnector) {
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(1808));
        Composite remoteUrlComposite = new Composite((Composite)this, 0);
        remoteUrlComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glRemoteComposite = new GridLayout(2, false);
        glRemoteComposite.verticalSpacing = 10;
        glRemoteComposite.horizontalSpacing = 15;
        remoteUrlComposite.setLayout((Layout)glRemoteComposite);
        final Label lblRemoteServerUrl = new Label(remoteUrlComposite, 0);
        GridData gdLblServerUrl = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblRemoteServerUrl.setLayoutData((Object)gdLblServerUrl);
        lblRemoteServerUrl.setText(StringConstants.LBL_REMOTE_SERVER_URL);
        this.txtRemoteServerUrl = new Text(remoteUrlComposite, 2048);
        final GridData gdTxtUrl = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtRemoteServerUrl.setLayoutData((Object)gdTxtUrl);
        gdTxtUrl.widthHint = 250;
        this.txtRemoteServerUrl.setToolTipText(this.txtRemoteServerUrl.getText());
        this.txtRemoteServerUrl.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                gdTxtUrl.widthHint = event.width;
                RemoteWebDriverPreferenceComposite.this.gdLblDriverType.widthHint = lblRemoteServerUrl.getBounds().width;
            }
        });
        this.txtRemoteServerUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteWebDriverPreferenceComposite.this.txtRemoteServerUrl.setToolTipText(RemoteWebDriverPreferenceComposite.this.txtRemoteServerUrl.getText());
            }
        });
        Label lblRemoteServerType = new Label(remoteUrlComposite, 0);
        GridData gdLblRemoteServerType = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblRemoteServerType.setLayoutData((Object)gdLblRemoteServerType);
        lblRemoteServerType.setText(StringConstants.LBL_REMOTE_SERVER_TYPE);
        this.cmbRemoteServerType = new Combo(remoteUrlComposite, 8);
        this.cmbRemoteServerType.setItems(REMOTE_SERVER_TYPES);
        Composite mobileDriverComposite = new Composite((Composite)this, 0);
        this.gdMobileComposite = new GridData(4, 0x1000000, true, false, 1, 1);
        mobileDriverComposite.setLayoutData((Object)this.gdMobileComposite);
        GridLayout glMobileComposite = new GridLayout(2, false);
        glMobileComposite.verticalSpacing = 10;
        glMobileComposite.horizontalSpacing = 15;
        mobileDriverComposite.setLayout((Layout)glMobileComposite);
        Label lblDriverType = new Label(mobileDriverComposite, 0);
        this.gdLblDriverType = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblDriverType.setLayoutData((Object)lblDriverType);
        lblDriverType.setLayoutData((Object)this.gdLblDriverType);
        lblDriverType.setText("Appium driver");
        this.cbbAppiumDriver = new Combo(mobileDriverComposite, 8);
        final String[] mobileDriverStringValues = MOBILE_DRIVER_NAMES;
        this.cbbAppiumDriver.setItems(mobileDriverStringValues);
        this.driverPropertyMapComposite = new DriverPropertyMapComposite((Composite)this);
        this.txtRemoteServerUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((RemoteWebDriverConnector)driverConnector).setRemoteServerUrl(RemoteWebDriverPreferenceComposite.this.txtRemoteServerUrl.getText());
            }
        });
        this.cmbRemoteServerType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int selectedIndex = RemoteWebDriverPreferenceComposite.this.cmbRemoteServerType.getSelectionIndex();
                RemoteWebDriverConnector.RemoteWebDriverConnectorType serverDriverType = RemoteWebDriverConnector.RemoteWebDriverConnectorType.valueOf((String)REMOTE_SERVER_TYPES[selectedIndex]);
                ((RemoteWebDriverConnector)driverConnector).setRemoteWebDriverConnectorType(serverDriverType);
                RemoteWebDriverPreferenceComposite.this.updateMobileCompositeLayout(serverDriverType);
            }
        });
        this.cbbAppiumDriver.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int selectedIndex = RemoteWebDriverPreferenceComposite.this.cbbAppiumDriver.getSelectionIndex();
                ((RemoteWebDriverConnector)driverConnector).setMobileDriverType(AppiumMobileDriver.fromDriverName(mobileDriverStringValues[selectedIndex]));
            }
        });
        this.updateInputToUI();
    }

    public void updateInputToUI() {
        super.updateInputToUI();
        this.txtRemoteServerUrl.setText(((RemoteWebDriverConnector)this.driverConnector).getRemoteServerUrl());
        int mobileDriverSelectionIndex = 0;
        int i = 0;
        while (i < MOBILE_DRIVER_NAMES.length) {
            MobileDriverType mobileDriverType = ((RemoteWebDriverConnector)this.driverConnector).getMobileDriverType();
            if (mobileDriverType != null && MOBILE_DRIVER_NAMES[i].equals(AppiumMobileDriver.fromDriver((MobileDriverType)mobileDriverType).driverName)) {
                mobileDriverSelectionIndex = i;
                break;
            }
            ++i;
        }
        this.cbbAppiumDriver.select(mobileDriverSelectionIndex);
        int selectedIndex = 0;
        int i2 = 0;
        while (i2 < REMOTE_SERVER_TYPES.length) {
            if (REMOTE_SERVER_TYPES[i2].equals(((RemoteWebDriverConnector)this.driverConnector).getRemoteWebDriverConnectorType().name())) {
                selectedIndex = i2;
                break;
            }
            ++i2;
        }
        this.cmbRemoteServerType.select(selectedIndex);
        this.cmbRemoteServerType.notifyListeners(13, new Event());
    }

    private void updateMobileCompositeLayout(RemoteWebDriverConnector.RemoteWebDriverConnectorType serverDriverType) {
        this.gdMobileComposite.heightHint = serverDriverType != RemoteWebDriverConnector.RemoteWebDriverConnectorType.Appium ? 0 : -1;
        this.getParent().getParent().layout(true, true);
    }

    private static enum AppiumMobileDriver {
        ANDROID_DRIVER(MobileDriverType.ANDROID_DRIVER, "Android Driver"),
        IOS_DRIVER(MobileDriverType.IOS_DRIVER, "iOS Driver");

        private String driverName;
        private MobileDriverType mobileDriver;

        private AppiumMobileDriver(MobileDriverType mobileDriver, String driverName) {
            this.mobileDriver = mobileDriver;
            this.driverName = driverName;
        }

        public static List<String> driverNames() {
            ArrayList<String> names = new ArrayList<String>();
            AppiumMobileDriver[] appiumMobileDriverArray = AppiumMobileDriver.values();
            int n = appiumMobileDriverArray.length;
            int n2 = 0;
            while (n2 < n) {
                AppiumMobileDriver driver = appiumMobileDriverArray[n2];
                names.add(driver.driverName);
                ++n2;
            }
            return names;
        }

        public static MobileDriverType fromDriverName(String driverName) {
            AppiumMobileDriver[] appiumMobileDriverArray = AppiumMobileDriver.values();
            int n = appiumMobileDriverArray.length;
            int n2 = 0;
            while (n2 < n) {
                AppiumMobileDriver driver = appiumMobileDriverArray[n2];
                if (driver.driverName.equals(driverName)) {
                    return driver.mobileDriver;
                }
                ++n2;
            }
            return MobileDriverType.ANDROID_DRIVER;
        }

        public static AppiumMobileDriver fromDriver(MobileDriverType driverType) {
            AppiumMobileDriver[] appiumMobileDriverArray = AppiumMobileDriver.values();
            int n = appiumMobileDriverArray.length;
            int n2 = 0;
            while (n2 < n) {
                AppiumMobileDriver driver = appiumMobileDriverArray[n2];
                if (driver.mobileDriver == driverType) {
                    return driver;
                }
                ++n2;
            }
            return ANDROID_DRIVER;
        }
    }
}

