/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.core.domain.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.kms.katalon.onboarding.core.domain.model.BaseItem;
import com.kms.katalon.onboarding.core.domain.model.Level;
import com.kms.katalon.onboarding.core.domain.model.StepGroup;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public class OnboardingTour
extends BaseItem {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="estimation")
    @JsonSerialize(using=DurationSerializer.class)
    @JsonDeserialize(using=DurationDeserializer.class)
    private Duration estimation;
    @JsonProperty(value="stepGroups")
    private List<StepGroup> stepGroups;
    @JsonProperty(value="itemReference")
    private List<BaseItem> itemReference;

    public OnboardingTour() {
    }

    public OnboardingTour(String id, String title, String description, Duration estimation) {
        super(id, title);
        this.description = description;
        this.estimation = estimation;
    }

    public OnboardingTour(String id, String title, String description, Duration estimation, Level level) {
        super(id, title, level);
        this.description = description;
        this.estimation = estimation;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Duration getEstimation() {
        return this.estimation;
    }

    public void setEstimation(Duration estimation) {
        this.estimation = estimation;
    }

    public List<StepGroup> getStepGroups() {
        return this.stepGroups;
    }

    public void setStepGroups(List<StepGroup> stepGroups) {
        this.stepGroups = stepGroups;
    }

    public List<BaseItem> getItemReference() {
        return this.itemReference;
    }

    public void setItemReference(List<BaseItem> itemReference) {
        this.itemReference = itemReference;
    }

    public static class DurationDeserializer
    extends JsonDeserializer<Duration> {
        public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String durationString = p.getValueAsString();
            if (durationString == null || durationString.trim().isEmpty()) {
                return null;
            }
            try {
                return Duration.parse(durationString);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static class DurationSerializer
    extends JsonSerializer<Duration> {
        public void serialize(Duration value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value.toString());
            }
        }
    }
}

