/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.discovery.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.model.exception.DiscoveryException;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class DiscoveryService
implements IDiscoveryService {
    private final String MARKETING_SERVER_URL_SYSTEM_PROPERTY = "marketingServerUrl";
    private Logger logger = LoggerFactory.getLogger(DiscoveryService.class);
    private static IDiscoveryService instance;
    private Map<ServerType, String> serverInfo = new HashMap<ServerType, String>();
    @Inject
    IHttpClient httpClient;
    @Inject
    INetworkPreferences networkPreferences;
    final String SERVER_INFO_PATH = "/v1/server-info";

    public static IDiscoveryService getInstance() {
        if (Objects.isNull(instance)) {
            BundleContext bundleContext = FrameworkUtil.getBundle(DiscoveryService.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            instance = (IDiscoveryService)ContextInjectionFactory.make(DiscoveryService.class, (IEclipseContext)context);
        }
        return instance;
    }

    public Map<ServerType, String> getServerInfo(String serverUrl) throws DiscoveryException {
        HashMap<ServerType, String> serverInfo = new HashMap<ServerType, String>();
        serverInfo.put(ServerType.ADMIN, serverUrl);
        serverInfo.put(ServerType.TESTOPS, serverUrl);
        serverInfo.put(ServerType.PLUGIN_STORE, "https://store.katalon.com");
        serverInfo.put(ServerType.DOWNLOAD, "https://download.katalon.com");
        serverInfo.put(ServerType.MARKETING, "https://backend.katalon.com");
        try {
            URI baseUri = new URI(serverUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("/v1/server-info").build();
            ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
            HttpOptions httpOptions = new HttpOptions.Builder().proxy(proxyConfig).build();
            HttpResponse response = this.httpClient.get(uri, httpOptions);
            int statusCode = response.getStatusCode();
            if (statusCode >= 400 && statusCode < 500) {
                this.handleError(statusCode, response.getBody());
            } else if (statusCode >= 500 && statusCode < 600) {
                this.handleServerError(statusCode, response.getBody());
            }
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                Map map = (Map)objectMapper.readValue(response.getBody(), (TypeReference)new TypeReference<Map<String, String>>(){});
                for (Map.Entry entry : map.entrySet()) {
                    ServerType serverType = ServerType.fromField((String)((String)entry.getKey()));
                    if (serverType == null) continue;
                    serverInfo.put(serverType, (String)entry.getValue());
                }
                this.applyOverrideServerInfo();
                return serverInfo;
            }
            catch (JsonProcessingException e) {
                throw new DiscoveryException(e.getMessage());
            }
        }
        catch (HttpException | URISyntaxException e) {
            throw new DiscoveryException(e.getMessage());
        }
    }

    public void setServerUrls(Map<ServerType, String> serverUrls) {
        this.serverInfo = new HashMap<ServerType, String>(serverUrls);
        this.applyOverrideServerInfo();
    }

    public String getServerUrl(ServerType serverType) {
        return this.serverInfo.get(serverType);
    }

    public void setServerUrl(ServerType serverType, String serverUrl) {
        if (this.serverInfo == null) {
            this.serverInfo = new HashMap<ServerType, String>();
        }
        this.serverInfo.put(serverType, serverUrl);
    }

    private void handleError(int statusCode, String message) throws DiscoveryException {
        throw new DiscoveryException(message);
    }

    private void handleServerError(int statusCode, String message) throws DiscoveryException {
        throw new DiscoveryException(message);
    }

    public boolean isOnline(String serverUrl) {
        if (StringUtils.isNotBlank((CharSequence)serverUrl)) {
            try {
                ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
                HttpOptions httpOptions = new HttpOptions.Builder().proxy(proxyConfig).build();
                HttpResponse httpResponse = this.httpClient.connect(serverUrl, httpOptions);
                if (httpResponse.getStatusCode() != 200) {
                    throw new NetworkErrorException();
                }
                return true;
            }
            catch (HttpException e) {
                this.logger.error(e.getMessage());
            }
        }
        return false;
    }

    private void applyOverrideServerInfo() {
        HashMap<ServerType, String> overrideServerInfo = new HashMap<ServerType, String>();
        overrideServerInfo.put(ServerType.MARKETING, System.getProperty("marketingServerUrl"));
        overrideServerInfo.forEach((type, overrideUrl) -> {
            if (this.serverInfo.containsKey(type) && overrideUrl != null && !overrideUrl.isBlank()) {
                this.serverInfo.put((ServerType)type, (String)overrideUrl);
            }
        });
    }
}

