/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.dialog;

import com.kms.katalon.composer.components.impl.control.GifCLabel;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.qtest.constant.ComposerIntegrationQtestMessageConstants;
import com.kms.katalon.composer.integration.qtest.constant.ImageConstants;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.integration.qtest.QTestIntegrationAuthenticationManager;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.credential.impl.QTestCredentialImpl;
import com.kms.katalon.integration.qtest.exception.QTestException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GenerateNewTokenDialog
extends AbstractDialog {
    private Text txtServerUrl;
    private Text txtUsername;
    private Text txtPassword;
    private IQTestCredential fCredential;
    private GifCLabel connectingLabel;
    private Label lblConnecting;
    private Composite connectingComposite;
    private InputStream inputStream;
    private Job connectingJob;
    private Composite passwordComposite;
    private Button btnShowPassword;
    private Button chckEncryptPassword;

    public GenerateNewTokenDialog(Shell parentShell, IQTestCredential credential) {
        super(parentShell);
        this.fCredential = credential;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, StringConstants.DIA_TITLE_GENERATE, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.generateNewToken();
    }

    protected void cancelPressed() {
        if (this.connectingJob != null && this.connectingJob.getState() == 4) {
            this.connectingJob.cancel();
        }
        super.cancelPressed();
    }

    private boolean isDisposed() {
        Shell shell = this.getShell();
        return shell == null || shell.isDisposed();
    }

    private boolean generateNewToken() {
        final String newServerUrl = this.txtServerUrl.getText().trim();
        final String newUsername = this.txtUsername.getText();
        final String newPassword = this.txtPassword.getText();
        final boolean passwordEncryptionEnabled = this.chckEncryptPassword.getSelection();
        if (newServerUrl.isEmpty()) {
            MessageDialog.openInformation(null, (String)StringConstants.INFORMATION, (String)StringConstants.DIA_MSG_ENTER_SERVER_URL);
            return false;
        }
        if (newUsername.isEmpty()) {
            MessageDialog.openInformation(null, (String)StringConstants.INFORMATION, (String)StringConstants.DIA_MSG_ENTER_USERNAME);
            return false;
        }
        if (newPassword.isEmpty()) {
            MessageDialog.openInformation(null, (String)StringConstants.INFORMATION, (String)StringConstants.DIA_MSG_ENTER_PASSWORD);
            return false;
        }
        this.setConnectingCompositeVisible(true);
        this.getButton(0).setEnabled(false);
        this.connectingJob = new Job(StringConstants.DIA_JOB_GENERATE_TOKEN){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    QTestCredentialImpl credentials = new QTestCredentialImpl().setServerUrl(newServerUrl).setUsername(newUsername).setPassword(newPassword).setVersion(GenerateNewTokenDialog.this.fCredential.getVersion()).setPasswordEncryptionEnabled(passwordEncryptionEnabled);
                    credentials.setToken(QTestIntegrationAuthenticationManager.getToken((IQTestCredential)credentials));
                    GenerateNewTokenDialog.this.fCredential = credentials;
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (QTestException e) {
                    if (!monitor.isCanceled() && !GenerateNewTokenDialog.this.isDisposed()) {
                        UISynchronizeService.syncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR, (String)e.getLocalizedMessage());
                            }
                        });
                    }
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.connectingJob.setUser(false);
        this.connectingJob.schedule();
        this.connectingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (GenerateNewTokenDialog.this.isDisposed()) {
                    return;
                }
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GenerateNewTokenDialog.this.getButton(0).setEnabled(true);
                        GenerateNewTokenDialog.this.setConnectingCompositeVisible(false);
                    }
                });
                if (!event.getResult().isOK()) {
                    return;
                }
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GenerateNewTokenDialog.this.setReturnCode(0);
                        GenerateNewTokenDialog.this.close();
                    }
                });
            }
        });
        return true;
    }

    private void setConnectingCompositeVisible(boolean isConnectingCompositeVisible) {
        block11: {
            if (isConnectingCompositeVisible) {
                try {
                    try {
                        this.inputStream = ImageConstants.URL_16_LOADING.openStream();
                        this.connectingLabel.setGifImage(this.inputStream);
                        this.connectingComposite.layout(true, true);
                    }
                    catch (IOException iOException) {
                        if (this.inputStream != null) {
                            this.closeQuietlyWithLog(this.inputStream);
                            this.inputStream = null;
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    if (this.inputStream != null) {
                        this.closeQuietlyWithLog(this.inputStream);
                        this.inputStream = null;
                    }
                    throw throwable;
                }
                if (this.inputStream != null) {
                    this.closeQuietlyWithLog(this.inputStream);
                    this.inputStream = null;
                }
            } else if (this.inputStream != null) {
                this.closeQuietlyWithLog(this.inputStream);
                this.inputStream = null;
            }
        }
        this.connectingComposite.setVisible(isConnectingCompositeVisible);
    }

    private void closeQuietlyWithLog(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public IQTestCredential getNewCredential() {
        return this.fCredential;
    }

    private void setText(Text text, String value) {
        text.setText(value != null ? value : "");
    }

    protected void registerControlModifyListeners() {
        this.btnShowPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateNewTokenDialog.this.updatePasswordField();
            }
        });
    }

    private void updatePasswordField() {
        if (this.btnShowPassword.getSelection()) {
            this.txtPassword.setEchoChar('\u0000');
        } else {
            this.txtPassword.setEchoChar("\u2022".charAt(0));
        }
    }

    protected void setInput() {
        if (this.fCredential == null) {
            this.fCredential = new QTestCredentialImpl();
        }
        this.setText(this.txtServerUrl, this.fCredential.getServerUrl());
        this.setText(this.txtUsername, this.fCredential.getUsername());
        this.setText(this.txtPassword, this.fCredential.getPassword());
        this.chckEncryptPassword.setSelection(this.fCredential.isEncryptionEnabled());
        this.updatePasswordField();
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.horizontalSpacing = 10;
        container.setLayout((Layout)glContainer);
        Label lblServerUrl = new Label(container, 0);
        lblServerUrl.setText(StringConstants.CM_SERVER_URL);
        this.txtServerUrl = new Text(container, 2048);
        this.txtServerUrl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblUsername = new Label(container, 0);
        lblUsername.setText(StringConstants.CM_USERNAME);
        this.txtUsername = new Text(container, 2048);
        this.txtUsername.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPassword = new Label(container, 0);
        lblPassword.setText(StringConstants.CM_PASSWORD);
        this.passwordComposite = new Composite(container, 0);
        this.passwordComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout glPasswordComposite = new GridLayout(2, false);
        glPasswordComposite.marginHeight = 0;
        glPasswordComposite.marginWidth = 0;
        this.passwordComposite.setLayout((Layout)glPasswordComposite);
        this.txtPassword = new Text(this.passwordComposite, 2048);
        GridData gdTxtData = new GridData(4, 0x1000000, true, false, 1, 1);
        gdTxtData.widthHint = 200;
        this.txtPassword.setLayoutData((Object)gdTxtData);
        this.btnShowPassword = new Button(this.passwordComposite, 32);
        this.btnShowPassword.setText(StringConstants.WZ_P_AUTHENTICATION_SHOW_PASSWORD);
        this.chckEncryptPassword = new Button(container, 32);
        this.chckEncryptPassword.setLayoutData((Object)new GridData(16384, 0x1000000, false, true, 2, 1));
        this.chckEncryptPassword.setText(ComposerIntegrationQtestMessageConstants.WZ_P_AUTHENTICATION_ENCRYPT_AUTHENTICATION_DATA);
        this.connectingComposite = new Composite(container, 0);
        this.connectingComposite.setLayout((Layout)new GridLayout(2, false));
        this.connectingComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.connectingLabel = new GifCLabel(this.connectingComposite, 0x20000000);
        this.connectingLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.lblConnecting = new Label(this.connectingComposite, 0);
        this.lblConnecting.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblConnecting.setText(StringConstants.CM_CONNECTING);
        this.setConnectingCompositeVisible(false);
        return container;
    }

    public String getDialogTitle() {
        return StringConstants.DIA_TITLE_GENERATE_TOKEN;
    }
}

