/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.handler.AbstractQTestHandler;
import com.kms.katalon.composer.integration.qtest.job.UploadTestCaseResultJob;
import com.kms.katalon.composer.report.lookup.LogRecordLookup;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationTestSuiteManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.entity.QTestLog;
import com.kms.katalon.integration.qtest.entity.QTestLogUploadedPreview;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestRun;
import com.kms.katalon.integration.qtest.entity.QTestSuite;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.model.ReportTestCaseLogPair;
import com.kms.katalon.integration.qtest.model.ReportUploadedPreviewPair;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class QTestUploadReportHandler
extends AbstractQTestHandler {
    private List<ReportTestCaseLogPair> fPairs;
    @Named(value="activeShell")
    private Shell activeShell;
    @Inject
    private ESelectionService selectionService;
    private boolean canExecute;
    private Thread thread;

    @CanExecute
    public boolean canExecute(final MDirectMenuItem item) {
        if (this.canExecute) {
            return this.canExecute;
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String label;
                block11: {
                    FolderEntity folderEntity;
                    block12: {
                        Object selectedEntity;
                        block10: {
                            label = item.getLabel();
                            selectedEntity = QTestUploadReportHandler.this.getFirstSelectedObject(QTestUploadReportHandler.this.selectionService);
                            if (selectedEntity != null) break block10;
                            item.setLabel(label);
                            item.setEnabled(QTestUploadReportHandler.this.fPairs.size() > 0);
                            QTestUploadReportHandler.this.canExecute = item.isEnabled();
                            item.setIconURI(null);
                            return;
                        }
                        QTestUploadReportHandler.this.fPairs = new ArrayList<ReportTestCaseLogPair>();
                        if (selectedEntity instanceof ReportEntity) {
                            ReportTestCaseLogPair pair = QTestUploadReportHandler.this.getTestCaseLogPair((ReportEntity)selectedEntity);
                            if (pair != null) {
                                QTestUploadReportHandler.this.fPairs.add(pair);
                            }
                            break block11;
                        }
                        if (!(selectedEntity instanceof FolderEntity)) break block11;
                        folderEntity = (FolderEntity)selectedEntity;
                        if (QTestIntegrationUtil.isFolderReportInTestSuiRepo((FolderEntity)folderEntity, (ProjectEntity)QTestUploadReportHandler.this.getProjectEntity())) break block12;
                        item.setLabel(label);
                        item.setEnabled(QTestUploadReportHandler.this.fPairs.size() > 0);
                        QTestUploadReportHandler.this.canExecute = item.isEnabled();
                        item.setIconURI(null);
                        return;
                    }
                    try {
                        try {
                            List children = FolderController.getInstance().getAllDescentdantEntities(folderEntity);
                            int i = 0;
                            while (i < children.size()) {
                                ReportTestCaseLogPair pair;
                                Object childObject = children.get(i);
                                item.setLabel(MessageFormat.format(StringConstants.HDL_LABEL_VALIDATING_REPORT, label, i * 100 / children.size()));
                                if (childObject instanceof ReportEntity && (pair = QTestUploadReportHandler.this.getTestCaseLogPair((ReportEntity)childObject)) != null) {
                                    QTestUploadReportHandler.this.fPairs.add(pair);
                                }
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            LoggerSingleton.logError((Throwable)e);
                            item.setLabel(label);
                            item.setEnabled(QTestUploadReportHandler.this.fPairs.size() > 0);
                            QTestUploadReportHandler.this.canExecute = item.isEnabled();
                            item.setIconURI(null);
                        }
                    }
                    catch (Throwable throwable) {
                        item.setLabel(label);
                        item.setEnabled(QTestUploadReportHandler.this.fPairs.size() > 0);
                        QTestUploadReportHandler.this.canExecute = item.isEnabled();
                        item.setIconURI(null);
                        throw throwable;
                    }
                }
                item.setLabel(label);
                item.setEnabled(QTestUploadReportHandler.this.fPairs.size() > 0);
                QTestUploadReportHandler.this.canExecute = item.isEnabled();
                item.setIconURI(null);
            }
        });
        this.thread.start();
        MElementContainer menuImpl = item.getParent();
        Menu menu = (Menu)menuImpl.getWidget();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                QTestUploadReportHandler.this.clearData();
            }
        });
        menu.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                QTestUploadReportHandler.this.clearData();
            }
        });
        return this.canExecute;
    }

    @Execute
    public void execute() {
        QTestUploadReportHandler.performUploadTestCaseLogs(this.fPairs, this.activeShell);
    }

    public static void performUploadTestCaseLogs(List<ReportTestCaseLogPair> testCaseLogPairs, Shell shell) {
        ArrayList<ReportUploadedPreviewPair> uploadedPairs = new ArrayList<ReportUploadedPreviewPair>();
        for (ReportTestCaseLogPair testCaseLogPair : testCaseLogPairs) {
            ReportUploadedPreviewPair uploadedPair = QTestUploadReportHandler.transform(testCaseLogPair, shell);
            if (uploadedPair == null) continue;
            uploadedPairs.add(uploadedPair);
        }
        UploadTestCaseResultJob job = new UploadTestCaseResultJob(uploadedPairs);
        job.setUser(true);
        job.schedule();
    }

    private ReportTestCaseLogPair getTestCaseLogPair(ReportEntity reportEntity) throws Exception {
        TestSuiteLogRecord testSuiteLogRecord = LogRecordLookup.getInstance().getTestSuiteLogRecord(reportEntity);
        if (testSuiteLogRecord == null) {
            return null;
        }
        if (QTestIntegrationUtil.getSelectedQTestSuite((TestSuiteLogRecord)testSuiteLogRecord) == null) {
            return null;
        }
        ArrayList<TestCaseLogRecord> testCasesCanBeUploaded = new ArrayList<TestCaseLogRecord>();
        ILogRecord[] iLogRecordArray = testSuiteLogRecord.getChildRecords();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord selectedTestCaseLogObject = iLogRecordArray[n2];
            TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)selectedTestCaseLogObject;
            switch (QTestIntegrationUtil.evaluateTestCaseLog((TestCaseLogRecord)testCaseLogRecord, (QTestSuite)QTestIntegrationUtil.getSelectedQTestSuite((TestSuiteLogRecord)testSuiteLogRecord), (ReportEntity)reportEntity)) {
                case CAN_INTEGRATE: {
                    testCasesCanBeUploaded.add(testCaseLogRecord);
                    break;
                }
            }
            ++n2;
        }
        if (testCasesCanBeUploaded.size() > 0) {
            return new ReportTestCaseLogPair(reportEntity, testCasesCanBeUploaded);
        }
        return null;
    }

    public static ReportUploadedPreviewPair transform(ReportTestCaseLogPair testCaseLogPair, Shell shell) {
        try {
            ReportEntity reportEntity = testCaseLogPair.getReportEntity();
            List testCasesCanBeUploaded = testCaseLogPair.getTestCaseLogs();
            ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
            TestSuiteLogRecord testSuiteLogRecord = LogRecordLookup.getInstance().getTestSuiteLogRecord(testCaseLogPair.getReportEntity());
            QTestSuite qTestSuite = QTestIntegrationUtil.getSelectedQTestSuite((TestSuiteLogRecord)testSuiteLogRecord);
            TestSuiteEntity testSuiteEntity = QTestIntegrationUtil.getTestSuiteEntity((TestSuiteLogRecord)testSuiteLogRecord);
            QTestProject qTestProject = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)testSuiteEntity, (ProjectEntity)projectEntity).getQTestProject();
            ArrayList<QTestLogUploadedPreview> uploadedPreviewLst = new ArrayList<QTestLogUploadedPreview>();
            for (TestCaseLogRecord testCaseLogRecord : testCasesCanBeUploaded) {
                QTestTestCase qTestCase = QTestIntegrationUtil.getQTestCase((TestCaseLogRecord)testCaseLogRecord);
                QTestLog qTestLog = new QTestLog();
                qTestLog.setAttachmentIncluded(true);
                qTestLog.setMessage(testCaseLogRecord.getMessage());
                qTestLog.setName(testCaseLogRecord.getName());
                QTestRun qTestRun = QTestIntegrationTestSuiteManager.getTestRunByTestSuiteAndTestCaseId((QTestSuite)qTestSuite, (long)qTestCase.getId());
                QTestLogUploadedPreview uploadedPreviewItem = new QTestLogUploadedPreview();
                uploadedPreviewItem.setQTestProject(qTestProject);
                uploadedPreviewItem.setQTestSuite(qTestSuite);
                uploadedPreviewItem.setQTestCase(qTestCase);
                uploadedPreviewItem.setQTestLog(qTestLog);
                uploadedPreviewItem.setQTestRun(qTestRun);
                uploadedPreviewItem.setTestLogIndex(QTestIntegrationUtil.getTestCaseLogIndexByIndexInReport((TestCaseLogRecord)testCaseLogRecord, (ReportEntity)reportEntity));
                uploadedPreviewItem.setTestCaseLogRecord(testCaseLogRecord);
                uploadedPreviewLst.add(uploadedPreviewItem);
            }
            return new ReportUploadedPreviewPair(reportEntity, uploadedPreviewLst);
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.VIEW_MSG_UNABLE_UPLOAD_TEST_RESULT, (String)e.getClass().getSimpleName());
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }

    @PreDestroy
    public void clearData() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            this.thread = null;
            this.canExecute = false;
        }
    }
}

