/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.job;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.util.StatusUtil;
import com.kms.katalon.composer.integration.qtest.constant.ComposerIntegrationQtestMessageConstants;
import com.kms.katalon.composer.integration.qtest.dialog.model.BatchCheckForTestCaseUpdatesResult;
import com.kms.katalon.composer.integration.qtest.job.QTestJob;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.QTestSyncStatusUtil;
import com.kms.katalon.integration.qtest.model.ParityReportSummary;
import java.io.InterruptedIOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CheckForTestCaseUpdatesBatchJob
extends QTestJob {
    private List<TestCaseEntity> testCases = new ArrayList<TestCaseEntity>();
    private BatchCheckForTestCaseUpdatesResult jobResult = new BatchCheckForTestCaseUpdatesResult();

    public CheckForTestCaseUpdatesBatchJob(String name, List<TestCaseEntity> testCases) {
        super(name);
        this.testCases.addAll(testCases);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(ComposerIntegrationQtestMessageConstants.CheckForUpdatesJob_CHECK_FOR_UPDATES_JOB, this.testCases.size());
        ProjectEntity project = this.getCurrentProject();
        try {
            for (TestCaseEntity testCase : this.testCases) {
                if (monitor.isCanceled()) {
                    throw new InterruptedIOException();
                }
                monitor.subTask(MessageFormat.format(ComposerIntegrationQtestMessageConstants.CheckForUpdatesJob_CHECK_FOR_UPDATE_OF_TEST_CASE, testCase.getIdForDisplay()));
                if (!QTestIntegrationUtil.isIntegrated((IntegratedFileEntity)testCase, (ProjectEntity)project)) {
                    monitor.worked(1);
                    continue;
                }
                QTestSyncStatusUtil.recursivelyUnmarkAllStatuses((IntegratedFileEntity)testCase, (ProjectEntity)project);
                ParityReportSummary summary = ParityReportSummary.getSummaryForTestCases(Arrays.asList(testCase));
                if (summary.hasError(testCase)) {
                    this.jobResult.addError(testCase, summary.getError(testCase));
                    QTestSyncStatusUtil.recursivelyMarkError((IntegratedFileEntity)testCase, (ProjectEntity)project);
                    continue;
                }
                if (!summary.hasTestCaseWithVersionChanged()) {
                    monitor.worked(1);
                    continue;
                }
                if (summary.hasTestCaseWithTestStepsChanged()) {
                    this.jobResult.addObsoleteTestCase(testCase);
                    QTestSyncStatusUtil.recursivelyMarkObsolete((IntegratedFileEntity)testCase, (ProjectEntity)project);
                }
                monitor.worked(1);
            }
            EventBrokerSingleton.getInstance().getEventBroker().post("EXPLORER/REFRESH", null);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            monitor.setCanceled(true);
            IStatus iStatus = StatusUtil.getErrorStatus(((Object)((Object)this)).getClass(), (Throwable)e);
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private ProjectEntity getCurrentProject() {
        return ProjectController.getInstance().getCurrentProject();
    }

    public BatchCheckForTestCaseUpdatesResult getCheckForUpdatesResult() {
        return this.jobResult;
    }
}

