/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.components.wizards;

import com.kms.katalon.composer.integration.git.components.utils.Protocol;
import com.kms.katalon.composer.integration.git.constants.GitStringConstants;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.KnownHosts;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.provisional.wizards.GitRepositoryInfo;
import org.eclipse.egit.ui.internal.provisional.wizards.IRepositorySearchResult;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CustomRepositorySelectionPage
extends WizardPage
implements IRepositorySearchResult {
    private static final String GIT_CLONE_COMMAND_PREFIX = "git clone ";
    private static final String EMPTY_STRING = "";
    private static final RepositorySelection INVALID_SELECTION = new RepositorySelection(null, null);
    private static final Pattern SSH_GIT_URI_PATTERN = Pattern.compile("^(?:git@[A-Za-z0-9._-]+:[A-Za-z0-9._/-]+|ssh://git@[A-Za-z0-9._-]+/[A-Za-z0-9._/-]+)(?:\\.git)?$");
    private final String presetUri;
    private Text uriText;
    private Text userText;
    private Text passText;
    private Button storeCheckbox;
    private int eventDepth;
    private URIish uri = new URIish();
    private RepositorySelection selection;
    private Composite uriPanel;
    private String user = "";
    private String password = "";
    private boolean storeInSecureStore;

    public CustomRepositorySelectionPage() {
        this(true, null);
    }

    public CustomRepositorySelectionPage(boolean sourceSelection, String presetUri) {
        this(sourceSelection, null, presetUri);
    }

    public CustomRepositorySelectionPage(boolean sourceSelection, List<RemoteConfig> configuredRemotes, String presetUri) {
        super(CustomRepositorySelectionPage.class.getName());
        configuredRemotes = this.getUsableConfigs(configuredRemotes);
        if (configuredRemotes != null && !configuredRemotes.isEmpty() && !configuredRemotes.get(0).getURIs().isEmpty()) {
            presetUri = ((URIish)configuredRemotes.get(0).getURIs().get(0)).toString();
        }
        if (presetUri == null) {
            presetUri = this.getPresetUriFromClipboard();
        }
        this.presetUri = presetUri;
        this.selection = INVALID_SELECTION;
        if (sourceSelection) {
            this.setTitle(UIText.RepositorySelectionPage_sourceSelectionTitle);
            this.setDescription(UIText.RepositorySelectionPage_sourceSelectionDescription);
        } else {
            this.setTitle(UIText.RepositorySelectionPage_destinationSelectionTitle);
            this.setDescription(UIText.RepositorySelectionPage_destinationSelectionDescription);
        }
        this.storeInSecureStore = this.getPreferenceStore().getBoolean("CloneWizard_StoreInSecureStore");
    }

    private String getPresetUriFromClipboard() {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        try {
            if (text == null) {
                return null;
            }
            text = this.stripGitCloneCommand(text);
            URIish u = new URIish(text = text.split("[ \\f\\n\\r\\x0B\\t\\xA0\\u1680\\u180e\\u2000-\\u200a\\u202f\\u205f\\u3000]", 2)[0]);
            if (this.canHandleProtocol(u) && (Protocol.GIT.handles(u) || Protocol.SSH.handles(u) || (Protocol.HTTP.handles(u) || Protocol.HTTPS.handles(u)) && KnownHosts.isKnownHost((String)u.getHost()) || text.endsWith(".git"))) {
                String string = text;
                return string;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        finally {
            clipboard.dispose();
        }
        return null;
    }

    private List<RemoteConfig> getUsableConfigs(List<RemoteConfig> remotes) {
        if (remotes == null) {
            return null;
        }
        ArrayList<RemoteConfig> result = new ArrayList<RemoteConfig>();
        for (RemoteConfig config : remotes) {
            if (config.getPushURIs().isEmpty() && config.getURIs().isEmpty()) continue;
            result.add(config);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    public RepositorySelection getSelection() {
        return this.selection;
    }

    public boolean selectionEquals(RepositorySelection s) {
        return this.selection.equals((Object)s);
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        this.createUriPanel(panel);
        if (this.presetUri != null) {
            this.updateFields(this.presetUri);
        }
        this.updateRemoteAndURIPanels();
        Dialog.applyDialogFont((Control)panel);
        this.setControl((Control)panel);
        this.checkPage();
    }

    private boolean canHandleProtocol(URIish u) {
        for (TransportProtocol proto : Transport.getTransportProtocols()) {
            if (!proto.canHandle(u)) continue;
            return true;
        }
        return false;
    }

    private void createUriPanel(Composite parent) {
        this.uriPanel = new Composite(parent, 0);
        this.uriPanel.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.uriPanel.setLayoutData((Object)gd);
        this.createLocationGroup(this.uriPanel);
        this.createAuthenticationGroup(this.uriPanel);
    }

    private void createLocationGroup(Composite parent) {
        Group g = this.createGroup(parent, UIText.RepositorySelectionPage_groupLocation);
        g.setLayout((Layout)new GridLayout(2, false));
        this.newLabel(g, GitStringConstants.LBL_REPOSITORY_URL + ":");
        this.uriText = new Text((Composite)g, 2048);
        if (this.presetUri != null) {
            this.uriText.setText(this.presetUri);
            this.uriText.selectAll();
        }
        this.uriText.setLayoutData((Object)this.createFieldGridData());
        this.uriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomRepositorySelectionPage.this.updateFields(CustomRepositorySelectionPage.this.uriText.getText());
            }
        });
    }

    private Group createAuthenticationGroup(Composite parent) {
        Group g = this.createGroup(parent, UIText.RepositorySelectionPage_groupAuthentication);
        this.newLabel(g, UIText.RepositorySelectionPage_promptUser + ":");
        this.userText = new Text((Composite)g, 2048);
        this.userText.setLayoutData((Object)this.createFieldGridData());
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomRepositorySelectionPage.this.user = CustomRepositorySelectionPage.this.userText.getText();
            }
        });
        this.newLabel(g, UIText.RepositorySelectionPage_promptPassword + ":");
        this.passText = new Text((Composite)g, 0x400800);
        this.passText.setLayoutData((Object)this.createFieldGridData());
        this.passText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomRepositorySelectionPage.this.password = CustomRepositorySelectionPage.this.passText.getText();
            }
        });
        this.storeCheckbox = new Button((Composite)g, 32);
        this.storeCheckbox.setText(GitStringConstants.CHCK_SAVE_AUTHENTICATION);
        this.storeCheckbox.setSelection(this.storeInSecureStore);
        this.storeCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomRepositorySelectionPage.this.storeInSecureStore = CustomRepositorySelectionPage.this.storeCheckbox.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CustomRepositorySelectionPage.this.storeInSecureStore = CustomRepositorySelectionPage.this.storeCheckbox.getSelection();
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.storeCheckbox);
        return g;
    }

    private Group createGroup(Composite parent, String text) {
        Group g = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        g.setLayout((Layout)layout);
        g.setText(text);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        g.setLayoutData((Object)gd);
        return g;
    }

    private void newLabel(Group g, String text) {
        new Label((Composite)g, 0).setText(text);
    }

    private GridData createFieldGridData() {
        return new GridData(4, -1, true, false);
    }

    private void safeSet(Text text, String value) {
        text.setText(value != null ? value : EMPTY_STRING);
    }

    protected void checkPage() {
        assert (this.uri != null);
        if (this.uriText.getText().length() == 0) {
            this.selectionIncomplete(null);
            return;
        }
        if (this.uriText.getText().endsWith(" ")) {
            this.selectionIncomplete(UIText.RepositorySelectionPage_UriMustNotHaveTrailingSpacesMessage);
            return;
        }
        try {
            UserPasswordCredentials credentials;
            URIish finalURI = new URIish(this.stripGitCloneCommand(this.uriText.getText()));
            if (!(Protocol.HTTPS.handles(finalURI) || Protocol.SSH.handles(finalURI) || Protocol.GIT.handles(finalURI))) {
                this.selectionIncomplete(GitStringConstants.MSG_ERR_REPOSITORY_URL_UNSUPPORTED_PROTOCOL);
                return;
            }
            String proto = finalURI.getScheme();
            if (this.uri.getPath() == null) {
                this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fieldRequired, (Object)this.unamp(UIText.RepositorySelectionPage_promptPath), (Object)proto));
                return;
            }
            if (this.uri.getHost() == null) {
                this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fieldRequired, (Object)this.unamp(UIText.RepositorySelectionPage_promptHost), (Object)proto));
                return;
            }
            if (Protocol.GIT.handles(finalURI)) {
                String badField = null;
                if (this.uri.getUser() != null) {
                    badField = UIText.RepositorySelectionPage_promptUser;
                } else if (this.uri.getPass() != null) {
                    badField = UIText.RepositorySelectionPage_promptPassword;
                }
                if (badField != null) {
                    this.selectionIncomplete(NLS.bind((String)UIText.RepositorySelectionPage_fieldNotSupported, (Object)this.unamp(badField), (Object)proto));
                    return;
                }
            }
            if (Protocol.HTTPS.handles(finalURI) && (credentials = SecureStoreUtils.getCredentials((URIish)finalURI)) != null) {
                String u = credentials.getUser();
                String p = credentials.getPassword();
                String uriUser = finalURI.getUser();
                if (uriUser == null) {
                    if (this.setSafeUser(u) && this.setSafePassword(p)) {
                        this.setStoreInSecureStore(true);
                    }
                } else if (uriUser.length() != 0 && uriUser.equals(u) && this.setSafePassword(p)) {
                    this.setStoreInSecureStore(true);
                }
            }
            this.selectionComplete(finalURI, null);
            return;
        }
        catch (URISyntaxException e) {
            this.selectionIncomplete(e.getReason());
            return;
        }
        catch (Exception e) {
            Activator.logError((String)NLS.bind((String)UIText.RepositorySelectionPage_errorValidating, (Object)((Object)((Object)this)).getClass().getName()), (Throwable)e);
            this.selectionIncomplete(UIText.RepositorySelectionPage_internalError);
            return;
        }
    }

    private String stripGitCloneCommand(String input) {
        if ((input = input.trim()).startsWith(GIT_CLONE_COMMAND_PREFIX)) {
            return input.substring(GIT_CLONE_COMMAND_PREFIX.length()).trim();
        }
        return input;
    }

    private boolean setSafePassword(String p) {
        if ((this.password == null || this.password.length() == 0) && p != null && p.length() != 0) {
            this.password = p;
            this.passText.setText(p);
            return true;
        }
        return false;
    }

    private boolean setSafeUser(String u) {
        if ((this.user == null || this.user.length() == 0) && u != null && u.length() != 0) {
            this.user = u;
            this.userText.setText(u);
            return true;
        }
        return false;
    }

    private void setStoreInSecureStore(boolean store) {
        this.storeInSecureStore = store;
        this.storeCheckbox.setSelection(store);
    }

    private String unamp(String s) {
        return s.replace("&", EMPTY_STRING);
    }

    private void selectionIncomplete(String errorMessage) {
        this.setExposedSelection(null, null);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(false);
    }

    private void selectionComplete(URIish u, RemoteConfig rc) {
        this.setExposedSelection(u, rc);
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void setExposedSelection(URIish u, RemoteConfig rc) {
        RepositorySelection newSelection = new RepositorySelection(u, rc);
        if (newSelection.equals((Object)this.selection)) {
            return;
        }
        this.selection = newSelection;
    }

    private void updateRemoteAndURIPanels() {
        UIUtils.setEnabledRecursively((Control)this.uriPanel, (boolean)true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.uriText.setFocus();
        }
    }

    public UserPasswordCredentials getCredentials() {
        if (!(this.user != null && this.user.length() != 0 || this.password != null && this.password.length() != 0)) {
            return null;
        }
        return new UserPasswordCredentials(this.user, this.password);
    }

    public boolean getStoreInSecureStore() {
        return this.storeInSecureStore;
    }

    private void updateFields(String text) {
        block6: {
            ++this.eventDepth;
            if (this.eventDepth == 1) break block6;
            --this.eventDepth;
            return;
        }
        try {
            try {
                String strippedText = this.stripGitCloneCommand(text);
                URIish u = new URIish(strippedText);
                if (!text.equals(strippedText)) {
                    this.uriText.setText(strippedText);
                }
                this.safeSet(this.userText, u.getUser());
                this.safeSet(this.passText, u.getPass());
                this.uri = u;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.uri = new URIish();
                this.userText.setText(EMPTY_STRING);
                this.passText.setText(EMPTY_STRING);
                --this.eventDepth;
            }
        }
        catch (Throwable throwable) {
            --this.eventDepth;
            throw throwable;
        }
        --this.eventDepth;
        this.checkPage();
    }

    private IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public GitRepositoryInfo getGitRepositoryInfo() {
        GitRepositoryInfo info = new GitRepositoryInfo(this.uri.toString());
        info.setCredentials(this.user, this.password);
        info.setShouldSaveCredentialsInSecureStore(this.storeInSecureStore);
        return info;
    }

    public boolean isGitSshRepositoryUrl() {
        String cloneUrl = this.uri.toString();
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{cloneUrl})) {
            return false;
        }
        return SSH_GIT_URI_PATTERN.matcher(cloneUrl).matches();
    }
}

