/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.menu;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.menu.MenuFactory;
import com.kms.katalon.composer.integration.git.constants.GitStringConstants;
import com.kms.katalon.composer.integration.git.handlers.BranchHandler;
import com.kms.katalon.composer.project.constants.StringConstants;
import com.kms.katalon.constants.helper.ConstantsHelper;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;

public class GitMenuContribution {
    @Inject
    protected ECommandService commandService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        MMenuFactory menuFactory = MMenuFactory.INSTANCE;
        if (!ApplicationInfo.isPlatformStudio()) {
            this.addChildMenuItem(items, "com.kms.katalon.composer.integration.git.command.clone", GitStringConstants.GIT_CLONE_MENU_ITEM_LABEL);
            this.addChildMenuItem(items, "com.kms.katalon.composer.integration.git.command.shareproject", GitStringConstants.GIT_SHARE_PROJECT_MENU_ITEM_LABEL);
        }
        this.addChildMenuItem(items, "com.kms.katalon.composer.integration.git.command.showHistory", GitStringConstants.GIT_SHOW_HISTORY_MENU_ITEM_LABEL);
        this.addGitBranchMenu(menuFactory, items);
        this.addChildMenuItem(items, "com.kms.katalon.composer.integration.git.command.commit", GitStringConstants.GIT_COMMIT_MENU_ITEM_LABEL);
        this.addChildMenuItem(items, "com.kms.katalon.composer.integration.git.command.push", GitStringConstants.GIT_PUSH_MENU_ITEM_LABEL);
        this.addChildMenuItem(items, "com.kms.katalon.composer.integration.git.command.pull", GitStringConstants.GIT_PULL_MENU_ITEM_LABEL);
        this.addChildMenuItem(items, "com.kms.katalon.composer.integration.git.command.fetch", GitStringConstants.GIT_FETCH_MENU_ITEM_LABEL);
        for (MMenuElement menuElement : items) {
            menuElement.setTooltip(StringConstants.EMPTY);
        }
    }

    public MDirectMenuItem createDisableMenuItem(MMenuFactory menuFactory, String menuItemLabel) {
        MDirectMenuItem disabledMenuItem = menuFactory.createDirectMenuItem();
        disabledMenuItem.setLabel(menuItemLabel);
        disabledMenuItem.setEnabled(false);
        return disabledMenuItem;
    }

    public void addGitBranchMenu(MMenuFactory menuFactory, List<MMenuElement> items) {
        if (!new BranchHandler().canExecute()) {
            items.add((MMenuElement)this.createDisableMenuItem(menuFactory, GitStringConstants.GIT_BRANCH_MENU_LABEL));
            return;
        }
        MMenu gitBranchMenu = menuFactory.createMenu();
        gitBranchMenu.setLabel(GitStringConstants.GIT_BRANCH_MENU_LABEL);
        List manageBranchChildren = gitBranchMenu.getChildren();
        this.addChildMenuItem(manageBranchChildren, "com.kms.katalon.composer.integration.git.command.branch.new", GitStringConstants.GIT_NEW_BRANCH_MENU_ITEM_LABEL);
        this.addChildMenuItem(manageBranchChildren, "com.kms.katalon.composer.integration.git.command.branch.checkOut", GitStringConstants.GIT_CHECKOUT_BRANCH_MENU_ITEM_LABEL);
        this.addChildMenuItem(manageBranchChildren, "com.kms.katalon.composer.integration.git.command.branch.delete", GitStringConstants.GIT_DELETE_BRANCH_MENU_ITEM_LABEL);
        this.addChildMenuItem(manageBranchChildren, "com.kms.katalon.composer.integration.git.command.branch", GitStringConstants.GIT_ADVANCE_BRANCH_MENU_ITEM_LABEL);
        items.add((MMenuElement)gitBranchMenu);
    }

    private void addChildMenuItem(List<MMenuElement> items, String commandId, String menuItemLabel) {
        MHandledMenuItem shareProjectmenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)this.commandService.createCommand(commandId, null), (String)menuItemLabel, (String)ConstantsHelper.getApplicationURI());
        items.add((MMenuElement)shareProjectmenuItem);
    }
}

