/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.auth;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.internal.util.Encoders;
import org.qas.api.internal.util.Https;
import org.qas.qtest.api.auth.AbstractQTestSigner;
import org.qas.qtest.api.auth.QTestCredentials;

public class QTest1Signer
extends AbstractQTestSigner {
    @Override
    protected void sign(Request request, QTestCredentials credentials) {
        this.addHostHeader(request);
        Date date = this.getDateFromRequest(request);
        request.setHeader("x-qtest-date", this.formatDateTime(date));
        String contentSha256 = request.getHeaders().get("x-qtest-content-sha256");
        if (contentSha256 == null || "required".equals(contentSha256)) {
            contentSha256 = this.calculateContentHash(request);
        }
        request.setHeader("x-qtest-content-sha256", contentSha256);
        request.setHeader("Authorization", credentials.getToken());
    }

    protected void addHostHeader(Request request) {
        String hostHeader = request.getEndpoint().getHost();
        if (Https.isUsingNonDefaultPort(request.getEndpoint())) {
            hostHeader = hostHeader + ":" + request.getEndpoint().getPort();
        }
        request.setHeader("Host", hostHeader);
    }

    protected String formatDateTime(Date date) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssZ");
        dateTimeFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return dateTimeFormat.format(date);
    }

    private Date getDateFromRequest(Request request) {
        return this.getSignatureDate(request.getTimeOffset());
    }

    protected String calculateContentHash(Request request) throws AuthClientException {
        InputStream payloadStream = this.getBinaryRequestPayloadStream(request);
        payloadStream.mark(Integer.MAX_VALUE);
        String contentSha256 = Encoders.bytesToHex(this.hash(payloadStream));
        try {
            payloadStream.reset();
        }
        catch (IOException ex) {
            throw new AuthClientException("Unable to reset stream after calculating qTest1 signature", ex);
        }
        return contentSha256;
    }
}

