/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.design.model.ListTestCaseRequest;
import org.qas.qtest.api.services.design.model.transform.AbstractTestCaseRequestMarshaller;

public final class ListTestCaseRequestMarshaller
extends AbstractTestCaseRequestMarshaller<ListTestCaseRequest> {
    @Override
    public Request marshall(ListTestCaseRequest listTestCaseRequest) throws Exception {
        listTestCaseRequest = ApiPreconditions.notNull(listTestCaseRequest);
        ListTestCaseRequestMarshaller.validateProjectId(listTestCaseRequest.getProjectId());
        ApiPreconditions.checkArgument(listTestCaseRequest.getModuleId() == null || listTestCaseRequest.getModuleId() > 0L, "Invalid module identifier passed to marshall(...)");
        Request request = this.createJsonRequest(listTestCaseRequest, "ListTestCase", HttpMethod.GET);
        if (listTestCaseRequest.getModuleId() == null) {
            request.setResourcePath(this.createApiPathBuilder(listTestCaseRequest.getProjectId()).toString());
        } else {
            StringBuilder pathBuilder = new StringBuilder(this.createApiBasePathWithProject(listTestCaseRequest.getProjectId()));
            pathBuilder.append("/test-cases");
            request.setResourcePath(pathBuilder.toString());
            request.addParameter("parentId", String.valueOf(listTestCaseRequest.getModuleId()));
        }
        if (listTestCaseRequest.getPage() != null && listTestCaseRequest.getPage() > 0L) {
            request.addParameter("page", String.valueOf(listTestCaseRequest.getPage()));
        }
        if (listTestCaseRequest.getPageSize() != null && listTestCaseRequest.getPageSize() > 0L) {
            request.addParameter("size", String.valueOf(listTestCaseRequest.getPageSize()));
        }
        return request;
    }
}

