/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.composer.custom.component;

import com.katalon.capability.composer.custom.dialog.CustomCapabilityBuilderDialog;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.model.CustomCapabilitySetting;
import com.katalon.capability.model.ICapabilitySetting;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CustomCapabilityCellEditor
extends DialogCellEditor {
    public CustomCapabilityCellEditor(Composite parent) {
        super(parent);
        this.setValidator(value -> {
            if (value instanceof CustomCapabilitySetting) {
                return null;
            }
            return "Invalid Type";
        });
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        CustomCapabilitySetting currentValue = (CustomCapabilitySetting)this.getValue();
        CustomCapabilityBuilderDialog dialog = new CustomCapabilityBuilderDialog(cellEditorWindow.getShell(), currentValue.clone());
        int result = dialog.open();
        if (result == 0) {
            CustomCapabilitySetting customCapabilityDTO = dialog.getCustomCapabilityDTO();
            Collection capabilitySettings = customCapabilityDTO.getValues().values();
            LinkedHashMap<DriverType, ICapabilitySetting> map = new LinkedHashMap<DriverType, ICapabilitySetting>();
            for (ICapabilitySetting capabilitySetting : capabilitySettings) {
                map.put((DriverType)capabilitySetting.getSupportedDriverTypes().get(0), capabilitySetting);
            }
            customCapabilityDTO.setValues(map);
            return customCapabilityDTO;
        }
        return currentValue;
    }
}

