/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.composer.custom.dialog;

import com.katalon.capability.composer.common.component.CapabilityComposite;
import com.katalon.capability.composer.common.constant.CapabilityUITextConstant;
import com.katalon.capability.composer.common.dialog.ImportCapabilitiesDialog;
import com.katalon.capability.controller.ICapabilityController;
import com.katalon.capability.dto.ImportCapabilityRequest;
import com.katalon.capability.model.CapabilitySetting;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.core.util.ApplicationContextUtil;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CapabilityBuilderDialog
extends Dialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapabilityBuilderDialog.class);
    protected final CapabilitySetting capabilitySetting;
    protected CapabilityComposite capabilityComposite;
    protected final ICapabilityController capabilityController;
    protected final IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private Button btnImport;
    private Button btnExport;

    public CapabilityBuilderDialog(Shell parentShell, CapabilitySetting capabilitySetting) {
        super(parentShell);
        this.capabilitySetting = capabilitySetting;
        this.capabilityController = (ICapabilityController)ApplicationContextUtil.getBean(ICapabilityController.class);
        this.featureController = (IFeatureController)ApplicationContextUtil.getBean(IFeatureController.class);
    }

    public CapabilitySetting getCapabilityDTO() {
        return this.capabilityComposite.getCapability();
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Capability Builder");
    }

    public void createButtonsForButtonBar(Composite parent) {
        GridLayout parentLayout = (GridLayout)parent.getLayout();
        parentLayout.numColumns += 2;
        this.btnImport = new Button(parent, 0x1000000);
        this.btnImport.setText("Import");
        this.setButtonLayoutData(this.btnImport);
        this.btnExport = new Button(parent, 0x1000000);
        this.btnExport.setText("Export");
        this.setButtonLayoutData(this.btnExport);
        super.createButtonsForButtonBar(parent);
        this.addControlListeners();
    }

    private void addControlListeners() {
        this.btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!CapabilityBuilderDialog.this.canUseImportExportDesiredCapabilities()) {
                    CapabilityBuilderDialog.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
                    return;
                }
                ImportCapabilitiesDialog importDialog = new ImportCapabilitiesDialog(CapabilityBuilderDialog.this.getShell());
                if (importDialog.open() == 0) {
                    CapabilityBuilderDialog.this.importPropertiesFromFile(importDialog.getFilePath(), importDialog.isOverridingExistingProperties());
                }
            }
        });
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!CapabilityBuilderDialog.this.canUseImportExportDesiredCapabilities()) {
                    CapabilityBuilderDialog.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
                    return;
                }
                FileDialog exportFileDialog = new FileDialog(CapabilityBuilderDialog.this.getShell(), 8192);
                exportFileDialog.setFilterNames(CapabilityUITextConstant.IMPORT_EXPORT_DESIRED_CAPABILITIES_FILTER_NAMES);
                exportFileDialog.setFilterExtensions(CapabilityUITextConstant.IMPORT_EXPORT_DESIRED_CAPABILITIES_FILTER_EXTS);
                exportFileDialog.setOverwrite(true);
                exportFileDialog.setFileName(CapabilityBuilderDialog.this.generateDefaultExportFileName());
                String filePath = exportFileDialog.open();
                if (filePath != null) {
                    CapabilityBuilderDialog.this.exportPropertiesToFile(filePath);
                }
            }
        });
    }

    protected void exportPropertiesToFile(String exportFilePath) {
        try {
            this.capabilityController.exportCapability(exportFilePath, this.capabilityComposite.getCapability());
        }
        catch (Exception exception) {
            LOGGER.error("Exception while exportPropertiesToFile", (Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)MessageFormat.format("Unable to export to file {0}", exportFilePath), (String)exception.getMessage());
        }
    }

    protected void importPropertiesFromFile(String importFilePath, boolean isOverridingExistingProperties) {
        try {
            CapabilitySetting capabilitySetting = this.capabilityController.importCapability(new ImportCapabilityRequest(this.capabilitySetting.getDriverType(), importFilePath, isOverridingExistingProperties));
            this.setCapability(capabilitySetting);
        }
        catch (Exception exception) {
            LOGGER.error("Exception while importPropertiesFromFile", (Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)MessageFormat.format("Unable to import from file {0}", importFilePath), (String)exception.getMessage());
        }
    }

    protected void setCapability(CapabilitySetting capabilitySetting) {
        this.capabilityComposite.setCapability(capabilitySetting);
    }

    protected String generateDefaultExportFileName() {
        String driverTypeName = this.capabilitySetting.getDriverType().name().toLowerCase();
        driverTypeName = driverTypeName.substring(0, driverTypeName.indexOf("_driver"));
        return driverTypeName + "_caps.json";
    }

    private boolean canUseImportExportDesiredCapabilities() {
        return this.featureController.canUse(ProductFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
    }
}

