/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.composer.custom.page;

import com.katalon.capability.composer.common.constant.CapabilityUITextConstant;
import com.katalon.capability.composer.custom.component.NameColumnLabelProvider;
import com.katalon.capability.composer.custom.component.ValueColumnLabelProvider;
import com.katalon.capability.composer.custom.support.NameColumnEditingSupport;
import com.katalon.capability.composer.custom.support.ValueColumnEditingSupport;
import com.katalon.capability.controller.ICustomCapabilityController;
import com.katalon.capability.exception.MismatchCapabilityTypeException;
import com.katalon.capability.exception.UnsupportedDriverTypeException;
import com.katalon.capability.exception.WriteCapabilityException;
import com.katalon.capability.exception.WriteCustomCapabilityException;
import com.katalon.capability.model.CustomCapabilitySetting;
import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.ApplicationContextUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCapabilitySettingPage
extends PreferencePageWithHelp {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomCapabilitySettingPage.class);
    private static final String DEFAULT_CUSTOM_CONFIGURATION_NAME = "custom";
    private static final String CUSTOM_EXECUTION_CONFIG_ROOT_FOLDER_RELATIVE_PATH = PropertySettingStoreUtil.EXTERNAL_SETTING_ROOT_FOLDER_NAME + File.separator + "execution";
    private Table table;
    private TableViewer tableViewer;
    private ToolItem tltmAddProperty;
    private ToolItem tltmRemoveProperty;
    private ToolItem tltmClearProperty;
    private final ICustomCapabilityController customCapabilityController = (ICustomCapabilityController)ApplicationContextUtil.getBean(ICustomCapabilityController.class);
    private List<CustomCapabilitySetting> customCapabilitySettings;

    public CustomCapabilitySettingPage() {
        try {
            this.customCapabilitySettings = this.customCapabilityController.getAllCustomCapabilities();
        }
        catch (MismatchCapabilityTypeException exception) {
            LOGGER.error("Exception while importPropertiesFromFile", (Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)"Error while getting all custom capabilities", (String)exception.getMessage());
        }
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Composite formComposite = new Composite(container, 0);
        formComposite.setLayout((Layout)new GridLayout(1, false));
        formComposite.setLayoutData((Object)new GridData(1808));
        Composite toolbarComposite = new Composite(formComposite, 0);
        toolbarComposite.setLayout((Layout)new FillLayout(256));
        toolbarComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(toolbarComposite, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.tltmAddProperty = new ToolItem(toolBar, 0);
        this.tltmAddProperty.setText(CapabilityUITextConstant.SETT_TOOLITEM_ADD);
        this.tltmAddProperty.setImage(ImageConstants.IMG_16_ADD);
        this.tltmRemoveProperty = new ToolItem(toolBar, 0);
        this.tltmRemoveProperty.setText(CapabilityUITextConstant.SETT_TOOLITEM_DELETE);
        this.tltmRemoveProperty.setImage(ImageConstants.IMG_16_REMOVE);
        this.tltmClearProperty = new ToolItem(toolBar, 0);
        this.tltmClearProperty.setText(CapabilityUITextConstant.SETT_TOOLITEM_CLEAR);
        this.tltmClearProperty.setImage(ImageConstants.IMG_16_CLEAR);
        this.addToolItemListeners();
        Composite composite = new Composite(formComposite, 0);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new TableViewer(tableComposite, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(ControlUtils.shouldLineVisble((Display)this.table.getDisplay()));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.addTableColumn(this.tableViewer, tableColumnLayout, CapabilityUITextConstant.SETT_COL_PREFERENCE_NAME, 100, 30, new NameColumnEditingSupport(this.tableViewer), (CellLabelProvider)new NameColumnLabelProvider());
        this.addTableColumn(this.tableViewer, tableColumnLayout, CapabilityUITextConstant.SETT_COL_PREFERENCE_VALUE, 100, 70, new ValueColumnEditingSupport(this.tableViewer), (CellLabelProvider)new ValueColumnLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.customCapabilitySettings);
        return container;
    }

    private void addTableColumn(TableViewer parent, TableColumnLayout tableColumnLayout, String headerText, int width, int weight, EditingSupport editingSupport, CellLabelProvider labelProvider) {
        TableViewerColumn tableColumn = new TableViewerColumn(parent, 0);
        tableColumn.getColumn().setWidth(width);
        tableColumn.getColumn().setMoveable(true);
        tableColumn.getColumn().setText(headerText);
        tableColumn.setLabelProvider(labelProvider);
        tableColumn.setEditingSupport(editingSupport);
        tableColumnLayout.setColumnData((Widget)tableColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, tableColumn.getColumn().getWidth()));
    }

    private void addToolItemListeners() {
        this.tltmAddProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCapabilitySettingPage.this.customCapabilitySettings.add(new CustomCapabilitySetting(CustomCapabilitySettingPage.this.generateNewCustomConfigurationName()));
                CustomCapabilitySettingPage.this.tableViewer.refresh();
            }
        });
        this.tltmRemoveProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CustomCapabilitySettingPage.this.tableViewer.getSelection();
                if (!selection.isEmpty()) {
                    for (Object selectedObject : selection.toList()) {
                        if (!(selectedObject instanceof CustomCapabilitySetting)) continue;
                        CustomCapabilitySetting customCapabilitySetting = (CustomCapabilitySetting)selectedObject;
                        CustomCapabilitySettingPage.this.customCapabilitySettings.remove(customCapabilitySetting);
                    }
                    CustomCapabilitySettingPage.this.tableViewer.refresh();
                }
            }
        });
        this.tltmClearProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCapabilitySettingPage.this.customCapabilitySettings.clear();
                CustomCapabilitySettingPage.this.tableViewer.refresh();
            }
        });
    }

    private String generateNewCustomConfigurationName() {
        String name = DEFAULT_CUSTOM_CONFIGURATION_NAME;
        boolean exists = false;
        for (CustomCapabilitySetting customCapabilitySetting : this.customCapabilitySettings) {
            if (!customCapabilitySetting.getName().equalsIgnoreCase(name)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            return name;
        }
        int index = 0;
        boolean isUnique = false;
        block1: while (!isUnique) {
            String newName = name + "_" + ++index;
            isUnique = true;
            for (CustomCapabilitySetting customCapabilitySetting : this.customCapabilitySettings) {
                if (!customCapabilitySetting.getName().equalsIgnoreCase(newName)) continue;
                isUnique = false;
                continue block1;
            }
        }
        return name + "_" + index;
    }

    public boolean performOk() {
        try {
            this.customCapabilityController.saveCapabilities(this.customCapabilitySettings);
            return true;
        }
        catch (UnsupportedDriverTypeException | WriteCapabilityException | WriteCustomCapabilityException | IOException ioException) {
            LOGGER.error("Exception while save custom capabilities", ioException);
            MultiStatusErrorDialog.showErrorDialog((Throwable)ioException, (String)"Exception while save custom capabilities", (String)ioException.getMessage());
            return false;
        }
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_EXECUTION;
    }
}

