/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.composer.custom.support;

import com.katalon.capability.constant.DriverPlatform;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.model.CapabilitySetting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

public class BuilderDialogNameColumnSupport
extends EditingSupport {
    private final Supplier<Map<DriverType, Boolean>> getAvailableDriverTypes;
    private final Consumer<DriverType> markSelectedDriverType;
    private final Consumer<DriverType> markUnselectedDriverType;
    private final TableViewer tableViewer;
    private final List<String> displayDriverTypes = new ArrayList<String>();
    private DriverType lastSelectedDriverType;

    public BuilderDialogNameColumnSupport(TableViewer tableViewer, Supplier<Map<DriverType, Boolean>> getAvailableDriverTypes, Consumer<DriverType> markSelectedDriverType, Consumer<DriverType> markUnselectedDriverType) {
        super((ColumnViewer)tableViewer);
        this.tableViewer = tableViewer;
        this.getAvailableDriverTypes = getAvailableDriverTypes;
        this.markSelectedDriverType = markSelectedDriverType;
        this.markUnselectedDriverType = markUnselectedDriverType;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof CapabilitySetting) {
            CapabilitySetting capabilitySetting = (CapabilitySetting)element;
            this.lastSelectedDriverType = capabilitySetting.getDriverType();
            DriverPlatform driverPlatform = capabilitySetting.getDriverType().getDriverPlatform();
            this.displayDriverTypes.clear();
            for (Map.Entry<DriverType, Boolean> entry : this.getAvailableDriverTypes.get().entrySet()) {
                if (!entry.getValue().booleanValue() && entry.getKey().getDriverPlatform() != driverPlatform) continue;
                this.displayDriverTypes.add(entry.getKey().getDisplayName());
            }
            return new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), this.displayDriverTypes.toArray(new String[0]));
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        return element instanceof CapabilitySetting;
    }

    protected Object getValue(Object element) {
        if (element instanceof CapabilitySetting) {
            CapabilitySetting capabilitySetting = (CapabilitySetting)element;
            DriverType driverType = capabilitySetting.getDriverType();
            return this.displayDriverTypes.indexOf(driverType.getDisplayName());
        }
        return 0;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof CapabilitySetting) {
            CapabilitySetting capabilitySetting = (CapabilitySetting)element;
            if (value instanceof Integer) {
                String selectedDriverTypeName;
                DriverType selectedDriverType;
                Integer selectedIndex = (Integer)value;
                if (selectedIndex < 0) {
                    selectedIndex = 0;
                }
                if ((selectedDriverType = DriverType.fromDisplayName((String)(selectedDriverTypeName = this.displayDriverTypes.get(selectedIndex)))) == null) {
                    return;
                }
                capabilitySetting.setDriverType(selectedDriverType);
                if (this.lastSelectedDriverType != null) {
                    this.markUnselectedDriverType.accept(this.lastSelectedDriverType);
                }
                this.markSelectedDriverType.accept(selectedDriverType);
                this.tableViewer.refresh();
            }
        }
    }
}

