/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.dialog;

import java.util.ArrayList;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class MarkdownLabel
extends Composite {
    private StyledText styledText;

    public MarkdownLabel(Composite parent, int style) {
        super(parent, 786432);
        this.setLayout((Layout)new FillLayout());
        this.styledText = new StyledText((Composite)this, style | 8 | 0x40);
        this.styledText.setWordWrap(true);
        this.styledText.setEditable(false);
        this.styledText.setBackground(parent.getBackground());
        this.styledText.setCaret(null);
    }

    public void setText(String text) {
        int boldStart;
        StringBuilder plainTextBuilder = new StringBuilder();
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        int currentIndex = 0;
        int plainTextIndex = 0;
        while ((boldStart = text.indexOf("**", currentIndex)) != -1) {
            String normalText = text.substring(currentIndex, boldStart);
            plainTextBuilder.append(normalText);
            plainTextIndex += normalText.length();
            int boldEnd = text.indexOf("**", boldStart + 2);
            if (boldEnd != -1) {
                String boldText = text.substring(boldStart + 2, boldEnd);
                StyleRange styleRange = new StyleRange();
                styleRange.start = plainTextIndex;
                styleRange.length = boldText.length();
                styleRange.fontStyle = 1;
                styleRanges.add(styleRange);
                plainTextBuilder.append(boldText);
                plainTextIndex += boldText.length();
                currentIndex = boldEnd + 2;
                continue;
            }
            plainTextBuilder.append(text.substring(boldStart));
            break;
        }
        if (currentIndex < text.length()) {
            plainTextBuilder.append(text.substring(currentIndex));
        }
        this.styledText.setText(plainTextBuilder.toString());
        for (StyleRange range : styleRanges) {
            this.styledText.setStyleRange(range);
        }
    }

    public String getText() {
        return this.styledText.getText();
    }

    public void setFont(Font font) {
        this.styledText.setFont(font);
    }

    public void setBackground(Color color) {
        this.styledText.setBackground(color);
    }

    public void setForeground(Color color) {
        this.styledText.setForeground(color);
    }

    public void dispose() {
        if (this.styledText != null && !this.styledText.isDisposed()) {
            this.styledText.dispose();
        }
        super.dispose();
    }
}

