/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.dialog;

import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.migration.model.MigrationAttempt;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

public class MigrationHistoryDialog
extends Dialog {
    private final List<MigrationAttempt> attempts;
    private MigrationAttempt selectedAttempt;
    private Consumer<MigrationAttempt> revertHandler;

    public MigrationHistoryDialog(Shell parentShell, List<MigrationAttempt> attempts) {
        super(parentShell);
        this.attempts = attempts;
    }

    public void setRevertHandler(Consumer<MigrationAttempt> revertHandler) {
        this.revertHandler = revertHandler;
    }

    public MigrationAttempt getSelectedAttempt() {
        return this.selectedAttempt;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Revert to original version");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        ComponentUtil.setMargin((Composite)container, (int)10, (int)10);
        ComponentBuilder.label((Composite)container).text("Select the version you wish to revert back").center().fill().build();
        Group attemptGroup = (Group)ComponentBuilder.group((Composite)container, (int)0).gridLayout(1, false).fill().build();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Button[] radioButtons = new Button[this.attempts.size()];
        int i = 0;
        while (i < this.attempts.size()) {
            int idx = i;
            MigrationAttempt attempt = this.attempts.get(i);
            radioButtons[i] = (Button)ComponentBuilder.button((Composite)attemptGroup, (int)16).text(attempt.getStartTime() != null ? sdf.format(attempt.getStartTime()) : attempt.getAttemptId()).data((Object)attempt).fill().onSelection(e -> {
                if (radioButtons[idx].getSelection()) {
                    this.selectedAttempt = attempt;
                }
            }).build();
            ++i;
        }
        if (radioButtons.length > 0) {
            radioButtons[0].setSelection(true);
            this.selectedAttempt = (MigrationAttempt)radioButtons[0].getData();
        }
        ComponentBuilder.label((Composite)container, (int)64).text("\u26a0\ufe0f Note: The reverted version may be incompatible with the current Studio version.").center().fill().build();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button revertButton = this.createButton(parent, 0, "Revert anyway", true);
        revertButton.addListener(13, e -> {
            if (this.revertHandler != null && this.selectedAttempt != null) {
                this.revertHandler.accept(this.selectedAttempt);
            }
            this.close();
        });
        Button cancelButton = this.createButton(parent, 1, "Cancel", false);
        cancelButton.addListener(13, e -> {
            boolean bl = this.close();
        });
    }
}

