/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service;

import com.kms.katalon.migration.model.MigrationPlan;
import com.kms.katalon.migration.service.recipes.ks8to10.AddBDDTestListener;
import com.kms.katalon.migration.service.recipes.ks9to10.AddInteractsWithApps;
import com.kms.katalon.migration.service.recipes.ks9to10.DesiredCapsToOptions;
import com.kms.katalon.migration.service.recipes.ks9to10.DesiredCapsWithW3CPrefix;
import com.kms.katalon.migration.service.recipes.ks9to10.FindElementBy;
import com.kms.katalon.migration.service.recipes.ks9to10.FindElementByPlainText;
import com.kms.katalon.migration.service.recipes.ks9to10.RemoveSmartWaitWebDriver;
import com.kms.katalon.migration.service.recipes.ks9to10.ReplaceGenericAppiumDriver;
import com.kms.katalon.migration.service.recipes.ks9to10.ReplaceGenericAppiumDriverPlainText;
import com.kms.katalon.migration.service.recipes.ks9to10.ReplaceGetChromeDriverPath;
import com.kms.katalon.migration.service.recipes.ks9to10.touchaction.MultiTouchActionToPointerInput;
import com.kms.katalon.migration.service.recipes.ks9to10.touchaction.TouchActionToPointerInput;
import java.util.ArrayList;
import org.openrewrite.Recipe;
import org.openrewrite.config.CompositeRecipe;
import org.openrewrite.config.Environment;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.RemoveUnusedImports;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationPlanManager {
    private Logger logger = LoggerFactory.getLogger(MigrationPlanManager.class);

    public MigrationPlan resolve(String fromVersion, String toVersion) {
        MigrationPlan migrationPlan = new MigrationPlan();
        migrationPlan.setFromVersion(fromVersion);
        migrationPlan.setToVersion(toVersion);
        if ("9".equals(fromVersion) && "10".equals(toVersion)) {
            migrationPlan.setName("Migration from Katalon Studio 9 to 10");
            migrationPlan.setGroovyAstRecipe(this.buildGroovyAstRecipeFrom9to10());
            migrationPlan.setGroovyNonAstRecipe(this.buildGroovyNonAstRecipeFrom9to10());
            migrationPlan.setJsonPropertiesRecipe(this.buildJsonPropertiesRecipeFrom9to10());
            migrationPlan.setDocumentationLink("https://docs.katalon.com/katalon-studio/get-started/workspace-settings/migrate-katalon-studio-from-9.x-to-10.0.0");
            return migrationPlan;
        }
        if ("8".equals(fromVersion) && "10".equals(toVersion)) {
            migrationPlan.setName("Migration from Katalon Studio 8 to 10");
            migrationPlan.setGroovyAstRecipe(this.buildGroovyAstRecipeFrom9to10());
            migrationPlan.setGroovyNonAstRecipe(this.buildGroovyNonAstRecipeFrom9to10());
            migrationPlan.setJsonPropertiesRecipe(this.buildJsonPropertiesRecipeFrom9to10());
            migrationPlan.setScanningRecipe((Recipe)new AddBDDTestListener());
            migrationPlan.setDocumentationLink("https://docs.katalon.com/katalon-studio/get-started/workspace-settings/migrate-katalon-studio-from-8.x-to-10.x");
            return migrationPlan;
        }
        return null;
    }

    private Recipe buildGroovyAstRecipeFrom9to10() {
        ArrayList<Object> recipes = new ArrayList<Object>();
        Recipe jakartaRecipe = this.loadRecipeFromRuntimeEnvironment("org.openrewrite.java.migrate.jakarta.JavaxMigrationToJakarta");
        if (jakartaRecipe != null) {
            recipes.add(jakartaRecipe);
        }
        recipes.add((Object)new DesiredCapsToOptions());
        recipes.add((Object)new ReplaceGenericAppiumDriver());
        recipes.add(new ChangeType("io.appium.java_client.MobileElement", "org.openqa.selenium.WebElement", null));
        recipes.add((Object)new RemoveSmartWaitWebDriver());
        recipes.add((Object)new AddInteractsWithApps());
        recipes.add((Object)new ReplaceGetChromeDriverPath());
        recipes.add((Object)new FindElementBy());
        recipes.add((Object)new MultiTouchActionToPointerInput());
        recipes.add((Object)new TouchActionToPointerInput());
        recipes.add(new RemoveUnusedImports());
        return new CompositeRecipe(recipes);
    }

    private Recipe buildGroovyNonAstRecipeFrom9to10() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        recipes.add(new ReplaceGenericAppiumDriverPlainText());
        recipes.add(new FindElementByPlainText());
        return new CompositeRecipe(recipes);
    }

    private Recipe buildJsonPropertiesRecipeFrom9to10() {
        ArrayList<DesiredCapsWithW3CPrefix> recipes = new ArrayList<DesiredCapsWithW3CPrefix>();
        recipes.add(new DesiredCapsWithW3CPrefix());
        return new CompositeRecipe(recipes);
    }

    private Recipe loadRecipeFromRuntimeEnvironment(String recipeName) {
        Environment environment = Environment.builder().scanRuntimeClasspath(new String[0]).build();
        try {
            return environment.activateRecipes(new String[]{recipeName});
        }
        catch (Throwable e) {
            this.logger.error("Failed to load recipe: " + recipeName, e);
            return null;
        }
    }
}

