/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service.recipes.ks9to10;

import com.kms.katalon.migration.model.AppiumConstants;
import com.kms.katalon.migration.service.AstRecipeHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.jgit.util.StringUtils;
import org.openrewrite.marker.Marker;

public class DesiredCapsToOptions
extends Recipe {
    public String getDisplayName() {
        return "Migrate DesiredCapabilities to Options";
    }

    public String getDescription() {
        return "Migrates usage of DesiredCapabilities to FirefoxOptions/ChromeOptions with proper capability mapping";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){
            private final JavaTemplate FIREFOX_OPTIONS_DECLARATION = JavaTemplate.builder((String)"FirefoxOptions #{} = new FirefoxOptions()").build();
            private final JavaTemplate CHROME_OPTIONS_DECLARATION = JavaTemplate.builder((String)"ChromeOptions #{} = new ChromeOptions()").build();
            private final JavaTemplate EDGE_OPTIONS_DECLARATION = JavaTemplate.builder((String)"EdgeOptions #{} = new EdgeOptions()").build();
            private final JavaTemplate CLOUD_OPTIONS_PUT = JavaTemplate.builder((String)"#{}.put(#{any()}, #{any()})").build();
            private final Map<String, JavaTemplate> W3C_SET_CAP_TEMPLATES = this.createW3CSetCapTemplates();
            private final JavaTemplate SET_CAP_TEMPLATE = JavaTemplate.builder((String)"#{}.setCapability(#{any()}, #{any()})").build();
            private final Set<String> importsToAdd = new HashSet<String>();

            private Map<String, JavaTemplate> createW3CSetCapTemplates() {
                return Map.of("platform", JavaTemplate.builder((String)"#{}.setPlatformName(#{any()})").build(), "version", JavaTemplate.builder((String)"#{}.setBrowserVersion(#{any()})").build(), "acceptSslCerts", JavaTemplate.builder((String)"#{}.setAcceptInsecureCerts(#{any()})").build(), "unexpectedAlertBehaviour", JavaTemplate.builder((String)"#{}.setUnhandledPromptBehaviour(#{any()})").build(), "pageLoadStrategy", JavaTemplate.builder((String)"#{}.setPageLoadStrategy(#{any()})").build());
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.Identifier typeId;
                J.VariableDeclarations varDecls = (J.VariableDeclarations)super.visitVariableDeclarations(multiVariable, (Object)ctx);
                J.VariableDeclarations newVarDecls = null;
                TypeTree typeTree = varDecls.getTypeExpression();
                if (typeTree instanceof J.Identifier && "DesiredCapabilities".equals((typeId = (J.Identifier)typeTree).getSimpleName())) {
                    String varName = ((J.VariableDeclarations.NamedVariable)varDecls.getVariables().get(0)).getName().getSimpleName();
                    J.VariableDeclarations.NamedVariable var = (J.VariableDeclarations.NamedVariable)varDecls.getVariables().get(0);
                    Expression expression = var.getInitializer();
                    if (expression instanceof J.MethodInvocation) {
                        J.MethodInvocation init = (J.MethodInvocation)expression;
                        if (this.isDesiredCapabilitiesFirefox(init)) {
                            newVarDecls = (J.VariableDeclarations)this.FIREFOX_OPTIONS_DECLARATION.apply(this.updateCursor((Tree)varDecls), varDecls.getCoordinates().replace(), new Object[]{varName});
                            this.importsToAdd.add("org.openqa.selenium.firefox.FirefoxOptions");
                        } else if (this.isDesiredCapabilitiesChrome(init)) {
                            newVarDecls = (J.VariableDeclarations)this.CHROME_OPTIONS_DECLARATION.apply(this.updateCursor((Tree)varDecls), varDecls.getCoordinates().replace(), new Object[]{varName});
                            this.importsToAdd.add("org.openqa.selenium.chrome.ChromeOptions");
                        } else if (this.isDesiredCapabilitiesEdge(init)) {
                            newVarDecls = (J.VariableDeclarations)this.EDGE_OPTIONS_DECLARATION.apply(this.updateCursor((Tree)varDecls), varDecls.getCoordinates().replace(), new Object[]{varName});
                            this.importsToAdd.add("org.openqa.selenium.edge.EdgeOptions");
                        }
                    }
                }
                if (newVarDecls != null) {
                    return newVarDecls;
                }
                return varDecls;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation methodCall = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (!this.isSetCapabilityCall(methodCall)) {
                    return methodCall;
                }
                Expression originalCapKey = (Expression)methodCall.getArguments().get(0);
                Expression originalCapValue = (Expression)methodCall.getArguments().get(1);
                Expression convertedCapKey = this.convertMobileCapKey(originalCapKey);
                String capabilityName = this.extractStringValue(convertedCapKey);
                if (capabilityName == null) {
                    return methodCall;
                }
                String browserOptionsVarName = AstRecipeHelper.getVariableName(methodCall);
                if ("browserName".equals(capabilityName)) {
                    return methodCall;
                }
                if (this.W3C_SET_CAP_TEMPLATES.containsKey(capabilityName)) {
                    String strValue;
                    JavaTemplate template = this.W3C_SET_CAP_TEMPLATES.get(capabilityName);
                    Expression convertedValue = originalCapValue;
                    if ("unexpectedAlertBehaviour".equals(capabilityName)) {
                        String strValue2 = this.extractStringValue(originalCapValue);
                        if (strValue2 != null) {
                            convertedValue = AstRecipeHelper.createEnumFieldAccess(this.convertToUnexpectedAlertBehaviour(strValue2));
                            this.importsToAdd.add("org.openqa.selenium.UnexpectedAlertBehaviour");
                        }
                    } else if ("pageLoadStrategy".equals(capabilityName) && (strValue = this.extractStringValue(originalCapValue)) != null) {
                        convertedValue = AstRecipeHelper.createEnumFieldAccess(this.convertToPageLoadStrategy(strValue));
                        this.importsToAdd.add("org.openqa.selenium.PageLoadStrategy");
                    }
                    return (J.MethodInvocation)template.apply(this.getCursor(), methodCall.getCoordinates().replace(), new Object[]{browserOptionsVarName, convertedValue});
                }
                if (AppiumConstants.W3C_STANDARD_CAPS.contains(capabilityName) || capabilityName.startsWith("appium:")) {
                    return (J.MethodInvocation)this.SET_CAP_TEMPLATE.apply(this.getCursor(), methodCall.getCoordinates().replace(), new Object[]{browserOptionsVarName, convertedCapKey, originalCapValue});
                }
                String cloudOptionsVarName = "cloudOptionsOf" + StringUtils.capitalize((String)browserOptionsVarName);
                J.MethodInvocation newMethodCall = (J.MethodInvocation)this.CLOUD_OPTIONS_PUT.apply(this.getCursor(), methodCall.getCoordinates().replace(), new Object[]{cloudOptionsVarName, convertedCapKey, originalCapValue});
                newMethodCall = newMethodCall.withMarkers(methodCall.getMarkers().add((Marker)new CloudOptionsMarker(browserOptionsVarName, cloudOptionsVarName)));
                this.importsToAdd.add("java.util.Map");
                this.importsToAdd.add("java.util.HashMap");
                return newMethodCall;
            }

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block visitedBlock = (J.Block)super.visitBlock(block, (Object)ctx);
                List<Statement> newStatements = this.migrateStatements(visitedBlock.getStatements());
                return visitedBlock.withStatements(newStatements);
            }

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                G.CompilationUnit visitedCu = (G.CompilationUnit)super.visitCompilationUnit(cu, (Object)ctx);
                List statements = visitedCu.getStatements();
                List<Statement> newStatements = this.migrateStatements(statements);
                Set<String> importsToRemove = Set.of("io.appium.java_client.remote.MobileCapabilityType");
                return AstRecipeHelper.updateImports(visitedCu.withStatements(newStatements), this.importsToAdd, importsToRemove);
            }

            private List<Statement> migrateStatements(List<Statement> statements) {
                ArrayList<Statement> newStatements = new ArrayList<Statement>();
                HashSet<String> alreadyDefinedCloudOptionsVarNames = new HashSet<String>();
                for (Statement statement : statements) {
                    J.MethodInvocation methodCall;
                    if (statement instanceof J.MethodInvocation && (methodCall = (J.MethodInvocation)statement).getMarkers().findFirst(CloudOptionsMarker.class).isPresent()) {
                        CloudOptionsMarker marker = (CloudOptionsMarker)methodCall.getMarkers().findFirst(CloudOptionsMarker.class).get();
                        String browserOptionsVarName = marker.getBrowserOptionsVarName();
                        String cloudOptionsVarName = marker.getCloudOptionsVarName();
                        if (!alreadyDefinedCloudOptionsVarNames.contains(cloudOptionsVarName)) {
                            String codeTemplate = "Map<String, Object> %s = new HashMap<>();\n%s.setCapability(\"cloud:options\", %s);";
                            String code = String.format(codeTemplate, cloudOptionsVarName, browserOptionsVarName, cloudOptionsVarName);
                            newStatements.addAll(AstRecipeHelper.buildStatementsFromGroovyCode(code, statement.getPrefix()));
                            alreadyDefinedCloudOptionsVarNames.add(cloudOptionsVarName);
                        }
                    }
                    newStatements.add(statement);
                }
                return newStatements;
            }

            private boolean isDesiredCapabilitiesFirefox(J.MethodInvocation methodInvocation) {
                Expression expression = methodInvocation.getSelect();
                if (expression instanceof J.Identifier) {
                    J.Identifier select = (J.Identifier)expression;
                    return "DesiredCapabilities".equals(select.getSimpleName()) && "firefox".equals(methodInvocation.getSimpleName());
                }
                return false;
            }

            private boolean isDesiredCapabilitiesChrome(J.MethodInvocation methodInvocation) {
                Expression expression = methodInvocation.getSelect();
                if (expression instanceof J.Identifier) {
                    J.Identifier select = (J.Identifier)expression;
                    return "DesiredCapabilities".equals(select.getSimpleName()) && "chrome".equals(methodInvocation.getSimpleName());
                }
                return false;
            }

            private boolean isDesiredCapabilitiesEdge(J.MethodInvocation methodInvocation) {
                Expression expression = methodInvocation.getSelect();
                if (expression instanceof J.Identifier) {
                    J.Identifier select = (J.Identifier)expression;
                    return "DesiredCapabilities".equals(select.getSimpleName()) && "edge".equals(methodInvocation.getSimpleName());
                }
                return false;
            }

            private boolean isSetCapabilityCall(J.MethodInvocation methodInvocation) {
                Expression expression = methodInvocation.getSelect();
                if (expression instanceof J.Identifier) {
                    String objecType;
                    J.Identifier select = (J.Identifier)expression;
                    String string = objecType = select.getType() != null ? select.getType().toString() : "";
                    return objecType.contains("DesiredCapabilities") && "setCapability".equals(methodInvocation.getSimpleName()) && methodInvocation.getArguments().size() == 2;
                }
                return false;
            }

            private String extractStringValue(Expression expr) {
                J.Literal literal;
                Object object;
                if (expr instanceof J.Literal && (object = (literal = (J.Literal)expr).getValue()) instanceof String) {
                    String str = (String)object;
                    return str;
                }
                return null;
            }

            private Expression convertMobileCapKey(Expression originalCapExpr) {
                J.Literal literal;
                Object object;
                String exprStr = originalCapExpr.toString();
                Object mappedCap = null;
                if (exprStr != null && exprStr.startsWith("MobileCapabilityType.")) {
                    String deprecatedCap = exprStr.substring("MobileCapabilityType.".length());
                    mappedCap = AppiumConstants.convertMobileCapabilityTypeEnumToString(deprecatedCap);
                } else if (originalCapExpr instanceof J.Literal && (object = (literal = (J.Literal)originalCapExpr).getValue()) instanceof String) {
                    String str = (String)object;
                    mappedCap = str;
                }
                if (mappedCap == null) {
                    return originalCapExpr;
                }
                if (AppiumConstants.APPIUM_PREFIX_REQUIRED_CAPS.contains(mappedCap) && !((String)mappedCap).startsWith("appium:")) {
                    mappedCap = "appium:" + (String)mappedCap;
                }
                return AstRecipeHelper.createStringLiteral(mappedCap);
            }

            private String convertToUnexpectedAlertBehaviour(String value) {
                return switch (value.toLowerCase()) {
                    case "accept" -> "UnexpectedAlertBehaviour.ACCEPT";
                    case "dismiss" -> "UnexpectedAlertBehaviour.DISMISS";
                    case "ignore" -> "UnexpectedAlertBehaviour.IGNORE";
                    default -> "UnexpectedAlertBehaviour.ACCEPT";
                };
            }

            private String convertToPageLoadStrategy(String value) {
                return switch (value.toLowerCase()) {
                    case "none" -> "PageLoadStrategy.NONE";
                    case "eager" -> "PageLoadStrategy.EAGER";
                    case "normal" -> "PageLoadStrategy.NORMAL";
                    default -> "PageLoadStrategy.NORMAL";
                };
            }
        };
    }

    public class CloudOptionsMarker
    implements Marker {
        private final UUID id = UUID.randomUUID();
        private final String browserOptionsVarName;
        private final String cloudOptionsVarName;

        public CloudOptionsMarker(String browserOptionsVarName, String cloudOptionsVarName) {
            this.browserOptionsVarName = browserOptionsVarName;
            this.cloudOptionsVarName = cloudOptionsVarName;
        }

        public UUID getId() {
            return this.id;
        }

        public CloudOptionsMarker withId(UUID id) {
            return new CloudOptionsMarker(this.browserOptionsVarName, this.cloudOptionsVarName);
        }

        public String getBrowserOptionsVarName() {
            return this.browserOptionsVarName;
        }

        public String getCloudOptionsVarName() {
            return this.cloudOptionsVarName;
        }
    }
}

