/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service.recipes.ks9to10;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.migration.model.AppiumConstants;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public class DesiredCapsWithW3CPrefix
extends Recipe {
    public String getDisplayName() {
        return "Add 'appium:' prefix to non-standard, non-vendor capabilities in JSON and update keys to W3C standard";
    }

    public String getDescription() {
        return "Add 'appium:' prefix to non-standard, non-vendor capabilities in JSON and update keys to W3C standard";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PlainTextVisitor<ExecutionContext>(){

            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                String content = text.getText();
                ObjectMapper mapper = new ObjectMapper();
                boolean hasChange = false;
                try {
                    Map root = (Map)mapper.readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
                    if (root.isEmpty()) {
                        return text;
                    }
                    String outerKey = (String)root.keySet().iterator().next();
                    Object capsObj = root.get(outerKey);
                    if (!(capsObj instanceof Map)) {
                        return text;
                    }
                    Map capsRaw = (Map)capsObj;
                    HashMap caps = new HashMap();
                    for (Map.Entry entry : capsRaw.entrySet()) {
                        if (!(entry.getKey() instanceof String)) continue;
                        caps.put((String)entry.getKey(), entry.getValue());
                    }
                    HashMap newCaps = new HashMap();
                    String remoteWebDriverUrl = caps.containsKey("remoteWebDriverUrl") ? String.valueOf(caps.get("remoteWebDriverUrl")) : "";
                    for (Map.Entry capEntry : caps.entrySet()) {
                        String key = (String)capEntry.getKey();
                        Object value = capEntry.getValue();
                        String prefix = null;
                        int idx = key.indexOf(58);
                        if (idx > 0) {
                            prefix = key.substring(0, idx);
                        }
                        Object newKey = key;
                        if (prefix == null) {
                            if ("version".equals(key)) {
                                newKey = "browserVersion";
                            } else if ("platform".equals(key)) {
                                newKey = "platformName";
                            } else if ("options".equals(key)) {
                                newKey = remoteWebDriverUrl.contains("saucelabs") ? "sauce:options" : (remoteWebDriverUrl.contains("lambdatest") ? "lt:options" : (remoteWebDriverUrl.contains("katalon") ? "katalon:options" : "cloud:options"));
                            } else if (AppiumConstants.APPIUM_PREFIX_REQUIRED_CAPS.contains(key)) {
                                newKey = "appium:" + key;
                            }
                        }
                        newCaps.put((String)newKey, value);
                        boolean bl = hasChange = hasChange || !((String)newKey).equals(key);
                    }
                    if (!hasChange) {
                        return text;
                    }
                    root.put(outerKey, newCaps);
                    String result = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)root);
                    return text.withText(result);
                }
                catch (Exception exception) {
                    return text;
                }
            }
        };
    }
}

