/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.migration.service.recipes.ks9to10;

import com.kms.katalon.migration.service.PlainTextRecipeHelper;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public class ReplaceGenericAppiumDriverPlainText
extends Recipe {
    public String getDisplayName() {
        return "Plain text: Replace generic Appium/Android/iOS driver types";
    }

    public String getDescription() {
        return "Replaces AndroidDriver<?>, IOSDriver<?>, and AppiumDriver<?> with AppiumDriver, except in import statements.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PlainTextVisitor<ExecutionContext>(){

            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                String code;
                String originalCode = code = text.getText();
                if (!(code = code.replaceAll("(?<!import\\s)(?:AndroidDriver|IOSDriver|AppiumDriver|MobileDriver)\\s*<[^>]+>", "AppiumDriver")).equals(originalCode)) {
                    code = PlainTextRecipeHelper.insertImportAfterPackageDeclaration(code, "import io.appium.java_client.AppiumDriver");
                }
                code = PlainTextRecipeHelper.removeImport(code, "io.appium.java_client.MobileDriver");
                return text.withText(code);
            }
        };
    }
}

