/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.java.After;
import io.cucumber.java.AfterAll;
import io.cucumber.java.AfterStep;
import io.cucumber.java.Before;
import io.cucumber.java.BeforeAll;
import io.cucumber.java.BeforeStep;
import io.cucumber.java.DataTableType;
import io.cucumber.java.DefaultDataTableCellTransformer;
import io.cucumber.java.DefaultDataTableEntryTransformer;
import io.cucumber.java.DefaultParameterTransformer;
import io.cucumber.java.DocStringType;
import io.cucumber.java.InvalidMethodException;
import io.cucumber.java.Invoker;
import io.cucumber.java.ParameterType;
import io.cucumber.java.StepDefinitionAnnotation;
import io.cucumber.java.StepDefinitionAnnotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;

final class MethodScanner {
    private static final Logger log = LoggerFactory.getLogger(MethodScanner.class);

    private MethodScanner() {
    }

    static void scan(Class<?> aClass, BiConsumer<Method, Annotation> consumer) {
        if (Object.class.equals(aClass)) {
            return;
        }
        if (!MethodScanner.isInstantiable(aClass)) {
            return;
        }
        Method[] methodArray = MethodScanner.safelyGetMethods(aClass);
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            MethodScanner.scan(consumer, aClass, method);
            ++n2;
        }
    }

    private static Method[] safelyGetMethods(Class<?> aClass) {
        try {
            return aClass.getMethods();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return new Method[0];
        }
    }

    private static boolean isInstantiable(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers()) && (Modifier.isStatic(clazz.getModifiers()) || clazz.getEnclosingClass() == null);
    }

    private static void scan(BiConsumer<Method, Annotation> consumer, Class<?> aClass, Method method) {
        if (Object.class.equals(method.getDeclaringClass())) {
            return;
        }
        if (method.isBridge()) {
            return;
        }
        MethodScanner.scan(consumer, aClass, method, method.getAnnotations());
    }

    private static void scan(BiConsumer<Method, Annotation> consumer, Class<?> aClass, Method method, Annotation[] methodAnnotations) {
        Annotation[] annotationArray = methodAnnotations;
        int n = methodAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (MethodScanner.isHookAnnotation(annotation) || MethodScanner.isStepDefinitionAnnotation(annotation)) {
                MethodScanner.validateMethod(aClass, method);
                consumer.accept(method, annotation);
            } else if (MethodScanner.isRepeatedStepDefinitionAnnotation(annotation)) {
                MethodScanner.scan(consumer, aClass, method, MethodScanner.repeatedAnnotations(annotation));
            }
            ++n2;
        }
    }

    private static void validateMethod(Class<?> glueCodeClass, Method method) {
        if (!glueCodeClass.equals(method.getDeclaringClass())) {
            throw InvalidMethodException.createInvalidMethodException((Method)method, glueCodeClass);
        }
    }

    private static boolean isHookAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.equals(Before.class) || annotationClass.equals(BeforeAll.class) || annotationClass.equals(After.class) || annotationClass.equals(AfterAll.class) || annotationClass.equals(BeforeStep.class) || annotationClass.equals(AfterStep.class) || annotationClass.equals(ParameterType.class) || annotationClass.equals(DataTableType.class) || annotationClass.equals(DefaultParameterTransformer.class) || annotationClass.equals(DefaultDataTableEntryTransformer.class) || annotationClass.equals(DefaultDataTableCellTransformer.class) || annotationClass.equals(DocStringType.class);
    }

    private static boolean isStepDefinitionAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.getAnnotation(StepDefinitionAnnotation.class) != null;
    }

    private static boolean isRepeatedStepDefinitionAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.getAnnotation(StepDefinitionAnnotations.class) != null;
    }

    private static Annotation[] repeatedAnnotations(Annotation annotation) {
        try {
            Method expressionMethod = annotation.getClass().getMethod("value", new Class[0]);
            return (Annotation[])Invoker.invoke((Annotation)annotation, (Method)expressionMethod);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }
}

