/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map.imageprovider;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.imageprovider.AbstractMapElementImageProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.util.RendererUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapElementImageProvider
extends AbstractMapElementImageProvider {
    private static final Log log = LogFactory.getLog(MapElementImageProvider.class);
    public static Integer MAX_URL_LENGTH = 8192;

    @Override
    protected Renderable createRenderable(JasperReportsContext jasperReportsContext, JRGenericPrintElement element) throws JRException {
        Renderable cachedRenderable = (Renderable)element.getParameterValue("cacheRenderer");
        if (cachedRenderable == null) {
            OnErrorTypeEnum onErrorType = element.getParameterValue("onErrorType") == null ? MapComponent.DEFAULT_ON_ERROR_TYPE : OnErrorTypeEnum.getByName((String)element.getParameterValue("onErrorType"));
            String imageLocation = this.getImageLocation(element);
            cachedRenderable = RendererUtil.getInstance(jasperReportsContext).getNonLazyRenderable(imageLocation, onErrorType);
            element.setParameterValue("cacheRenderer", cachedRenderable);
        }
        return cachedRenderable;
    }

    protected String getImageLocation(JRGenericPrintElement element) {
        String color;
        Float latitude = (Float)element.getParameterValue("latitude");
        latitude = latitude == null ? MapComponent.DEFAULT_LATITUDE : latitude;
        Float longitude = (Float)element.getParameterValue("longitude");
        longitude = longitude == null ? MapComponent.DEFAULT_LONGITUDE : longitude;
        Integer zoom = (Integer)element.getParameterValue("zoom");
        zoom = zoom == null ? MapComponent.DEFAULT_ZOOM : zoom;
        String mapType = (String)element.getParameterValue("mapType");
        String mapScale = (String)element.getParameterValue("mapScale");
        String mapFormat = (String)element.getParameterValue("imageType");
        String reqParams = (String)element.getParameterValue("reqParams");
        String markers = "";
        List markerList = (List)element.getParameterValue("markers");
        if (markerList != null && !markerList.isEmpty()) {
            String currentMarkers = "";
            for (Object map : markerList) {
                String icon;
                if (map == null || map.isEmpty()) continue;
                currentMarkers = "&markers=";
                String size = (String)map.get("size");
                currentMarkers = currentMarkers + (size != null && size.length() > 0 ? "size:" + size + "%7C" : "");
                color = (String)map.get("color");
                currentMarkers = currentMarkers + (color != null && color.length() > 0 ? "color:0x" + color + "%7C" : "");
                String label = (String)map.get("label");
                currentMarkers = currentMarkers + (label != null && label.length() > 0 ? "label:" + Character.toUpperCase(label.charAt(0)) + "%7C" : "");
                String string = icon = map.get("icon.url") != null ? (String)map.get("icon.url") : (String)map.get("icon");
                if (icon != null && icon.length() > 0) {
                    currentMarkers = currentMarkers + "icon:" + icon + "%7C";
                }
                currentMarkers = currentMarkers + map.get("latitude");
                currentMarkers = currentMarkers + ",";
                currentMarkers = currentMarkers + map.get("longitude");
                markers = markers + currentMarkers;
            }
        }
        List pathList = (List)element.getParameterValue("paths");
        String currentPaths = "";
        if (pathList != null && !pathList.isEmpty()) {
            for (Map pathMap : pathList) {
                if (pathMap == null || pathMap.isEmpty()) continue;
                currentPaths = currentPaths + "&path=";
                color = (String)pathMap.get("strokeColor");
                if (color != null && color.length() > 0) {
                    color = JRColorUtil.getColorHexa(JRColorUtil.getColor(color, Color.BLACK));
                    color = color + (pathMap.get("strokeOpacity") == null || pathMap.get("strokeOpacity").toString().length() == 0 ? "ff" : Integer.toHexString((int)(255.0 * Double.valueOf(pathMap.get("strokeOpacity").toString()))));
                }
                currentPaths = currentPaths + (color != null && color.length() > 0 ? "color:0x" + color.toLowerCase() + "%7C" : "");
                Boolean isPolygon = pathMap.get("isPolygon") == null ? false : Boolean.valueOf(pathMap.get("isPolygon").toString());
                if (isPolygon.booleanValue()) {
                    String fillColor = (String)pathMap.get("fillColor");
                    if (fillColor != null && fillColor.length() > 0) {
                        fillColor = JRColorUtil.getColorHexa(JRColorUtil.getColor(fillColor, Color.WHITE));
                        fillColor = fillColor + (pathMap.get("fillOpacity") == null || pathMap.get("fillOpacity").toString().length() == 0 ? "00" : Integer.toHexString((int)(256.0 * Double.valueOf(pathMap.get("fillOpacity").toString()))));
                    }
                    currentPaths = currentPaths + (fillColor != null && fillColor.length() > 0 ? "fillcolor:0x" + fillColor.toLowerCase() + "%7C" : "");
                }
                String weight = pathMap.get("strokeWeight") == null ? null : pathMap.get("strokeWeight").toString();
                currentPaths = currentPaths + (weight != null && weight.length() > 0 ? "weight:" + Integer.valueOf(weight) + "%7C" : "");
                List locations = (List)pathMap.get("locations");
                Map location = null;
                if (locations == null || locations.isEmpty()) continue;
                for (int i = 0; i < locations.size(); ++i) {
                    location = (Map)locations.get(i);
                    currentPaths = currentPaths + location.get("latitude");
                    currentPaths = currentPaths + ",";
                    currentPaths = currentPaths + location.get("longitude");
                    currentPaths = currentPaths + (i < locations.size() - 1 ? "%7C" : "");
                }
                if (!isPolygon.booleanValue()) continue;
                currentPaths = currentPaths + "%7C";
                currentPaths = currentPaths + ((Map)locations.get(0)).get("latitude");
                currentPaths = currentPaths + ",";
                currentPaths = currentPaths + ((Map)locations.get(0)).get("longitude");
            }
        }
        String imageLocation = "https://maps.googleapis.com/maps/api/staticmap?center=" + latitude + "," + longitude + "&size=" + element.getWidth() + "x" + element.getHeight() + "&zoom=" + zoom + (mapType == null ? "" : "&maptype=" + mapType) + (mapFormat == null ? "" : "&format=" + mapFormat) + (mapScale == null ? "" : "&scale=" + mapScale);
        String params = reqParams == null || reqParams.trim().length() == 0 ? "" : "&" + reqParams;
        imageLocation = imageLocation + (imageLocation.length() + markers.length() + currentPaths.length() + params.length() < MAX_URL_LENGTH ? markers + currentPaths + params : (imageLocation.length() + markers.length() + params.length() < MAX_URL_LENGTH ? markers + params : params));
        if (log.isTraceEnabled()) {
            log.trace((Object)("Produced map imageLocation: " + imageLocation));
        }
        return imageLocation;
    }
}

