/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.phantomjs;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InetUtil {
    private static final Log log = LogFactory.getLog(InetUtil.class);

    public static Inet4Address getIPv4Loopback() {
        InetAddress loopbackAddress = InetAddress.getLoopbackAddress();
        if (loopbackAddress instanceof Inet4Address) {
            return (Inet4Address)loopbackAddress;
        }
        try {
            InetAddress[] addresses;
            for (InetAddress inetAddress : addresses = InetAddress.getAllByName(loopbackAddress.getHostName())) {
                if (!(inetAddress instanceof Inet4Address)) continue;
                return (Inet4Address)inetAddress;
            }
        }
        catch (UnknownHostException e) {
            log.warn((Object)("Error while determining loopback addresses for " + loopbackAddress.getHostName()), (Throwable)e);
        }
        try {
            Enumeration<NetworkInterface> itfs = NetworkInterface.getNetworkInterfaces();
            while (itfs.hasMoreElements()) {
                NetworkInterface itf = itfs.nextElement();
                if (!itf.isLoopback()) continue;
                Enumeration<InetAddress> addresses = itf.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!(address instanceof Inet4Address)) continue;
                    return (Inet4Address)address;
                }
            }
        }
        catch (SocketException e) {
            log.warn((Object)"Error while listing network interfaces", (Throwable)e);
        }
        return null;
    }

    public static int getAvailablePort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            int port = socket.getLocalPort();
            if (log.isDebugEnabled()) {
                log.debug((Object)("found available port " + port));
            }
            n = port;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        socket.close();
        return n;
    }
}

