/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.infrastructure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.mobile.core.enums.MobileApplicationMode;
import com.katalon.mobile.core.enums.MobileDevicePlatform;
import com.katalon.mobile.core.enums.MobileProvider;
import com.katalon.recorder.core.domain.exception.RecorderPreferencesAccessException;
import com.katalon.recorder.core.domain.exception.RecorderPreferencesException;
import com.katalon.recorder.core.domain.exception.RecorderPreferencesReadException;
import com.katalon.recorder.core.domain.exception.RecorderPreferencesSerializationException;
import com.katalon.recorder.core.domain.exception.RecorderPreferencesWriteException;
import com.katalon.recorder.mobile.core.infrastructure.IMobileRecorderPreferences;
import com.katalon.recorder.mobile.core.models.CustomProviderConfiguration;
import com.katalon.recorder.mobile.core.models.KobitonProviderConfiguration;
import com.katalon.recorder.mobile.core.models.LocalProviderConfiguration;
import com.katalon.recorder.mobile.core.models.MobileProviderConfiguration;
import com.katalon.recorder.mobile.core.models.MobileRecorderConfiguration;
import com.katalon.recorder.mobile.core.models.RemoteProviderConfiguration;
import com.katalon.recorder.mobile.core.models.TestCloudProviderConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.setting.BundleSettingStore;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class MobileRecorderPreferences
extends BundleSettingStore
implements IMobileRecorderPreferences {
    private Logger logger = LoggerFactory.getLogger(MobileRecorderPreferences.class);
    private static final String BUNDLE_ID = "com.katalon.recorder.mobile";
    private static final String CONF_PROPERTY_CONFIGURATION = "configuration";

    public MobileRecorderPreferences() {
        super(ProjectController.getInstance().getCurrentProject().getFolderLocation(), BUNDLE_ID, false);
    }

    public MobileRecorderConfiguration loadConfiguration() throws RecorderPreferencesException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = this.getStringProperty(CONF_PROPERTY_CONFIGURATION, null, false);
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                return (MobileRecorderConfiguration)mapper.readValue(json, MobileRecorderConfiguration.class);
            }
            MobileRecorderConfiguration configuration = new MobileRecorderConfiguration();
            configuration.setActiveProvider(MobileProvider.LOCAL);
            MobileProvider[] mobileProviderArray = MobileProvider.values();
            int n = mobileProviderArray.length;
            int n2 = 0;
            while (n2 < n) {
                MobileProvider provider = mobileProviderArray[n2];
                if (MobileProvider.LOCAL.equals((Object)provider)) {
                    providerConfiguration = new LocalProviderConfiguration();
                    providerConfiguration.setDevicePlatform(MobileDevicePlatform.ANDROID);
                    providerConfiguration.setApplicationMode(MobileApplicationMode.FILE);
                    providerConfiguration.setTimeout(RunConfiguration.getElementTimeoutForMobile());
                    configuration.setProviderConfiguration(provider, (MobileProviderConfiguration)providerConfiguration);
                } else if (MobileProvider.REMOTE.equals((Object)provider)) {
                    providerConfiguration = new RemoteProviderConfiguration();
                    providerConfiguration.setApplicationMode(MobileApplicationMode.FILE);
                    providerConfiguration.setTimeout(RunConfiguration.getElementTimeoutForMobile());
                    configuration.setProviderConfiguration(provider, (MobileProviderConfiguration)providerConfiguration);
                } else if (MobileProvider.CUSTOM.equals((Object)provider)) {
                    providerConfiguration = new CustomProviderConfiguration();
                    providerConfiguration.setApplicationMode(MobileApplicationMode.FILE);
                    providerConfiguration.setTimeout(RunConfiguration.getElementTimeoutForMobile());
                    configuration.setProviderConfiguration(provider, (MobileProviderConfiguration)providerConfiguration);
                } else if (MobileProvider.TESTCLOUD.equals((Object)provider)) {
                    providerConfiguration = new TestCloudProviderConfiguration();
                    providerConfiguration.setTimeout(RunConfiguration.getElementTimeoutForMobile());
                    providerConfiguration.setApplicationMode(MobileApplicationMode.ID);
                    configuration.setProviderConfiguration(provider, (MobileProviderConfiguration)providerConfiguration);
                } else if (MobileProvider.KOBITON.equals((Object)provider)) {
                    providerConfiguration = new KobitonProviderConfiguration();
                    providerConfiguration.setApplicationMode(MobileApplicationMode.ID);
                    providerConfiguration.setTimeout(RunConfiguration.getElementTimeoutForMobile());
                    configuration.setProviderConfiguration(provider, (MobileProviderConfiguration)providerConfiguration);
                }
                ++n2;
            }
            this.saveConfiguration(configuration);
            return configuration;
        }
        catch (GeneralSecurityException e) {
            throw new RecorderPreferencesAccessException((Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new RecorderPreferencesSerializationException((Throwable)e);
        }
        catch (IOException e) {
            throw new RecorderPreferencesReadException((Throwable)e);
        }
    }

    public void saveConfiguration(MobileRecorderConfiguration configuration) throws RecorderPreferencesException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = mapper.writeValueAsString((Object)configuration);
            this.setStringProperty(CONF_PROPERTY_CONFIGURATION, json, false);
        }
        catch (GeneralSecurityException e) {
            throw new RecorderPreferencesAccessException((Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new RecorderPreferencesSerializationException((Throwable)e);
        }
        catch (IOException e) {
            throw new RecorderPreferencesWriteException((Throwable)e);
        }
    }
}

