/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.presentation;

import com.equo.chromium.swt.Browser;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionUtil;
import com.katalon.mobile.core.enums.MobileDevicePlatform;
import com.katalon.mobile.core.enums.MobileProvider;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.domain.exception.RecorderPreferencesException;
import com.katalon.recorder.core.domain.exception.RecordingException;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.IVariable;
import com.katalon.recorder.core.domain.model.KeywordDefinition;
import com.katalon.recorder.mobile.core.application.IMobileRecorderController;
import com.katalon.recorder.mobile.core.application.IMobileRecorderSessionContext;
import com.katalon.recorder.mobile.core.interfaces.IMobileActionRequest;
import com.katalon.recorder.mobile.core.interfaces.IMobileStartRecordingRequest;
import com.katalon.recorder.mobile.core.listeners.MobileRecorderConfigurationViewListener;
import com.katalon.recorder.mobile.core.listeners.MobileRecorderControlViewListener;
import com.katalon.recorder.mobile.core.listeners.MobileRecorderDeviceViewListener;
import com.katalon.recorder.mobile.core.listeners.MobileRecorderNavigatorListener;
import com.katalon.recorder.mobile.core.listeners.MobileRecorderObjectViewListener;
import com.katalon.recorder.mobile.core.listeners.MobileRecorderStepViewListener;
import com.katalon.recorder.mobile.core.listeners.MobileRecorderVariableViewListener;
import com.katalon.recorder.mobile.core.models.MobileRecorderConfiguration;
import com.katalon.recorder.mobile.core.models.MobileSaveTestCaseRequest;
import com.katalon.recorder.mobile.core.presentation.IMobileRecorderNavigator;
import com.katalon.recorder.mobile.models.dto.MobileActionResponse;
import com.katalon.recorder.mobile.models.dto.MobileDeviceDto;
import com.katalon.recorder.mobile.utils.FolderEntityConverter;
import com.katalon.recorder.mobile.views.MobileRecorderConfigurationView;
import com.katalon.recorder.mobile.views.MobileRecorderControlView;
import com.katalon.recorder.mobile.views.MobileRecorderDeviceView;
import com.katalon.recorder.mobile.views.MobileRecorderObjectView;
import com.katalon.recorder.mobile.views.MobileRecorderStepView;
import com.katalon.recorder.mobile.views.MobileRecorderVariableView;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.mobile.objectspy.dialog.AddElementToObjectRepositoryDialogV2;
import com.kms.katalon.composer.mobile.objectspy.dialog.SaveTestCaseDialog;
import com.kms.katalon.entity.folder.FolderEntity;
import java.io.File;
import java.net.URL;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileRecorderNavigator
implements IMobileRecorderNavigator {
    private final String RECORDER_MOBILE_COMPOSER_BUNDLE = "com.katalon.recorder.mobile.composer";
    private final String MOBILE_RECORDER_HTML_PATH = "resources/webview/MobileRecorder.html";
    private final String MOBILE_RECORDER_CONFIGURATION_PAGE_PATH = "#/";
    private final String MOBILE_RECORDER_DEVICE_INTERACTION_PAGE_PATH = "#/device-interaction";
    private Logger logger = LoggerFactory.getLogger(MobileRecorderNavigator.class);
    private final int ANIMATION_WAIT_TIME = 300;
    private Browser mainViewBrowser;
    private Browser deviceViewBrowser;
    private MobileRecorderConfigurationView configurationView;
    private MobileRecorderDeviceView deviceView;
    private MobileRecorderStepView stepView;
    private MobileRecorderObjectView objectView;
    private MobileRecorderVariableView variableView;
    private MobileRecorderControlView controlView;
    private MobileRecorderNavigatorListener navigatorListener;
    private EventHandler updateAppiumLogHandler;
    private ScheduledFuture<?> closeMainDialogTask;
    private final AtomicReference<CompletableFuture<?>> currentValidation = new AtomicReference();
    @Inject
    private IMobileRecorderController controller;
    @Inject
    private IMobileRecorderSessionContext sessionContext;
    @Inject
    private IEventBroker eventBroker;

    public MobileRecorderNavigator() {
        this.registerEventHandlers();
    }

    public void init(Browser browser) {
        this.mainViewBrowser = browser;
        try {
            Bundle bundle = Platform.getBundle((String)"com.katalon.recorder.mobile.composer");
            URL htmlFileUrl = FileLocator.toFileURL((URL)bundle.getResource("resources/webview/MobileRecorder.html"));
            browser.setUrl(htmlFileUrl.toString() + "#/");
            ComponentUtil.onBrowserLoaded((Browser)this.mainViewBrowser, b -> this.mainViewDidLoaded());
        }
        catch (Exception e) {
            this.logger.error("Error while showing Mobile Recorder Configuration webview.", (Throwable)e);
        }
    }

    public void initDeviceView(Browser browser, MobileDevicePlatform devicePlatform) {
        this.deviceViewBrowser = browser;
        try {
            Bundle bundle = Platform.getBundle((String)"com.katalon.recorder.mobile.composer");
            URL htmlFileUrl = FileLocator.toFileURL((URL)bundle.getResource("resources/webview/MobileRecorder.html"));
            browser.setUrl(htmlFileUrl.toString() + "#/device-interaction");
            ComponentUtil.onBrowserLoaded((Browser)this.deviceViewBrowser, b -> this.deviceViewDidLoaded(devicePlatform));
        }
        catch (Exception e) {
            this.logger.error("Error while showing Mobile Recorder Device Interaction webview.", (Throwable)e);
        }
    }

    public void setRecorderDialogListener(MobileRecorderNavigatorListener listener) {
        this.navigatorListener = listener;
    }

    public void retrieveConfigurationBeforeClosing() {
        BrowserFunctionUtil.execute((Browser)this.mainViewBrowser, (String)"mobileRecorderConfigurationView.retrieveConfigurationBeforeClosing", (Object[])new Object[0]);
        if (this.closeMainDialogTask == null) {
            int timeoutInSecond = 1;
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            this.closeMainDialogTask = scheduler.schedule(() -> {
                this.logger.warn(String.format("Did not receive the %s call from the webview after %s second(s). Closing the main mobile recorder dialog anyway.", "mobileRecorderNavigator.onDialogClose", timeoutInSecond));
                this.close();
            }, (long)timeoutInSecond, TimeUnit.SECONDS);
        }
    }

    private void registerEventHandlers() {
        this.updateAppiumLogHandler = event -> this.updateAppiumLogHandler(event);
    }

    private void registerMainViewBrowserFunctions() {
        BrowserFunctionUtil.bind((Browser)this.mainViewBrowser);
        BrowserFunctionUtil.registerBrowserFunction((String)"mobileRecorderNavigator.onDialogLayoutResized", Float.class, Integer.class, Integer.class, (ratio, width, height) -> {
            if (this.navigatorListener != null) {
                this.navigatorListener.onLayoutResized(ratio.floatValue(), width.intValue(), height.intValue());
            }
        });
        BrowserFunctionUtil.registerBrowserFunction((String)"mobileRecorderNavigator.onUserCloseConfiguration", () -> this.retrieveConfigurationBeforeClosing());
        BrowserFunctionUtil.registerBrowserFunction((String)"mobileRecorderNavigator.onDialogClose", () -> this.close());
        this.configurationView = new MobileRecorderConfigurationView();
        this.configurationView.addListener(new MobileRecorderConfigurationViewListener(){

            public void onUpdateActiveProvider(MobileProvider provider) {
                try {
                    MobileRecorderNavigator.this.sessionContext.updateActiveMobileDeviceProvider(provider);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderConfigurationView.updateDeviceProviderConfiguration", (Object[])new Object[]{MobileRecorderNavigator.this.sessionContext.getActiveProviderConfiguration()});
                }
                catch (RecorderPreferencesException e) {
                    MobileRecorderNavigator.this.logger.error(e.getMessage());
                }
            }

            public void onUpdateMobileRecorderConfiguration(MobileRecorderConfiguration configuration) {
                try {
                    MobileRecorderNavigator.this.sessionContext.updateMobileRecorderConfiguration(configuration);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderConfigurationView.onSaveMobileRecorderConfigurationSuccess", (Object[])new Object[0]);
                }
                catch (RecorderPreferencesException e) {
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderConfigurationView.onSaveMobileRecorderConfigurationError", (Object[])new Object[]{e.getMessage()});
                    MobileRecorderNavigator.this.logger.error(e.getMessage());
                }
            }

            public void onValidateMobileApplicationPath(MobileProvider provider, MobileDevicePlatform devicePlatform, String applicationPath) {
                CompletableFuture<?> pending = MobileRecorderNavigator.this.currentValidation.get();
                if (pending != null && !pending.isDone()) {
                    pending.cancel(true);
                }
                CompletionStage future = ((CompletableFuture)MobileRecorderNavigator.this.controller.validateApplicationPath(provider, devicePlatform, applicationPath).thenRun(() -> BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"localProviderConfigurationView.validateLocalApplicationPathSuccess", (Object[])new Object[0]))).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"localProviderConfigurationView.validateLocalApplicationPathError", (Object[])new Object[]{cause.getMessage()});
                    return null;
                });
                MobileRecorderNavigator.this.currentValidation.set((CompletableFuture<?>)future);
            }

            public void onValidateMobileApplicationId(MobileProvider provider, MobileDevicePlatform devicePlatform, String applicationId) {
                CompletableFuture<?> pending = MobileRecorderNavigator.this.currentValidation.get();
                if (pending != null && !pending.isDone()) {
                    pending.cancel(true);
                }
                CompletionStage future = ((CompletableFuture)MobileRecorderNavigator.this.controller.validateApplicationId(provider, devicePlatform, applicationId).thenRun(() -> BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"localProviderConfigurationView.validateLocalApplicationIdSuccess", (Object[])new Object[0]))).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"localProviderConfigurationView.validateLocalApplicationIdError", (Object[])new Object[]{cause.getMessage()});
                    return null;
                });
                MobileRecorderNavigator.this.currentValidation.set((CompletableFuture<?>)future);
            }

            public void onReloadMobileDevices(MobileProvider provider, MobileDevicePlatform devicePlatform) {
                MobileRecorderNavigator.this.controller.getDevicesAsync(provider, devicePlatform).thenAccept(devices -> BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"localProviderConfigurationView.setDevices", (Object[])new Object[]{provider, devicePlatform, devices.stream().map(MobileDeviceDto::toDto).collect(Collectors.toList())}));
            }

            public void onChooseFile(String[] filterExtensions, String[] filterNames) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dialog.setFilterExtensions(filterExtensions);
                dialog.setFilterNames(filterNames);
                String filePath = dialog.open();
                if (filePath != null) {
                    File file = new File(filePath);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"localProviderConfigurationView.onFileChosen", (Object[])new Object[]{file.getAbsolutePath(), file.getName(), file.length()});
                }
            }

            public void onStartRecording(IMobileStartRecordingRequest request) {
                MobileRecorderNavigator.this.subscribeConfigurationEvents();
                MobileDevicePlatform devicePlatform = request.getDevicePlatform();
                ((CompletableFuture)MobileRecorderNavigator.this.controller.startRecordingAsync(request).thenAccept(response -> {
                    MobileRecorderNavigator.this.unsubscribeConfigurationEvents();
                    MobileRecorderNavigator.this.sessionContext.onRecordingStarted(response.getMobileRecordingConnection());
                    IStep step = response.getStep();
                    Display.getDefault().syncExec(() -> {
                        if (MobileRecorderNavigator.this.navigatorListener != null) {
                            MobileRecorderNavigator.this.navigatorListener.onRecordingStarted(devicePlatform);
                        }
                    });
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderConfigurationView.startRecordingSuccess", (Object[])new Object[]{request, MobileRecorderNavigator.this.sessionContext.getSession().getRecordingConnections()});
                    if (step != null) {
                        Display.getDefault().syncExec(() -> {
                            MobileRecorderNavigator.this.sessionContext.addStep(step);
                            BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderStepView.updateRecordedStepsSuccess", (Object[])new Object[]{MobileRecorderNavigator.this.sessionContext.getSteps()});
                        });
                    }
                })).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    MobileRecorderNavigator.this.logger.error(cause.getMessage(), cause);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderConfigurationView.startRecordingError", (Object[])new Object[]{cause.getMessage()});
                    MobileRecorderNavigator.this.unsubscribeConfigurationEvents();
                    return null;
                });
            }

            public void onGetLocalApplicationPathInfo(String applicationPath) {
                if (StringUtils.isNotEmpty((CharSequence)applicationPath)) {
                    try {
                        File file = new File(applicationPath);
                        BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"localProviderConfigurationView.getLocalApplicationPathInfoSuccess", (Object[])new Object[]{file.getName(), file.length()});
                    }
                    catch (Exception e) {
                        BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"localProviderConfigurationView.getLocalApplicationPathInfoError", (Object[])new Object[]{e.getMessage()});
                    }
                }
            }

            public void onConfigurateRemoteDevice() {
                MobileRecorderNavigator.this.controller.openRemoteCapabilitySetting();
                try {
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderConfigurationView.setConfiguration", (Object[])new Object[]{MobileRecorderNavigator.this.sessionContext.getConfiguration()});
                }
                catch (RecorderPreferencesException e) {
                    MobileRecorderNavigator.this.logger.error("Error while updating Remote capability settings to webview", (Throwable)e);
                }
            }

            public void onConfigurateCustomCapability() {
                MobileRecorderNavigator.this.controller.openCustomCapabilitySetting();
                try {
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderConfigurationView.setConfiguration", (Object[])new Object[]{MobileRecorderNavigator.this.sessionContext.getConfiguration()});
                }
                catch (RecorderPreferencesException e) {
                    MobileRecorderNavigator.this.logger.error("Error while updating Custom capability settings to webview", (Throwable)e);
                }
            }
        });
        this.controlView = new MobileRecorderControlView();
        this.controlView.addListener(new MobileRecorderControlViewListener(){

            public void onPauseRecording(String recordingConnectionId) {
                MobileRecorderNavigator.this.sessionContext.pauseRecording(recordingConnectionId);
                BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderControlView.pauseRecordingSuccess", (Object[])new Object[]{MobileRecorderNavigator.this.sessionContext.getSession().getRecordingConnections()});
            }

            public void onResumeRecording(String recordingConnectionId) {
                MobileRecorderNavigator.this.sessionContext.resumeRecording(recordingConnectionId);
                BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderControlView.resumeRecordingSuccess", (Object[])new Object[]{MobileRecorderNavigator.this.sessionContext.getSession().getRecordingConnections()});
            }

            public void onSaveRecording() {
                SaveTestCaseDialog.ExportTestCaseSelectionResult exportTestCaseSelectionResult = null;
                AddElementToObjectRepositoryDialogV2.AddToObjectRepositoryDialogResult addToObjectRepositoryDialogResult = null;
                try {
                    addToObjectRepositoryDialogResult = MobileRecorderNavigator.this.sessionContext.openSaveTestObjectDialog();
                    exportTestCaseSelectionResult = MobileRecorderNavigator.this.sessionContext.openSaveTestCaseDialog();
                }
                catch (RecordingException recordingException) {}
                if (addToObjectRepositoryDialogResult != null && exportTestCaseSelectionResult != null) {
                    MobileSaveTestCaseRequest saveTestCaseRequest = new MobileSaveTestCaseRequest();
                    saveTestCaseRequest.setSelectAllTestObject(addToObjectRepositoryDialogResult.isSelectAll());
                    saveTestCaseRequest.setCapturedElements(addToObjectRepositoryDialogResult.getAllSelectedElement());
                    FolderTreeEntity testObjectParentFolderTree = addToObjectRepositoryDialogResult.getSelectedParentFolder();
                    FolderEntity testObjectFolder = FolderEntityConverter.getFolder(testObjectParentFolderTree);
                    saveTestCaseRequest.setTestObjectFolder(testObjectFolder);
                    saveTestCaseRequest.setTestObjectConflictOption(addToObjectRepositoryDialogResult.getSelectedConflictOption());
                    saveTestCaseRequest.setConflictedElementEntities(addToObjectRepositoryDialogResult.getAllConflictedElementEntities());
                    saveTestCaseRequest.setTestCaseName(exportTestCaseSelectionResult.getTestCaseName());
                    saveTestCaseRequest.setTestCaseFolder(exportTestCaseSelectionResult.getFolder());
                    saveTestCaseRequest.setExportTestCaseOption(exportTestCaseSelectionResult.getOption());
                    ((CompletableFuture)MobileRecorderNavigator.this.controller.stopRecordingAsync().thenAccept(step -> {
                        if (step != null) {
                            Display.getDefault().syncExec(() -> {
                                MobileRecorderNavigator.this.sessionContext.addStep(step);
                                BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderStepView.updateRecordedStepsSuccess", (Object[])new Object[]{MobileRecorderNavigator.this.sessionContext.getSteps()});
                            });
                        }
                        MobileRecorderNavigator.this.sessionContext.onRecordingStopped();
                        if (MobileRecorderNavigator.this.navigatorListener != null) {
                            MobileRecorderNavigator.this.navigatorListener.onRecordingStopped();
                        }
                        Display.getDefault().syncExec(() -> MobileRecorderNavigator.this.sessionContext.saveTestCase(saveTestCaseRequest));
                        MobileRecorderNavigator.this.close();
                        BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderControlView.stopRecordingSuccess", (Object[])new Object[0]);
                    })).exceptionally(e -> {
                        Throwable cause = e.getCause() != null ? e.getCause() : e;
                        MobileRecorderNavigator.this.logger.error(cause.getMessage(), cause);
                        BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderControlView.stopRecordingError", (Object[])new Object[]{cause.getMessage()});
                        return null;
                    });
                }
            }
        });
        this.stepView = new MobileRecorderStepView();
        this.stepView.addListener(new MobileRecorderStepViewListener(){

            public void onUpdate(IStep[] steps) {
                Display.getDefault().syncExec(() -> {
                    MobileRecorderNavigator.this.sessionContext.setSteps(steps);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderStepView.updateRecordedStepsSuccess", (Object[])new Object[]{MobileRecorderNavigator.this.sessionContext.getSteps()});
                });
            }
        });
        this.objectView = new MobileRecorderObjectView();
        this.objectView.addListener(new MobileRecorderObjectViewListener(){

            public void onAdd(ICapturedObject object) {
                MobileRecorderNavigator.this.sessionContext.addObject(object);
            }

            public void onVerifyAndHighlight(String id, LocatorType locatorType) {
                ((CompletableFuture)MobileRecorderNavigator.this.sessionContext.verifyObjectAsync(id, locatorType).thenAccept(mobileWebElements -> {
                    if (mobileWebElements.isEmpty()) {
                        BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.verifyAndHighlightError", (Object[])new Object[]{"No element found"});
                        BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderObjectView.verifyAndHighlightError", (Object[])new Object[]{"No element found"});
                    } else {
                        BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.verifyAndHighlightSuccess", (Object[])new Object[]{mobileWebElements});
                        BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderObjectView.verifyAndHighlightSuccess", (Object[])new Object[]{mobileWebElements});
                    }
                })).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    MobileRecorderNavigator.this.logger.error(cause.getMessage(), cause);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.verifyAndHighlightError", (Object[])new Object[]{cause.getMessage()});
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderObjectView.verifyAndHighlightError", (Object[])new Object[]{cause.getMessage()});
                    return null;
                });
            }

            public void onTakeScreenshot(String id) {
                ((CompletableFuture)MobileRecorderNavigator.this.sessionContext.takeScreenshotAsync(id).thenAccept(object -> BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderObjectView.takeScreenshotSuccess", (Object[])new Object[]{object}))).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    MobileRecorderNavigator.this.logger.error(cause.getMessage(), cause);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderObjectView.takeScreenshotError", (Object[])new Object[]{cause.getMessage()});
                    return null;
                });
            }

            public void onResetLocator(String id, LocatorType locatorType) {
                ((CompletableFuture)MobileRecorderNavigator.this.sessionContext.resetLocatorAsync(id, locatorType).thenAccept(object -> BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderObjectView.resetLocatorSuccess", (Object[])new Object[]{object}))).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    MobileRecorderNavigator.this.logger.error(cause.getMessage(), cause);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderObjectView.resetLocatorError", (Object[])new Object[]{cause.getMessage()});
                    return null;
                });
            }

            public void onMakeDefaultLocator(String id, LocatorType locatorType) {
                ((CompletableFuture)MobileRecorderNavigator.this.sessionContext.makeDefaultLocatorAsync(id, locatorType).thenAccept(object -> BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderObjectView.makeDefaultLocatorSuccess", (Object[])new Object[]{object}))).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    MobileRecorderNavigator.this.logger.error(cause.getMessage(), cause);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderObjectView.makeDefaultLocatorError", (Object[])new Object[]{cause.getMessage()});
                    return null;
                });
            }
        });
        this.variableView = new MobileRecorderVariableView();
        this.variableView.addListener(new MobileRecorderVariableViewListener(){

            public void onUpdate(IVariable[] variables) {
                Display.getDefault().syncExec(() -> {
                    MobileRecorderNavigator.this.sessionContext.setVariables(variables);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderVariableView.updateVariablesSuccess", (Object[])new Object[]{MobileRecorderNavigator.this.sessionContext.getVariables()});
                });
            }
        });
    }

    private void registerDeviceViewBrowserFunctions() {
        BrowserFunctionUtil.bind((Browser)this.deviceViewBrowser);
        this.deviceView = new MobileRecorderDeviceView();
        this.deviceView.addListener(new MobileRecorderDeviceViewListener(){

            public void onAction(IMobileActionRequest request) {
                String requestId = request.getId();
                ((CompletableFuture)MobileRecorderNavigator.this.controller.executeActionAsync(request).thenAccept(result -> Display.getDefault().syncExec(() -> Display.getDefault().timerExec(300, () -> {
                    List capturedObjects;
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.executeActionSuccess", (Object[])new Object[]{new MobileActionResponse(requestId, result.getValue())});
                    IStep step = result.getStep();
                    if (step != null && !MobileRecorderNavigator.this.sessionContext.isRecordingPaused()) {
                        MobileRecorderNavigator.this.sessionContext.addStep(step);
                        BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderStepView.updateRecordedStepsSuccess", (Object[])new Object[]{MobileRecorderNavigator.this.sessionContext.getSteps()});
                    }
                    if ((capturedObjects = result.getObjects()).size() > 0 && !MobileRecorderNavigator.this.sessionContext.isRecordingPaused()) {
                        for (ICapturedObject capturedObject : capturedObjects) {
                            ICapturedObject foundCapturedObject = MobileRecorderNavigator.this.sessionContext.getObjects().stream().filter(o -> o.getHashValue().equals(capturedObject.getHashValue())).findFirst().orElse(null);
                            if (foundCapturedObject != null) continue;
                            MobileRecorderNavigator.this.sessionContext.addObject(capturedObject);
                            BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.mainViewBrowser, (String)"mobileRecorderObjectView.addCapturedObjectSuccess", (Object[])new Object[]{capturedObject});
                        }
                    }
                })))).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    MobileRecorderNavigator.this.logger.error(cause.getMessage(), cause);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.executeActionError", (Object[])new Object[]{cause.getMessage()});
                    return null;
                });
            }

            public void onUpdate() {
                ((CompletableFuture)MobileRecorderNavigator.this.controller.captureDevicePageSourceAsync().thenAccept(pageSource -> BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.updatePageSourceSuccess", (Object[])new Object[]{pageSource}))).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    MobileRecorderNavigator.this.logger.error(cause.getMessage(), cause);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.updatePageSourceError", (Object[])new Object[]{cause.getMessage()});
                    return null;
                });
                ((CompletableFuture)MobileRecorderNavigator.this.controller.captureDeviceScreenshotAsync().thenAccept(screenshot -> BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.updateScreenshotSuccess", (Object[])new Object[]{screenshot}))).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    MobileRecorderNavigator.this.logger.error(cause.getMessage(), cause);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.updateScreenshotError", (Object[])new Object[]{cause.getMessage()});
                    return null;
                });
                ((CompletableFuture)MobileRecorderNavigator.this.controller.captureDeviceScreenInfoAsync().thenAccept(deviceScreenInfo -> BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.updateDeviceScreenInfoSuccess", (Object[])new Object[]{deviceScreenInfo}))).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    MobileRecorderNavigator.this.logger.error(cause.getMessage(), cause);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.updateDeviceScreenInfoError", (Object[])new Object[]{cause.getMessage()});
                    return null;
                });
                ((CompletableFuture)MobileRecorderNavigator.this.controller.getApplicationContextsAsync().thenAccept(contexts -> BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.updateApplicationContextsSuccess", (Object[])new Object[]{contexts}))).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    MobileRecorderNavigator.this.logger.error(cause.getMessage(), cause);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.updateApplicationContextsError", (Object[])new Object[]{cause.getMessage()});
                    return null;
                });
            }

            public void onChooseScreenshotPath() {
                DirectoryDialog directoryDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                String timestamp = String.valueOf(Instant.now().toEpochMilli());
                String screenshotFilename = String.format("screenshot%s.png", timestamp);
                String path = directoryDialog.open();
                if (!StringUtils.isBlank((CharSequence)path)) {
                    File file = new File(path, screenshotFilename);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.onScreenshotPathChosen", (Object[])new Object[]{file.getAbsolutePath()});
                }
            }

            public void onValidateScreenshotPath(String filePath) {
                CompletableFuture<?> pending = MobileRecorderNavigator.this.currentValidation.get();
                if (pending != null && !pending.isDone()) {
                    pending.cancel(true);
                }
                CompletionStage future = ((CompletableFuture)MobileRecorderNavigator.this.controller.validateScreenshotFilePath(filePath).thenRun(() -> BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.validateScreenshotPathSuccess", (Object[])new Object[0]))).exceptionally(e -> {
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    MobileRecorderNavigator.this.logger.error(cause.getMessage(), cause);
                    BrowserFunctionUtil.execute((Browser)MobileRecorderNavigator.this.deviceViewBrowser, (String)"mobileRecorderDeviceView.validateScreenshotPathError", (Object[])new Object[]{cause.getMessage()});
                    return null;
                });
                MobileRecorderNavigator.this.currentValidation.set((CompletableFuture<?>)future);
            }
        });
    }

    private void loadSupportedProviders() {
        this.controller.getSupportedProvidersAsync().thenAccept(supportedProviders -> {
            if (!supportedProviders.isEmpty()) {
                BrowserFunctionUtil.execute((Browser)this.mainViewBrowser, (String)"mobileRecorderConfigurationView.setSupportedProviders", (Object[])new Object[]{supportedProviders});
            }
        });
    }

    private void loadKeywordDefinitions() {
        this.controller.getMobileKeywordDefinitionsAsync().thenAccept(mobileKeywordDefinitions -> {
            if (!mobileKeywordDefinitions.isEmpty()) {
                BrowserFunctionUtil.execute((Browser)this.mainViewBrowser, (String)"commonView.loadKeywordDefinitionsSuccess", (Object[])new Object[]{mobileKeywordDefinitions.stream().map(keywordDefinition -> (KeywordDefinition)keywordDefinition).collect(Collectors.toList())});
            }
        });
    }

    private void updateAppiumLogHandler(Event event) {
        String line = (String)event.getProperty("org.eclipse.e4.data");
        BrowserFunctionUtil.execute((Browser)this.mainViewBrowser, (String)"mobileRecorderConfigurationView.updateAppiumLog", (Object[])new Object[]{line});
    }

    private void subscribeConfigurationEvents() {
        this.eventBroker.subscribe("appium/update/log", this.updateAppiumLogHandler);
    }

    private void unsubscribeConfigurationEvents() {
        this.eventBroker.unsubscribe(this.updateAppiumLogHandler);
    }

    private void mainViewDidLoaded() {
        this.registerMainViewBrowserFunctions();
        BrowserFunctionUtil.execute((Browser)this.mainViewBrowser, (String)"commonView.setTheme", (Object[])new Object[]{ColorUtil.isDarkTheme() ? "dark" : "light"});
        this.loadSupportedProviders();
        this.loadKeywordDefinitions();
        try {
            this.sessionContext.initialize();
            BrowserFunctionUtil.execute((Browser)this.mainViewBrowser, (String)"mobileRecorderConfigurationView.setConfiguration", (Object[])new Object[]{this.sessionContext.getConfiguration()});
        }
        catch (RecorderPreferencesException e) {
            this.logger.error(e.getMessage());
        }
        BrowserFunctionUtil.execute((Browser)this.mainViewBrowser, (String)"commonView.emitAllBrowserFunctionsRegistered", (Object[])new Object[0]);
    }

    private void deviceViewDidLoaded(MobileDevicePlatform devicePlatform) {
        this.registerDeviceViewBrowserFunctions();
        BrowserFunctionUtil.execute((Browser)this.deviceViewBrowser, (String)"commonView.setTheme", (Object[])new Object[]{ColorUtil.isDarkTheme() ? "dark" : "light"});
        BrowserFunctionUtil.execute((Browser)this.deviceViewBrowser, (String)"mobileRecorderDeviceView.init", (Object[])new Object[]{devicePlatform});
        BrowserFunctionUtil.execute((Browser)this.deviceViewBrowser, (String)"commonView.emitAllBrowserFunctionsRegistered", (Object[])new Object[0]);
    }

    public void close() {
        if (this.closeMainDialogTask != null) {
            this.closeMainDialogTask.cancel(true);
        }
        this.unsubscribeConfigurationEvents();
        this.controller.cleanupAsync().whenComplete((result, error) -> {
            if (this.navigatorListener != null) {
                this.navigatorListener.onClose();
            }
        });
    }
}

