/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.utils;

import com.katalon.recorder.core.constant.KeywordPlatform;
import com.katalon.recorder.core.constant.ParameterType;
import com.katalon.recorder.core.domain.model.ArrayParameter;
import com.katalon.recorder.core.domain.model.BuiltinKeywordRef;
import com.katalon.recorder.core.domain.model.IKeywordDefinition;
import com.katalon.recorder.core.domain.model.IKeywordRef;
import com.katalon.recorder.core.domain.model.IParameter;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.ListParameter;
import com.katalon.recorder.core.domain.model.SingleParameter;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionParamValueType;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArrayExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClassExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstructorCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PropertyExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.RangeExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.VariableExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ThrowStatementWrapper;
import com.kms.katalon.composer.testcase.model.InputValueEditorProvider;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.core.mobile.keyword.MobileBuiltInKeywords;
import com.kms.katalon.custom.keyword.KeywordClass;
import com.kms.katalon.custom.keyword.KeywordMethod;
import com.kms.katalon.custom.keyword.KeywordParameter;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.openqa.selenium.Keys;

public class MobileActionUtil {
    private static final String THIS_VARIABLE = "this";

    public static KeywordClass getMobileKeywordClass() {
        return KeywordController.getInstance().getBuiltInKeywordClassByName(MobileBuiltInKeywords.class.getName());
    }

    public static StatementWrapper generateTestStep(IStep step, ASTNodeWrapper parentClassNode) throws ClassNotFoundException {
        IKeywordDefinition keywordDef = step.getKeywordDefinition();
        IKeywordRef keywordRef = keywordDef.getKeywordRef();
        String keywordName = keywordRef.getName();
        KeywordMethod method = MobileActionUtil.getMethodInKeywordDefinition(keywordDef);
        if (method == null) {
            return null;
        }
        MethodCallExpressionWrapper methodCallExpressionWrapper = new MethodCallExpressionWrapper(MobileActionUtil.getMobileKeywordClass().getAliasName(), keywordName, parentClassNode);
        ArgumentListExpressionWrapper argumentListExpressionWrapper = methodCallExpressionWrapper.getArguments();
        KeywordParameter[] parameters = method.getParameters();
        List keywordParameters = keywordDef.getParameters();
        List arguments = step.getArguments();
        if (parameters.length != keywordParameters.size() || parameters.length != arguments.size()) {
            throw new IllegalArgumentException("Mismatch: method parameters (" + parameters.length + "), keywordParameters (" + keywordParameters.size() + "), arguments (" + arguments.size() + ")");
        }
        int i = 0;
        while (i < keywordParameters.size()) {
            Object argumentValue = arguments.get(i);
            MethodCallExpressionWrapper generatedExpression = null;
            IParameter keywordParameter = (IParameter)keywordParameters.get(i);
            if (keywordParameter instanceof SingleParameter) {
                SingleParameter singleParam = (SingleParameter)keywordParameter;
                ParameterType type = singleParam.getType();
                if (ParameterType.TEST_OBJECT.equals((Object)type)) {
                    generatedExpression = AstEntityInputUtil.createNewFindTestObjectMethodCall((String)((String)argumentValue), (ASTNodeWrapper)parentClassNode);
                } else if (ParameterType.FAILURE_HANDLING.equals((Object)type)) {
                    generatedExpression = AstKeywordsInputUtil.getNewFailureHandlingPropertyExpression(null);
                } else {
                    inputValueType = MobileActionUtil.toInputValueType(singleParam.getType());
                    paramValueType = MobileActionParamValueType.newInstance((InputValueEditorProvider)inputValueType, (String)singleParam.getName());
                    if (InputValueType.String.equals((Object)inputValueType)) {
                        ExpressionWrapper value = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression((String)GroovyStringUtil.toGroovyStringFormat((String)((String)argumentValue)));
                        paramValueType.setValue((Object)value);
                    } else {
                        paramValueType.setValue(MobileActionUtil.getValue(inputValueType, argumentValue, parentClassNode));
                    }
                    generatedExpression = paramValueType.toExpressionWrapper();
                }
            } else if (keywordParameter instanceof ArrayParameter) {
                ArrayParameter arrayParam = (ArrayParameter)keywordParameter;
                inputValueType = InputValueType.Array;
                paramValueType = MobileActionParamValueType.newInstance((InputValueEditorProvider)inputValueType, (String)arrayParam.getName());
                paramValueType.setValue(MobileActionUtil.getValue(inputValueType, argumentValue, parentClassNode));
                generatedExpression = paramValueType.toExpressionWrapper();
            } else if (keywordParameter instanceof ListParameter) {
                ListParameter listParam = (ListParameter)keywordParameter;
                InputValueType inputValueType = InputValueType.List;
                MobileActionParamValueType paramValueType = MobileActionParamValueType.newInstance((InputValueEditorProvider)inputValueType, (String)listParam.getName());
                paramValueType.setValue(MobileActionUtil.getValue(inputValueType, argumentValue, parentClassNode));
                generatedExpression = paramValueType.toExpressionWrapper();
            } else {
                throw new UnsupportedOperationException("Unsupported parameter type: " + String.valueOf(keywordParameter.getClass()));
            }
            argumentListExpressionWrapper.addExpression((ExpressionWrapper)generatedExpression);
            ++i;
        }
        return new ExpressionStatementWrapper((ExpressionWrapper)methodCallExpressionWrapper, parentClassNode);
    }

    private static KeywordMethod getMethodInKeywordDefinition(IKeywordDefinition keywordDef) {
        IKeywordRef keywordRef = keywordDef.getKeywordRef();
        String keywordName = keywordRef.getName();
        KeywordPlatform keywordPlatform = null;
        if (keywordRef instanceof BuiltinKeywordRef) {
            keywordPlatform = ((BuiltinKeywordRef)keywordRef).getPlatform();
        }
        if (KeywordPlatform.MOBILE.equals(keywordPlatform)) {
            String simpleName = MobileActionUtil.getMobileKeywordClass().getSimpleName();
            List keywordMethods = KeywordController.getInstance().getBuiltInKeywords(simpleName);
            for (KeywordMethod keywordMethod : keywordMethods) {
                if (!keywordMethod.getName().equals(keywordName) || !MobileActionUtil.isMatchingKeyword(keywordMethod, keywordDef)) continue;
                return keywordMethod;
            }
        }
        return null;
    }

    private static boolean isMatchingKeyword(KeywordMethod keywordMethod, IKeywordDefinition keywordDef) {
        List parameters;
        boolean sameNumberOfParams;
        KeywordParameter[] keywordParameters = keywordMethod.getParameters();
        boolean bl = sameNumberOfParams = keywordParameters.length == (parameters = keywordDef.getParameters()).size();
        if (!sameNumberOfParams) {
            return false;
        }
        int i = 0;
        while (i < parameters.size()) {
            KeywordParameter keywordParameter;
            IParameter parameter = (IParameter)parameters.get(i);
            String name = parameter.getName();
            if (!StringUtils.equals((CharSequence)name, (CharSequence)(keywordParameter = keywordParameters[i]).getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Object getValue(InputValueType inputValueType, Object value, ASTNodeWrapper parent) {
        switch (inputValueType) {
            case String: {
                return new ConstantExpressionWrapper((Object)((String)value), parent);
            }
            case Number: {
                if (value instanceof Float) {
                    return new ConstantExpressionWrapper((Object)Float.valueOf(((Float)value).floatValue()), parent);
                }
                if (value instanceof Double) {
                    return new ConstantExpressionWrapper((Object)((Double)value), parent);
                }
                if (value instanceof Long) {
                    return new ConstantExpressionWrapper((Object)((Long)value), parent);
                }
                if (value instanceof Byte) {
                    return new ConstantExpressionWrapper((Object)((Byte)value), parent);
                }
                return new ConstantExpressionWrapper((Object)((Integer)value), parent);
            }
            case Boolean: {
                return new ConstantExpressionWrapper((Object)((Boolean)value), parent);
            }
            case Null: {
                return new ConstantExpressionWrapper(parent);
            }
            case Binary: {
                return new BinaryExpressionWrapper(parent);
            }
            case Variable: {
                return new VariableExpressionWrapper(parent);
            }
            case MethodCall: {
                return new MethodCallExpressionWrapper(parent);
            }
            case Condition: {
                return new BooleanExpressionWrapper(parent);
            }
            case Array: {
                return new ArrayExpressionWrapper((ArrayExpression)value, parent);
            }
            case List: {
                return new ListExpressionWrapper(parent);
            }
            case Map: {
                return new MapExpressionWrapper(parent);
            }
            case ClosureList: {
                return new ClosureListExpressionWrapper(parent);
            }
            case Range: {
                return new RangeExpressionWrapper(parent);
            }
            case Property: {
                return new PropertyExpressionWrapper(parent);
            }
            case GlobalVariable: {
                if (parent != null && parent.getScriptClass() != null) {
                    parent.getScriptClass().addImport("internal", "GlobalVariable");
                }
                return new PropertyExpressionWrapper(InputValueType.GlobalVariable.name(), parent);
            }
            case TestObject: {
                return AstEntityInputUtil.createNewFindTestObjectMethodCall((ASTNodeWrapper)parent);
            }
            case WindowsObject: {
                return AstEntityInputUtil.createNewFindWindowsObjectMethodCall((ASTNodeWrapper)parent);
            }
            case Class: {
                return new ClassExpressionWrapper(String.class, parent);
            }
            case TestDataValue: {
                return AstEntityInputUtil.createNewGetTestDataValueExpression(null, (Object)1, (Object)1, (ASTNodeWrapper)parent);
            }
            case TestData: {
                return AstEntityInputUtil.createNewFindTestDataExpression(null, (ASTNodeWrapper)parent);
            }
            case TestCase: {
                return AstEntityInputUtil.createNewFindTestCaseMethodCall(null, (ASTNodeWrapper)parent);
            }
            case Checkpoint: {
                return AstEntityInputUtil.createNewFindCheckpointMethodCall(null, (ASTNodeWrapper)parent);
            }
            case This: {
                return new VariableExpressionWrapper(THIS_VARIABLE, parent);
            }
            case Throwable: {
                return new ConstructorCallExpressionWrapper(ThrowStatementWrapper.DEFAULT_THROW_TYPE, parent);
            }
            case Key: {
                if (parent != null && parent.getScriptClass() != null) {
                    parent.getScriptClass().addImport(Keys.class);
                }
                return new PropertyExpressionWrapper(Keys.class.getSimpleName(), "ENTER", parent);
            }
            case Keys: {
                if (parent != null && parent.getScriptClass() != null) {
                    parent.getScriptClass().addImport(Keys.class);
                }
                return new MethodCallExpressionWrapper(Keys.class, "chord", parent);
            }
            case Closure: {
                return new ClosureExpressionWrapper(new ParameterWrapper[0], parent);
            }
        }
        return new ConstantExpressionWrapper(parent);
    }

    public static InputValueType toInputValueType(ParameterType parameterType) {
        switch (parameterType) {
            case STRING: {
                return InputValueType.String;
            }
            case NUMBER: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case LONG: {
                return InputValueType.Number;
            }
            case BOOLEAN: {
                return InputValueType.Boolean;
            }
            case NULL: {
                return InputValueType.Null;
            }
            case VARIABLE: {
                return InputValueType.Variable;
            }
            case GLOBAL_VARIABLE: {
                return InputValueType.GlobalVariable;
            }
            case METHOD_CALL: {
                return InputValueType.MethodCall;
            }
            case ARRAY: {
                return InputValueType.Array;
            }
            case LIST: {
                return InputValueType.List;
            }
            case MAP: {
                return InputValueType.Map;
            }
            case CLOSURE: {
                return InputValueType.Closure;
            }
            case CLOSURE_LIST: {
                return InputValueType.ClosureList;
            }
            case CONDITION: {
                return InputValueType.Condition;
            }
            case BINARY: {
                return InputValueType.Binary;
            }
            case RANGE: {
                return InputValueType.Range;
            }
            case PROPERTY: {
                return InputValueType.Property;
            }
            case TEST_DATA_VALUE: {
                return InputValueType.TestDataValue;
            }
            case TEST_CASE: {
                return InputValueType.TestCase;
            }
            case TEST_OBJECT: {
                return InputValueType.TestObject;
            }
            case WINDOWS_OBJECT: {
                return InputValueType.WindowsObject;
            }
            case TEST_DATA: {
                return InputValueType.TestData;
            }
            case CHECKPOINT: {
                return InputValueType.Checkpoint;
            }
            case CLASS: {
                return InputValueType.Class;
            }
            case THIS: {
                return InputValueType.This;
            }
            case THROWABLE: {
                return InputValueType.Throwable;
            }
            case KEYS: {
                return InputValueType.Keys;
            }
            case KEY: {
                return InputValueType.Key;
            }
        }
        return InputValueType.String;
    }
}

