/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.mobile.utils;

import com.katalon.mobile.core.enums.MobileDevicePlatform;
import com.katalon.recorder.core.constant.AttributeConditionOperator;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.domain.model.CapturedObjectXPath;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.ICapturedObjectAttribute;
import com.katalon.recorder.core.domain.model.ICapturedObjectXPath;
import com.katalon.recorder.core.domain.model.IWebElementAttribute;
import com.katalon.recorder.core.domain.model.IWebElementXpath;
import com.katalon.recorder.mobile.core.models.CapturedMobileObjectAttribute;
import com.katalon.recorder.mobile.core.models.MobileCapturedObject;
import com.katalon.recorder.mobile.core.models.MobileWebElement;
import com.katalon.recorder.mobile.core.models.MobileWebElementAttribute;
import com.katalon.recorder.mobile.utils.CapturedObjectConverter;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.core.mobile.keyword.internal.MobileLocatorFinder;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.execution.setting.MobileSettingStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;

public class MobileWebElementConverter {
    private static final List<String> ANDROID_ATTRIBUTES = Arrays.asList("checkable", "checked", "class", "clickable", "content-desc", "enabled", "focusable", "focused", "long-clickable", "package", "password", "resource-id", "scrollable", "selection-start", "selection-end", "selected", "text", "hint", "extras", "bounds", "displayed", "contentSize", "a11y-important", "screen-reader-focusable", "input-type", "drawing-order", "showing-hint", "text-entry-key", "multiline", "dismissable", "a11y-focused", "heading", "live-region", "context-clickable", "max-text-length", "content-invalid", "error", "pane-title", "actions");
    private static final List<String> IOS_ATTRIBUTES = Arrays.asList("type", "name", "label", "value", "enabled", "visible", "accessible", "accessible-name", "accessibility-id", "selected", "focused", "placeholderValue", "hasFocus", "isKeyboardShown", "elementOrParentHasKeyboardFocus", "isDisplayed", "isEnabled", "isVisible", "isAccessible", "hasKeyboardFocus", "isSelected");
    private static final List<String> TEXT_CONTAINERS = Arrays.asList("text", "content-desc", "name", "label", "value");

    public static ICapturedObject toCapturedObject(MobileWebElement webElement) {
        MobileCapturedObject capturedObject = new MobileCapturedObject();
        capturedObject.setId(UUID.randomUUID().toString());
        capturedObject.setName(StringEscapeUtils.unescapeHtml4((String)webElement.getName()));
        capturedObject.setDevicePlatform(webElement.getDevicePlatform());
        List attributes = webElement.getAttributes().stream().map(p -> MobileWebElementConverter.convertAttribute(p)).collect(Collectors.toList());
        List xpaths = webElement.getXpaths();
        if (xpaths.size() > 0) {
            IWebElementXpath xpath = (IWebElementXpath)xpaths.get(0);
            CapturedMobileObjectAttribute attribute = new CapturedMobileObjectAttribute();
            attribute.setName("xpath");
            attribute.setValue(xpath.getValue());
            attributes.add(attribute);
        }
        capturedObject.setAttributes(attributes);
        List capturedObjectXpaths = xpaths.stream().map(x -> MobileWebElementConverter.convertXpath(x)).collect(Collectors.toList());
        capturedObject.setXPaths(capturedObjectXpaths);
        MobileSettingStore mobileSettingStore = MobileSettingStore.getStore();
        LocatorStrategy defaultLocatorStrategy = mobileSettingStore.getDefaultLocatorStrategy();
        capturedObject.setLocatorType(LocatorType.valueOf((String)defaultLocatorStrategy.toString()));
        MobileTestObject mobileTestObject = CapturedObjectConverter.toMobileTestObject((ICapturedObject)capturedObject);
        List locatorStrategies = LocatorStrategy.getLocatorStrategies((MobilePlatform)mobileTestObject.getPlatform());
        for (LocatorStrategy locatorStrategy : locatorStrategies) {
            String locator = MobileLocatorFinder.findLocator((TestObject)mobileTestObject, (LocatorStrategy)locatorStrategy);
            capturedObject.addLocator(LocatorType.valueOf((String)locatorStrategy.toString()), locator);
        }
        return capturedObject;
    }

    public static MobileWebElement toMobileWebElement(WebElement element, MobileDevicePlatform platform) {
        if (element == null) {
            return null;
        }
        ArrayList<MobileWebElementAttribute> properties = new ArrayList<MobileWebElementAttribute>();
        List<String> attributes = MobileWebElementConverter.getAttributesByPlatform(platform);
        for (String attribute : attributes) {
            String value = MobileWebElementConverter.getAttributeOrEmpty(element, attribute);
            if (value.isEmpty()) continue;
            properties.add(new MobileWebElementAttribute(attribute, value));
        }
        Rectangle rect = element.getRect();
        properties.add(new MobileWebElementAttribute("x", String.valueOf(rect.getX())));
        properties.add(new MobileWebElementAttribute("y", String.valueOf(rect.getY())));
        properties.add(new MobileWebElementAttribute("width", String.valueOf(rect.getWidth())));
        properties.add(new MobileWebElementAttribute("height", String.valueOf(rect.getHeight())));
        String hashValue = UUID.randomUUID().toString();
        String name = "";
        if (MobileDevicePlatform.ANDROID.equals((Object)platform)) {
            name = MobileWebElementConverter.getAttributeOrEmpty(element, "text");
        } else if (MobileDevicePlatform.IOS.equals((Object)platform)) {
            name = MobileWebElementConverter.getAttributeOrEmpty(element, "label");
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = MobileWebElementConverter.getAttributeOrEmpty(element, "value");
            }
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = MobileWebElementConverter.getAttributeOrEmpty(element, "name");
            }
        }
        MobileWebElement mobileElement = new MobileWebElement(hashValue, name, properties, Collections.emptyList());
        mobileElement.setDevicePlatform(platform);
        return mobileElement;
    }

    private static List<String> getAttributesByPlatform(MobileDevicePlatform platform) {
        if (platform == MobileDevicePlatform.ANDROID) {
            return ANDROID_ATTRIBUTES;
        }
        if (platform == MobileDevicePlatform.IOS) {
            return IOS_ATTRIBUTES;
        }
        return Collections.emptyList();
    }

    private static String getAttributeOrEmpty(WebElement element, String attribute) {
        try {
            String v = element.getAttribute(attribute);
            return v != null ? v : "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static ICapturedObjectAttribute convertAttribute(IWebElementAttribute p) {
        CapturedMobileObjectAttribute rp = new CapturedMobileObjectAttribute();
        if (p == null) {
            return rp;
        }
        String name = p.getName();
        String value = p.getValue();
        rp.setName(name);
        rp.setOperator(AttributeConditionOperator.EQUALS);
        if (TEXT_CONTAINERS.contains(name)) {
            rp.setValue(StringEscapeUtils.unescapeHtml4((String)value));
        } else {
            rp.setValue(value);
        }
        rp.setEnabled(MobileCapturedObject.STABLE_ATTRIBUTES.contains(name));
        return rp;
    }

    private static ICapturedObjectXPath convertXpath(IWebElementXpath x) {
        return new CapturedObjectXPath(x.getName(), x.getValue(), x.getSelected().booleanValue());
    }
}

