package com.kms.katalon.core.windows.keyword.builtin


import java.text.MessageFormat

import org.openqa.selenium.WebElement

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.AbstractKeyword
import com.kms.katalon.core.keyword.internal.KeywordMain
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.logging.KeywordLogger
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.windows.driver.WindowsDriverFactory
import com.kms.katalon.core.windows.keyword.helper.WindowsActionHelper
import com.kms.katalon.core.windows.model.StringMatchingStrategy

import io.appium.java_client.windows.WindowsDriver

@Action(value = "switchToWindowTitle")
public class SwitchToWindowTitleKeyword extends AbstractKeyword {

    private KeywordLogger logger = KeywordLogger.getInstance(StartApplicationKeyword.class)

    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return SupportLevel.NOT_SUPPORT
    }

    @Override
    public Object execute(Object ...params) {
        String windowTitle = (String) params[0];
        StringMatchingStrategy strategy = getOptionalParam(params, 1, StringMatchingStrategy.CONTAINS);
        FailureHandling flowControl = getFailureHandling(params);
        return switchToWindowTitle(windowTitle, strategy, flowControl);
    }

    public WindowsDriver switchToWindowTitle(String windowTitle, StringMatchingStrategy strategy,
            FailureHandling flowControl) throws StepFailedException {
        return (WindowsDriver) KeywordMain.runKeyword({
            WindowsActionHelper.create(WindowsDriverFactory.getWindowsSession()).switchToWindowTitle(windowTitle, strategy);
            logger.logPassed(MessageFormat.format("Switch to window ''{0}'' successfully", windowTitle));
            return WindowsDriverFactory.getWindowsDriver();
        }, flowControl);
    }
}
