package com.kms.katalon.core.mobile.keyword.builtin

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.StringConstants
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumDriver

@Action(value = "switchToNative")
public class SwitchToNativeKeyword extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        FailureHandling flowControl = (FailureHandling)(params.length > 0 && params[0] instanceof FailureHandling ? params[0] : RunConfiguration.getDefaultFailureHandling())
        switchToNative(flowControl)
    }

    @CompileStatic
    public void switchToNative(FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            AppiumDriver driver = getAnyAppiumDriver()
            boolean result = internalSwitchToNativeContext(driver)
            if (result) {
                logger.logPassed(StringConstants.KW_LOG_PASSED_SWITCH_NATIVE)
            } else {
                MobileKeywordMain.stepFailed(StringConstants.KW_LOG_FAILED_SWITCH_NATIVE, flowControl, null, true)
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), StringConstants.KW_MSG_UNABLE_SWITCH_NATIVE)
    }
}
