package com.kms.katalon.core.enums.mobile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;

public enum LocatorStrategy {
    ATTRIBUTES("Attributes"),
    ACCESSIBILITY("Accessibility ID"),
    CLASS_NAME("Class Name"),
    ID("ID"),
    NAME("Name"),
    XPATH("XPATH"),
    IMAGE("Image"),
    ANDROID_VIEWTAG("Android View Tag"),
    ANDROID_UI_AUTOMATOR("Android UI Automator"),
    IOS_PREDICATE_STRING("iOS Predicate String"),
    IOS_CLASS_CHAIN("iOS Class Chain"),
    CUSTOM("Custom");

    private final String name;

    private LocatorStrategy(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static List<LocatorStrategy> getLocatorStrategies() {
        return new ArrayList<>(Arrays.asList(LocatorStrategy.values()));
    }

    public static String[] getStrategyNames() {
        List<String> strategies = new ArrayList<>();
        for (LocatorStrategy str : values()) {
            strategies.add(str.getName());
        }

        return strategies.toArray(new String[0]);
    }

    public static List<LocatorStrategy> getLocatorStrategies(MobilePlatform platform) {
        if (MobilePlatform.ANDROID.equals(platform)) {
            return getLocatorStrategies().stream()
                    .filter(s -> !LocatorStrategy.IOS_CLASS_CHAIN.equals(s)
                            && !LocatorStrategy.IOS_PREDICATE_STRING.equals(s))
                    .collect(Collectors.toList());
        } else if (MobilePlatform.IOS.equals(platform)) {
            return getLocatorStrategies().stream()
                    .filter(s -> !LocatorStrategy.ANDROID_UI_AUTOMATOR.equals(s)
                            && !LocatorStrategy.ANDROID_VIEWTAG.equals(s))
                    .collect(Collectors.toList());
        }

        return Collections.emptyList();
    }

    public static LocatorStrategy valueOfStrategy(String strategy) {
        if (StringUtils.isEmpty(strategy)) {
            return null;
        }

        for (LocatorStrategy str : values()) {
            if (StringUtils.equalsIgnoreCase(str.getName(), strategy)) {
                return str;
            }
        }

        throw new IllegalArgumentException("Strategy: " + strategy + " not found");
    }
}
