package com.kms.katalon.core.keyword.internal;

import com.kms.katalon.core.keyword.IKeywordManager;
import com.kms.katalon.core.keyword.KeywordContext;

public class KeywordManager implements IKeywordManager {

    private KeywordContext currentKeywordContext;

    @Override
    public long getRemainingTimeoutInMillis() {
        if (currentKeywordContext == null) {
            this.currentKeywordContext = new KeywordContext(null, null);
        }

        long elapsedTime = System.currentTimeMillis() - currentKeywordContext.getStartTime();
        return this.currentKeywordContext.getTimeout() - elapsedTime;
    }

    @Override
    public void setCurrentKeywordContext(String keywordPlatform, String keywordName) {
        this.currentKeywordContext = new KeywordContext(keywordPlatform, keywordName);
    }

    @Override
    public void setTimeout(long timeoutInMillis) {
        if (currentKeywordContext == null) {
            this.currentKeywordContext = new KeywordContext(null, null);
        }
        this.currentKeywordContext.setTimeout(timeoutInMillis);
    }
}
