package com.kms.katalon.core.testobject;

import java.util.HashMap;
import java.util.Map;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.enums.mobile.MobilePlatform;

/**
 * An extended class of {@link TestObject} for the Mobile object specifically. MobileTestObject describes the way
 * Katalon Studio finds Appium Element via the <b>mobileLocator</b> and <b>mobileLocatorStrategy</b>.
 * 
 * @since 7.6.0
 * @see LocatorStrategy
 */
public class MobileTestObject extends TestObject {

    private LocatorStrategy locatorStrategy;

    private Map<LocatorStrategy, String> locatorCollection;

    private MobilePlatform platform;

    public MobileTestObject(String objectId) {
        super(objectId);

        locatorCollection = new HashMap<LocatorStrategy, String>();
    }

    /**
     * The locator value of the test object.
     * 
     * @since 7.6.0
     */
    @Deprecated
    public String getLocator() {
        return locatorCollection.get(locatorStrategy);
    }

    /**
     * Sets the locator value for the test object
     * 
     * @param locator the locator value
     * @since 7.6.0
     */
    @Deprecated
    public void setLocator(String locator) {
        locatorCollection.put(locatorStrategy, locator);
    }

    /**
     * The selected locator strategy of the test object.
     * 
     * @since 7.6.0
     */
    public LocatorStrategy getLocatorStrategy() {
        return locatorStrategy;
    }

    /**
     * Sets the selected locator strategy for the test object
     * 
     * @param locatorStrategy an enum value of {@link LocatorStrategy}
     * @since 7.6.0
     */
    public void setLocatorStrategy(LocatorStrategy locatorStrategy) {
        this.locatorStrategy = locatorStrategy;
    }

    public Map<LocatorStrategy, String> getLocatorCollection() {
        return locatorCollection;
    }

    public void setLocatorCollection(Map<LocatorStrategy, String> locatorCollection) {
        this.locatorCollection = locatorCollection;
    }

    public void setLocatorValue(LocatorStrategy locatorStrategy, String locator) {
        locatorCollection.put(locatorStrategy, locator);
    }

    public MobilePlatform getPlatform() {
        return platform;
    }

    public void setPlatform(MobilePlatform platform) {
        this.platform = platform;
    }

    public static MobileTestObject cloneFromTestObject(TestObject source) {
        MobileTestObject mobileTestObject = new MobileTestObject(source.getObjectId());

        // Copy properties
        mobileTestObject.setProperties(source.getProperties());
        mobileTestObject.setXpaths(source.getXpaths());
        mobileTestObject.setSelectorMethod(source.getSelectorMethod());
        mobileTestObject.setSelectorValue(source.getSelectorMethod(),
                source.getSelectorCollection().get(source.getSelectorMethod()));
        mobileTestObject.setSmartSelectorCollection(source.getSmartSelectorCollection());
        mobileTestObject.setImagePath(source.getImagePath());
        mobileTestObject.setUseRelativeImagePath(source.getUseRelativeImagePath());
        mobileTestObject.setParentObject(source.getParentObject());
        mobileTestObject.setParentObjectShadowRoot(source.isParentObjectShadowRoot());

        // Copy cached WebElement if any
        if (source.getCachedWebElement() != null) {
            mobileTestObject.setCachedWebElement(source.getCachedWebElement());
        }

        // Map SelectorMethod to LocatorStrategy
        LocatorStrategy locatorStrategy = mapSelectorMethodToLocatorStrategy(source.getSelectorMethod());
        String locator = source.getSelectorCollection().get(source.getSelectorMethod());

        if (locatorStrategy != null && locator != null) {
            mobileTestObject.setLocatorStrategy(locatorStrategy);
            // mobileTestObject.setLocator(locator);
            mobileTestObject.setLocatorValue(locatorStrategy, locator);
        }

        String devicePlatform = RunConfiguration.getDevicePlatform();
        if ("ANDROID_DRIVER".equals(devicePlatform)) {
            mobileTestObject.setPlatform(MobilePlatform.ANDROID);
        } else if ("IOS_DRIVER".equals(devicePlatform)) {
            mobileTestObject.setPlatform(MobilePlatform.IOS);
        }

        return mobileTestObject;
    }

    private static LocatorStrategy mapSelectorMethodToLocatorStrategy(SelectorMethod selectorMethod) {
        if (selectorMethod == null) {
            return null;
        }
        switch (selectorMethod) {
            case BASIC:
                return LocatorStrategy.ATTRIBUTES;
            case XPATH:
                return LocatorStrategy.XPATH;
            default:
                return null;
        }
    }
}
