package com.kms.katalon.core.testobject.authorization;

public enum DigestQualityOfProtectionDirective {
    // We're using Apache HttpClient v4 which supports only below
    // values of the "qop" field.
    //
    // See https://hc.apache.org/httpcomponents-client-4.5.x/current/httpclient/apidocs/
	UNSPECIFIED("Unspecified"),
    AUTH("auth");
	
    private final String name;

    private DigestQualityOfProtectionDirective(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }
    
    public static DigestQualityOfProtectionDirective fromString(String name) {
	    for (DigestQualityOfProtectionDirective directive : DigestQualityOfProtectionDirective.values()) {
	        if (directive.getName().equals(name)) {
	            return directive;
	        }
	    }
	    
	    throw new IllegalArgumentException("No enum constant with name " + name);
    }
}
