package com.kms.katalon.core.util;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

// import com.kms.katalon.core.util.ConsoleCommandExecutor;

import org.apache.commons.lang3.StringUtils;

import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.helper.LogRecordHelper;
import com.kms.katalon.core.helper.screenrecorder.VideoFileCodec;
import com.kms.katalon.core.helper.screenrecorder.VideoFileFormat;
import com.kms.katalon.core.helper.screenrecorder.VideoQuality;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import java.util.List;

public class VideoRecorderUtil {
    private static final String FFMPEG_COMMAND_PATTERN = """
              		ffmpeg -i \"{0}\" -c:v {1} -crf {2,number,#} -pix_fmt yuv420p -b:v 0 \"{3}\"
            """;

    public static final String SCREEN_RECORDING_NAME_PATTERN_TEST_CASE_NAME = "%s_%d_%d";

    public static final String SCREEN_RECORDING_NAME_PATTERN_SUFFIX = "_%d_%d";

    public static final String SCREEN_RECORDING_NAME_PATTERN_TEST_CASE_NAME_WITH_VAR_BINDING = "%s_%s_%d_%d";

    public static final String SCREEN_RECORDING_NAME_PATTERN_WITH_VAR_BINDING_SUFFIX = "_%s_%d_%d";
    // Non-printable characters (ASCII codes 0-31 and 127).
    // And a set of characters: ? | <> [ ...
    public static final String TC_NAME_BLACKLIST_PATTERN = "[\\x00-\\x1F\\x7F\\?\\[\\]\\\\=/+<>;:\"',|#*\\.]";
    
    public static final int MAX_TEST_CASE_NAME_LENGTH_DTT = 20;

    public static final int MAX_ITERATION_NAME_LENGTH_DTT = 10;

    public static final int FIX_FILE_NAME_LENGTH = 25;

    public static final int MAX_OS_FILE_PATH_LENGTH = 255;

    public static String getScreenRecordingNameSuffix(int index, int retryIndex) {
        return String.format(SCREEN_RECORDING_NAME_PATTERN_SUFFIX, index, retryIndex);
    }

    public static String getScreenRecordingNameWithFormat(ILogRecord logRecord, int tcMaxLength) {
        String iterationVariableValue = ((TestCaseLogRecord) logRecord).getIterationVariableValue();
        iterationVariableValue = cleanIterationName(iterationVariableValue);
        String testCaseName = logRecord.getName();
        int index = LogRecordHelper.getLogRecordIndex(logRecord);
        int retryIdx = LogRecordHelper.getRetyCount(logRecord);

        testCaseName = cleanTestCaseName(testCaseName);
        if (StringUtils.isNotEmpty(iterationVariableValue)) {
            testCaseName = testCaseName + "_" + iterationVariableValue;
        }

        testCaseName = formatTestCaseName(testCaseName, tcMaxLength);

        return String.format(SCREEN_RECORDING_NAME_PATTERN_TEST_CASE_NAME, testCaseName, index + 1, retryIdx);
    }

    public static String getScreenRecordingNameWithFormat(InternalTestCaseContext tcContext, int tcMaxLength) {
        String iterationVariableValue = tcContext.getIterationVariableValue();
        iterationVariableValue = cleanIterationName(iterationVariableValue);
        String testCaseName = getTestCaseNameFromFullPath(tcContext.getTestCaseName());
        int index = tcContext.getTestCaseIndex();
        int retryIdx = tcContext.getRetryIndex();

        testCaseName = cleanTestCaseName(testCaseName);
        if (StringUtils.isNotEmpty(iterationVariableValue)) {
            testCaseName = testCaseName + "_" + iterationVariableValue;
        }
        testCaseName = formatTestCaseName(testCaseName, tcMaxLength);

        return String.format(SCREEN_RECORDING_NAME_PATTERN_TEST_CASE_NAME, testCaseName, index + 1, retryIdx);
    }

    private static String cleanIterationName(String iterName) {
        if (StringUtils.isEmpty(iterName)) {
            return "";
        }
        // accept: character && digit && empty space
        return iterName.replaceAll(TC_NAME_BLACKLIST_PATTERN, "-");
    }
    
    public static String getTestCaseNameFromFullPath(String path) {
        if (path == null || StringUtils.isEmpty(path))
            return "_";
        // Step 1: Trim white spaces at the beginning and end
        path = path.trim();
        var paths = path.split("/");
        assert paths.length > 0 : "arr must has at least one element";
        // take the last part: it is the name of the test case
        return paths[paths.length - 1];
    }

    /**
     * @deprecated use {@link com.kms.katalon.core.util.internal.NamingUtil#sanitizeFileName(String name)} instead for better code organization
     */
    @Deprecated
    public static String cleanTestCaseName(String input) {
        if (input == null || StringUtils.isEmpty(input))
            return "_";
        // accept: character && digit && empty space
        return input.replaceAll(TC_NAME_BLACKLIST_PATTERN, "-");
    }

    /**
     * @deprecated use {@link com.kms.katalon.core.util.internal.NamingUtil#makeEllipsisName(String name)} instead for better code organization
     */
    @Deprecated
    public static String formatTestCaseName(String tc, int maxLength) {
        int numChars = tc.length();
        // If the string is within the limit, return it as is
        if (numChars <= maxLength)
            return tc;
        int n = tc.length();
        int numRemove = numChars - maxLength + 3; // 3 is for "..."
        int half = (numChars - numRemove) / 2;

        // Build the result
        String leftPart = tc.substring(0, half);
        String rightPart = tc.substring(half + numRemove, numChars);
        // make sure the output is something that that less than maxLength
        String res = leftPart + "..." + rightPart;
        return res;
    }
}
