package com.kms.katalon.core.webui.authentication.basic;

import java.net.URL;

import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;

import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.util.UrlUtil;

public class EmbeddedCredentialsUrlBasicAuth implements BasicAuthenticationStrategy {

    @Override
    public boolean navigate(URL url, String username, String password, int timeout) {
        try {
            String usernamePasswordURL = UrlUtil.generateEmbedCredentialsUrl(url, username, password);
            WebDriver driver = DriverFactory.getWebDriver();
            driver.navigate().to(usernamePasswordURL);
            
            return UrlUtil.assertUrlsWithoutProtocol(usernamePasswordURL, driver.getCurrentUrl());
        } catch (UnhandledAlertException e) {
            return false;
        }
    }
}
