package com.kms.katalon.core.webui.driver.firefox;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.util.FileExcutableUtil;
import com.kms.katalon.core.webui.util.OSUtil;

import java.io.File;
import java.io.IOException;

public class FirefoxDriverUtil {

    protected static final KeywordLogger logger = KeywordLogger.getInstance(DriverFactory.class);

    public static String getDriverPath() {
        if (OSUtil.isWindows()) {
            if (OSUtil.is64Bit()) {
                File location = new File(RunConfiguration.getProjectDir(),
                        "Include/drivers/geckodriver_win64/geckodriver.exe");
                if (location.exists()) {
                    logger.logInfo("Custom Gecko detected at location: " + location.getAbsolutePath());
                    return location.getAbsolutePath();
                }
            } else {
                File location = new File(RunConfiguration.getProjectDir(),
                        "Include/drivers/geckodriver_win32/geckodriver.exe");
                if (location.exists()) {
                    logger.logInfo("Custom Gecko detected at location: " + location.getAbsolutePath());
                    return location.getAbsolutePath();
                }
            }
        } else if (OSUtil.isMac()) {
            File location = new File(RunConfiguration.getProjectDir(),
                    "Include/drivers/geckodriver_mac64/geckodriver");
            String geckoDriverPath = location.getAbsolutePath();
            if (location.exists()) {
                try {
                    logger.logInfo("Custom Gecko detected at location: " + location.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(geckoDriverPath);
                } catch (IOException e) {
                    logger.logInfo("Cannot make Gecko driver file : " + location.getAbsolutePath()
                            + " executable");
                }
                return location.getAbsolutePath();
            }
        } else {
            if (OSUtil.isARM()) {
                File location = new File(RunConfiguration.getProjectDir(),
                        "Include/drivers/geckodriver_linux_arm/geckodriver");
                String geckoDriverPath = location.getAbsolutePath();
                if (location.exists()) {
                    try {
                        logger.logInfo(
                                "Custom Gecko detected at location: " + location.getAbsolutePath());
                        FileExcutableUtil.makeFileExecutable(geckoDriverPath);
                    } catch (IOException e) {
                        logger.logInfo("Cannot make Gecko driver file : " + location.getAbsolutePath()
                                + " executable");
                    }
                    return location.getAbsolutePath();
                }
            } else if (OSUtil.is64Bit()) {
                File location = new File(RunConfiguration.getProjectDir(),
                        "Include/drivers/geckodriver_linux64/geckodriver");
                String geckoDriverPath = location.getAbsolutePath();
                if (location.exists()) {
                    try {
                        logger.logInfo(
                                "Custom Gecko detected at location: " + location.getAbsolutePath());
                        FileExcutableUtil.makeFileExecutable(geckoDriverPath);
                    } catch (IOException e) {
                        logger.logInfo("Cannot make Gecko driver file : " + location.getAbsolutePath()
                                + " executable");
                    }
                    return location.getAbsolutePath();
                }
            } else {
                File location = new File(RunConfiguration.getProjectDir(),
                        "Include/drivers/geckodriver_linux32/geckodriver");
                String geckoDriverPath = location.getAbsolutePath();
                if (location.exists()) {
                    try {
                        logger.logInfo(
                                "Custom Gecko detected at location: " + location.getAbsolutePath());
                        FileExcutableUtil.makeFileExecutable(geckoDriverPath);
                    } catch (IOException e) {
                        logger.logInfo("Cannot make Gecko driver file : " + location.getAbsolutePath()
                                + " executable");
                    }
                    return location.getAbsolutePath();
                }
            }
        }

        return RunConfiguration.getDriverSystemProperty(DriverFactory.WEB_UI_DRIVER_PROPERTY,
                StringConstants.CONF_PROPERTY_GECKO_DRIVER_PATH);
    }
}
