package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat

import org.openqa.selenium.WebElement
import org.openqa.selenium.interactions.Actions
import org.openqa.selenium.interactions.WheelInput

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain

import groovy.transform.CompileStatic

@Action(value = "scrollFromElementWithOffset")
public class ScrollFromElementWithOffsetKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject fromElement = getTestObject(params[0])
        int offsetX = (int) params[1]
        int offsetY = (int) params[2]
        int deltaX = (int) params[3]
        int deltaY = (int) params[4]
        int timeOut = (int) params[5]
        FailureHandling flowControl = (FailureHandling)(params.length > 6 && params[6] instanceof FailureHandling ? params[6] : RunConfiguration.getDefaultFailureHandling())
        scrollFromElement(fromElement, offsetX, offsetY, deltaX, deltaY, timeOut, flowControl)
    }

    @CompileStatic
    public void scrollFromElement(TestObject to, int offsetX, int offsetY,
            int deltaX, int deltaY, int timeOut, FailureHandling flowControl) throws StepFailedException {
        WebUIKeywordMain.runKeyword({
            boolean isSwitchIntoFrame = false
            try {
                WebUiCommonHelper.checkTestObjectParameter(to)
                timeOut = WebUiCommonHelper.checkTimeout(timeOut)
                isSwitchIntoFrame = WebUiCommonHelper.switchToParentFrame(to)
                WebElement webElement = WebUIAbstractKeyword.findWebElement(to, timeOut)
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SCROLLING_FROM_OBJ_WITH_OFFSET, to.getObjectId(), offsetX, offsetY))
                int centerOffsX = offsetX - (int)(webElement.size.width / 2)
                int centerOffsY = offsetY - (int)(webElement.size.height / 2)
                WheelInput.ScrollOrigin scrollOrigin = WheelInput.ScrollOrigin.fromElement(webElement, centerOffsX, centerOffsY)
                (new Actions(DriverFactory.getWebDriver()))
                        .scrollFromOrigin(scrollOrigin, deltaX, deltaY).perform()
                logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_SCROLLING_FROM_OBJ_WITH_OFFSET, to.getObjectId(),offsetX, offsetY))
            } finally {
                if (isSwitchIntoFrame) {
                    WebUiCommonHelper.switchToDefaultContent()
                }
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), (to != null) ?
        MessageFormat.format(StringConstants.KW_MSG_CANNOT_SCROLLING_FROM_OBJ_WITH_OFFSET, to.getObjectId(), offsetX, offsetY)
        : StringConstants.KW_MSG_CANNOT_SCROLLING_TO_OBJ)
    }
}
