/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.cucumber.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.cucumber.dialog.RenameFeatureEntityDialog;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.SystemFileController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameFeatureEntityHandler {
    @Inject
    private IEventBroker eventBroker;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                Object object = this.getObject(event);
                if (object instanceof SystemFileTreeEntity) {
                    RenameFeatureEntityHandler.this.execute((SystemFileTreeEntity)object);
                }
            }
        });
    }

    private void execute(SystemFileTreeEntity testListenerTreeEntity) {
        try {
            SystemFileController testListenerController = SystemFileController.getInstance();
            FolderTreeEntity parentTreeFolder = (FolderTreeEntity)testListenerTreeEntity.getParent();
            SystemFileEntity renamedFile = testListenerTreeEntity.getObject();
            FolderEntity parentFolder = parentTreeFolder.getObject();
            RenameFeatureEntityDialog dialog = new RenameFeatureEntityDialog(this.parentShell, (FileEntity)testListenerTreeEntity.getObject(), testListenerController.getSiblingFiles(renamedFile, parentFolder));
            if (dialog.open() != 0) {
                return;
            }
            String newName = dialog.getNewName();
            if (renamedFile.getName().equals(newName)) {
                return;
            }
            IFile iFile = GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject()).getFile(Path.fromOSString((String)renamedFile.getRelativePath()));
            SystemFileEntity newTestListener = testListenerController.renameSystemFile(newName, renamedFile);
            testListenerTreeEntity.setObject((Object)newTestListener);
            iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)testListenerTreeEntity);
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)testListenerTreeEntity);
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Unable to rename Feature file", (String)e.getMessage());
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

