/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.properties.part;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.CssUtil;
import com.kms.katalon.composer.properties.constants.ImageConstants;
import com.kms.katalon.composer.properties.constants.PropertiesMessageConstants;
import com.kms.katalon.controller.PropertiesController;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class PropertiesPart {
    private static final String CANNOT_SAVE_THE_PROPERTIES = PropertiesMessageConstants.PART_EXCEPTION_CANNOT_SAVE_THE_PROPERTIES;
    private static final String DO_YOU_WANT_TO_SAVE_THE_CHANGES_IN_PROPERTIES = PropertiesMessageConstants.PART_MSG_DO_YOU_WANT_TO_SAVE_THE_CHANGES_IN_PROPERTIES;
    private static final String DISCARD_CHANGES = PropertiesMessageConstants.PART_TOOLITEM_DISCARD_CHANGES;
    private static final String SAVE_CHANGES = PropertiesMessageConstants.PART_TOOLITEM_SAVE_CHANGES;
    private static final String ID = StringConstants.ID;
    private static final String NAME = StringConstants.NAME;
    private static final String CREATED_DATE = StringConstants.CREATED_DATE;
    private static final String MODIFIED_DATE = StringConstants.MODIFIED_DATE;
    private static final String TAG = StringConstants.TAG;
    private static final String DESCRIPTION = StringConstants.DESCRIPTION;
    private static final String TAKEN_DATE = PropertiesMessageConstants.PART_LBL_TAKEN_DATE;
    private static final String DATA_TYPE = PropertiesMessageConstants.PART_LBL_DATA_TYPE;
    private ScrolledComposite container;
    private Text txtId;
    private Text txtName;
    private Text txtCreatedDate;
    private Text txtModifiedDate;
    private Text txtTag;
    private Text txtDescription;
    private Text txtCustom;
    private Label lblCustom;
    private ToolItem tiSave;
    private ToolItem tiDiscard;
    private FileEntity entity;
    private boolean isDiscarding;
    @Inject
    private MDirtyable dirty;

    @PostConstruct
    public void postConstruct(Composite parent, MPart part) {
        this.createToolBar(part);
        this.createPartControls(parent);
        this.registerControlListeners();
        this.setInput(null);
    }

    private void createToolBar(MPart part) {
        CTabFolder ctabfolder = (CTabFolder)part.getParent().getWidget();
        ToolBar toolbar = new ToolBar((Composite)ctabfolder, 0x800000);
        toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        MToolBar mToolbar = MMenuFactory.INSTANCE.createToolBar();
        mToolbar.setElementId("com.kms.katalon.composer.properties.toolbar");
        mToolbar.setWidget((Object)toolbar);
        part.setToolbar(mToolbar);
        List toolItems = mToolbar.getChildren();
        MDirectToolItem mtiSave = MMenuFactory.INSTANCE.createDirectToolItem();
        mtiSave.setElementId("com.kms.katalon.composer.properties.toolbar.save");
        toolItems.add(mtiSave);
        MDirectToolItem mtiDiscard = MMenuFactory.INSTANCE.createDirectToolItem();
        mtiDiscard.setElementId("com.kms.katalon.composer.properties.toolbar.discard");
        toolItems.add(mtiDiscard);
        this.tiSave = new ToolItem(toolbar, 8);
        this.tiSave.setImage(ImageConstants.IMG_SAVE_16);
        this.tiSave.setToolTipText(SAVE_CHANGES);
        this.tiDiscard = new ToolItem(toolbar, 8);
        this.tiDiscard.setImage(ImageConstants.IMG_REFRESH_16);
        this.tiDiscard.setToolTipText(DISCARD_CHANGES);
    }

    private void resizeContainer(final boolean isCustomFieldVisible) {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                PropertiesPart.this.lblCustom.setVisible(isCustomFieldVisible);
                PropertiesPart.this.txtCustom.setVisible(isCustomFieldVisible);
                ((GridData)PropertiesPart.this.lblCustom.getLayoutData()).exclude = !isCustomFieldVisible;
                ((GridData)PropertiesPart.this.txtCustom.getLayoutData()).exclude = !isCustomFieldVisible;
                Composite mainComposite = PropertiesPart.this.txtCustom.getParent();
                mainComposite.layout(true, true);
                mainComposite.getParent().layout();
            }
        });
    }

    private void createPartControls(Composite parent) {
        this.container = new ScrolledComposite(parent, 768);
        this.container.setLayout((Layout)new GridLayout());
        this.container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.container.setMinSize(300, 200);
        this.container.setExpandHorizontal(true);
        this.container.setExpandVertical(true);
        CssUtil.applyCssClassName((Widget)this.container, (String)Composite.class.getSimpleName());
        this.container.setBackgroundMode(1);
        Composite mainComposite = new Composite((Composite)this.container, 0);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.container.setContent((Control)mainComposite);
        int txtStyle = 2056;
        Label lblId = new Label(mainComposite, 0);
        lblId.setText(ID);
        this.txtId = new Text(mainComposite, txtStyle);
        this.txtId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblName = new Label(mainComposite, 0);
        lblName.setText(NAME);
        this.txtName = new Text(mainComposite, txtStyle);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblTag = new Label(mainComposite, 0);
        lblTag.setText(TAG);
        this.txtTag = new Text(mainComposite, 2048);
        this.txtTag.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDescription = new Label(mainComposite, 0);
        lblDescription.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblDescription.setText(DESCRIPTION);
        this.txtDescription = new Text(mainComposite, 2626);
        GridData descLayoutData = new GridData(4, 4, true, true, 1, 1);
        descLayoutData.heightHint = 80;
        this.txtDescription.setLayoutData((Object)descLayoutData);
        Label lblCreatedDate = new Label(mainComposite, 0);
        lblCreatedDate.setText(CREATED_DATE);
        this.txtCreatedDate = new Text(mainComposite, txtStyle);
        this.txtCreatedDate.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblModifiedDate = new Label(mainComposite, 0);
        lblModifiedDate.setText(MODIFIED_DATE);
        this.txtModifiedDate = new Text(mainComposite, txtStyle);
        this.txtModifiedDate.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblCustom = new Label(mainComposite, 0);
        this.lblCustom.setText(StringConstants.EMPTY);
        this.lblCustom.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtCustom = new Text(mainComposite, txtStyle);
        this.txtCustom.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private void registerControlListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertiesPart.this.setModified(true);
            }
        };
        this.txtTag.addModifyListener(modifyListener);
        this.txtDescription.addModifyListener(modifyListener);
        this.container.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                PropertiesPart.this.resizeContainer(PropertiesPart.this.lblCustom.isVisible());
            }

            public void controlMoved(ControlEvent e) {
                PropertiesPart.this.resizeContainer(PropertiesPart.this.lblCustom.isVisible());
            }
        });
        this.tiSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesPart.this.onSave();
            }
        });
        this.tiDiscard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesPart.this.isDiscarding = true;
                PropertiesPart.this.setModified(false);
                PropertiesPart.this.setInput(PropertiesPart.this.entity);
            }
        });
    }

    private FileEntity saveProperties() {
        if (this.entity == null) {
            return null;
        }
        String currentTag = this.entity.getTag();
        String currentDesc = this.entity.getDescription();
        try {
            this.entity.setTag(this.txtTag.getText());
            this.entity.setDescription(this.txtDescription.getText());
            FileEntity savedEntity = PropertiesController.getInstance().updateProperties(this.entity);
            boolean isNull = savedEntity == null;
            this.setEnabledToolItems(isNull);
            if (isNull) {
                throw new DALException(CANNOT_SAVE_THE_PROPERTIES);
            }
            EventBrokerSingleton.getInstance().getEventBroker().post("PROPERTIES/ENTITY_UPDATED", (Object)savedEntity);
            return savedEntity;
        }
        catch (DALException e) {
            this.entity.setTag(currentTag);
            this.entity.setDescription(currentDesc);
            this.setEnabledToolItems(true);
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)e.getMessage());
            return this.entity;
        }
    }

    @Persist
    public void onSave() {
        if (this.entity == null) {
            return;
        }
        FileEntity savedEntity = this.saveProperties();
        if (savedEntity != null && StringUtils.equals((String)this.entity.getTag(), (String)savedEntity.getTag()) && StringUtils.equals((String)this.entity.getDescription(), (String)savedEntity.getDescription())) {
            this.setModified(false);
        }
    }

    @Inject
    @Optional
    public void setInput(@UIEventTopic(value="PROPERTIES/ENTITY") FileEntity entity) {
        if (this.isModified()) {
            boolean isYes = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.PROPERTIES, (String)DO_YOU_WANT_TO_SAVE_THE_CHANGES_IN_PROPERTIES);
            if (isYes) {
                this.saveProperties();
            }
            this.isDiscarding = !isYes;
            this.setModified(false);
        }
        if (!this.isDiscarding && this.entity != null && entity != null && new EqualsBuilder().append((Object)this.entity.getIdForDisplay(), (Object)entity.getIdForDisplay()).append((Object)this.entity.getDateCreated(), (Object)entity.getDateCreated()).append((Object)this.entity.getDateModified(), (Object)entity.getDateModified()).append((Object)this.entity.getTag(), (Object)entity.getTag()).append((Object)this.entity.getDescription(), (Object)entity.getDescription()).isEquals()) {
            return;
        }
        this.isDiscarding = false;
        this.clearInputFields();
        this.entity = entity;
        boolean isInvalidEntity = entity == null;
        this.setEnabledEditableFields(!isInvalidEntity);
        this.resizeContainer(false);
        if (isInvalidEntity) {
            return;
        }
        this.populateTxtFieldValue(this.txtId, entity.getIdForDisplay());
        this.populateTxtFieldValue(this.txtName, entity.getName());
        this.populateTxtFieldValue(this.txtCreatedDate, entity.getDateCreated());
        this.populateTxtFieldValue(this.txtModifiedDate, entity.getDateModified());
        this.populateTxtFieldValue(this.txtTag, entity.getTag());
        this.populateTxtFieldValue(this.txtDescription, entity.getDescription());
        this.setModified(false);
        if (entity instanceof DataFileEntity) {
            this.setCustomField(DATA_TYPE, ((DataFileEntity)entity).getDriver());
            return;
        }
        if (entity instanceof CheckpointEntity) {
            this.setCustomField(TAKEN_DATE, ((CheckpointEntity)entity).getTakenDate());
        }
    }

    private void setCustomField(final String label, final Object value) {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                PropertiesPart.this.lblCustom.setText(label);
                PropertiesPart.this.populateTxtFieldValue(PropertiesPart.this.txtCustom, value);
            }
        });
        this.resizeContainer(true);
    }

    private void populateTxtFieldValue(Text txtField, Object value) {
        txtField.setRedraw(false);
        txtField.setText(ObjectUtils.toString((Object)value));
        txtField.setRedraw(true);
    }

    private void clearInputFields() {
        this.txtId.setText(StringConstants.EMPTY);
        this.txtName.setText(StringConstants.EMPTY);
        this.txtCreatedDate.setText(StringConstants.EMPTY);
        this.txtModifiedDate.setText(StringConstants.EMPTY);
        this.txtTag.setText(StringConstants.EMPTY);
        this.txtDescription.setText(StringConstants.EMPTY);
        this.lblCustom.setText(StringConstants.EMPTY);
        this.txtCustom.setText(StringConstants.EMPTY);
        this.setModified(false);
    }

    private void setEnabledToolItems(boolean enabled) {
        this.tiSave.setEnabled(enabled);
        this.tiDiscard.setEnabled(enabled);
    }

    private void setEnabledEditableFields(boolean enabled) {
        this.txtTag.setEnabled(enabled);
        this.txtDescription.setEnabled(enabled);
    }

    public boolean isModified() {
        return this.dirty.isDirty();
    }

    public void setModified(boolean isModified) {
        this.dirty.setDirty(isModified);
        this.setEnabledToolItems(isModified);
    }
}

