/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.onboardingtour;

import com.kms.katalon.onboarding.core.domain.model.OnboardingTour;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTourItem;
import com.kms.katalon.onboarding.domain.tour.TourHandler;
import com.kms.katalon.onboarding.onboardingtour.IOnboardingTourRegistry;
import com.kms.katalon.onboarding.onboardingtour.TestSuiteExecutorTour;
import com.kms.katalon.onboarding.onboardingtour.WebRecordingTour;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class OnboardingTourRegistry
implements IOnboardingTourRegistry {
    private Map<String, Class<? extends TourHandler>> tourHandlers = new HashMap<String, Class<? extends TourHandler>>();

    public OnboardingTourRegistry() {
        this.initializeTours();
    }

    @Override
    public TourHandler getTourHandler(OnboardingTour tour) {
        if (tour == null || tour.getId() == null) {
            return null;
        }
        Class<? extends TourHandler> handlerClass = this.tourHandlers.get(tour.getId());
        if (handlerClass == null) {
            return null;
        }
        try {
            return handlerClass.getDeclaredConstructor(OnboardingTour.class).newInstance(tour);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void initializeTours() {
        this.registerTour(OnboardingTourItem.WEB_RECORDING_TOUR.getTourId(), WebRecordingTour.class);
        this.registerTour(OnboardingTourItem.TEST_SUITE_EXECUTOR_TOUR.getTourId(), TestSuiteExecutorTour.class);
    }

    private void registerTour(String tourId, Class<? extends TourHandler> tourHandlerClass) {
        this.tourHandlers.put(tourId, tourHandlerClass);
    }
}

