/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import groovy.lang.GroovySystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImmutableClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.trait.Traits;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTNode;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.core.util.IntersectionType;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.osgi.framework.Version;

public class GroovyUtils {
    private GroovyUtils() {
    }

    public static Version getGroovyVersion() {
        String version = GroovySystem.getVersion();
        version = version.replaceFirst("-", ".");
        return Version.valueOf((String)version);
    }

    public static int[] getSourceLineSeparatorsIn(char[] code) {
        ArrayList<Integer> lineSeparatorsCollection = new ArrayList<Integer>();
        int i = 0;
        int max = code.length;
        while (i < max) {
            if (code[i] == '\r') {
                if (i + 1 < max && code[i + 1] == '\n') {
                    lineSeparatorsCollection.add(i + 1);
                    ++i;
                } else {
                    lineSeparatorsCollection.add(i);
                }
            } else if (code[i] == '\n') {
                lineSeparatorsCollection.add(i);
            }
            ++i;
        }
        int[] lineSepPositions = new int[lineSeparatorsCollection.size()];
        int i2 = 0;
        while (i2 < lineSeparatorsCollection.size()) {
            lineSepPositions[i2] = (Integer)lineSeparatorsCollection.get(i2);
            ++i2;
        }
        return lineSepPositions;
    }

    public static ASTNode lastElement(AnnotationNode node) {
        AnnotationNode result = node;
        Iterable more = (Iterable)node.getNodeMetaData((Object)"AnnotationCollector");
        if (more != null) {
            Iterator<Object> iterator = more.iterator();
            while (iterator.hasNext()) {
                AnnotationNode an;
                result = an = (AnnotationNode)iterator.next();
            }
        }
        if (result.getMembers() != null) {
            for (Expression expr : result.getMembers().values()) {
                if ((expr = ClassCodeVisitorSupport.getNonInlinedExpression((Expression)expr)).getEnd() <= result.getEnd()) continue;
                result = expr;
            }
        }
        return result;
    }

    public static String[] splitName(ClassNode node) {
        String name = node.getName();
        int index = name.lastIndexOf(36);
        if (index == -1) {
            index = name.lastIndexOf(46);
        }
        return new String[]{name.substring(0, Math.max(0, index)), name.substring(index + 1)};
    }

    public static Set<ClassNode> getAllInterfaces(ClassNode node) {
        LinkedHashSet<ClassNode> result = new LinkedHashSet<ClassNode>();
        if (node.isInterface()) {
            result.add(node);
        }
        GroovyUtils.addAllInterfaces(result, node);
        return result;
    }

    private static void addAllInterfaces(Set<ClassNode> result, ClassNode source) {
        ClassNode[] classNodeArray = source.getInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode face = classNodeArray[n2];
            if (result.add(face = GenericsUtils.parameterizeType((ClassNode)source, (ClassNode)face))) {
                GroovyUtils.addAllInterfaces(result, face);
            }
            ++n2;
        }
        ClassNode sc = source.redirect().getUnresolvedSuperClass(false);
        if (sc != null && !sc.equals((Object)ClassHelper.OBJECT_TYPE)) {
            GroovyUtils.addAllInterfaces(result, GenericsUtils.parameterizeType((ClassNode)source, (ClassNode)sc));
        }
    }

    public static Stream<AnnotationNode> getAnnotations(AnnotatedNode node, String name) {
        return node.getAnnotations().stream().filter(an -> an.getClassNode().getName().equals(name));
    }

    public static ClassNode getBaseType(ClassNode classNode) {
        while (classNode.isArray()) {
            classNode = classNode.getComponentType();
        }
        return classNode;
    }

    public static GenericsType[] getGenericsTypes(ClassNode classNode) {
        GenericsType[] generics = (classNode = GroovyUtils.getBaseType(classNode)).getGenericsTypes();
        if (generics == null || classNode.isGenericsPlaceHolder() || classNode instanceof WideningCategories.LowestUpperBoundClassNode) {
            generics = GenericsType.EMPTY_ARRAY;
        }
        return generics;
    }

    public static GenericsType[] getGenericsTypes(MethodNode methodNode) {
        GenericsType[] generics = methodNode.getGenericsTypes();
        if (generics == null) {
            return GenericsType.EMPTY_ARRAY;
        }
        return generics;
    }

    public static List<ClassNode> getParameterTypes(Parameter ... params) {
        int n;
        int n2 = n = params == null ? 0 : params.length;
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<ClassNode> types = new ArrayList<ClassNode>(n);
        Parameter[] parameterArray = params;
        int n3 = params.length;
        int n4 = 0;
        while (n4 < n3) {
            Parameter param = parameterArray[n4];
            types.add(param.getType());
            ++n4;
        }
        return types;
    }

    public static String[] getParameterTypeSignatures(MethodNode methodNode, boolean resolved) {
        List<ClassNode> types = GroovyUtils.getParameterTypes(methodNode.getParameters());
        return (String[])types.stream().map(type -> GroovyUtils.getTypeSignatureWithoutGenerics(type, true, resolved)).toArray(String[]::new);
    }

    public static Set<ASTNode> getTransformNodes(ClassNode classNode, Class<? extends ASTTransformation> xformType) {
        CompilePhase phase = xformType.getAnnotation(GroovyASTTransformation.class).phase();
        Map map = classNode.getTransforms(phase);
        Set nodes = (Set)map.get(xformType);
        return nodes != null ? Collections.unmodifiableSet(nodes) : Collections.EMPTY_SET;
    }

    public static ClassNode[] getTypeParameterBounds(ClassNode classNode) {
        ClassNode[] bounds;
        Object[] generics;
        if (classNode.isGenericsPlaceHolder() && DefaultGroovyMethods.asBoolean((Object[])(generics = classNode.getGenericsTypes())) && (bounds = generics[0].getUpperBounds()) != null) {
            return bounds;
        }
        return ClassNode.EMPTY_ARRAY;
    }

    public static String getTypeSignature(ClassNode node, boolean qualified, boolean resolved) {
        ClassNode baseType = GroovyUtils.getBaseType(node);
        if (baseType.getName().startsWith("<UnionType:") || baseType instanceof WideningCategories.LowestUpperBoundClassNode && !baseType.getUnresolvedName().startsWith("CommonAssignOf$")) {
            return GroovyUtils.getUnionTypeSignature(node, type -> GroovyUtils.getTypeSignature(type, qualified, resolved));
        }
        if (baseType instanceof IntersectionType) {
            return GroovyUtils.getIntersectionTypeSignature(node, type -> GroovyUtils.getTypeSignature(type, qualified, resolved));
        }
        String signature = GroovyUtils.getTypeSignatureWithoutGenerics(node, qualified, resolved);
        GenericsType[] generics = GroovyUtils.getGenericsTypes(baseType);
        if (generics.length > 0) {
            StringBuilder builder = new StringBuilder(signature);
            builder.setCharAt(builder.length() - 1, '<');
            GenericsType[] genericsTypeArray = generics;
            int n = generics.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gt = genericsTypeArray[n2];
                if (gt.isPlaceholder() || !gt.isWildcard()) {
                    builder.append(GroovyUtils.getTypeSignature(gt.getType(), qualified, resolved));
                } else if (gt.getLowerBound() != null) {
                    builder.append('-').append(GroovyUtils.getTypeSignature(gt.getLowerBound(), qualified, resolved));
                } else if (gt.getUpperBounds() != null && gt.getUpperBounds().length > 0) {
                    builder.append('+').append(GroovyUtils.getTypeSignature(gt.getUpperBounds()[0], qualified, resolved));
                } else {
                    builder.append('*');
                }
                ++n2;
            }
            builder.append('>').append(';');
            return builder.toString();
        }
        return signature;
    }

    public static String getTypeSignatureWithoutGenerics(ClassNode node, boolean qualified, boolean resolved) {
        String name;
        ClassNode baseType = GroovyUtils.getBaseType(node);
        if (baseType.getName().startsWith("<UnionType:") || baseType instanceof WideningCategories.LowestUpperBoundClassNode && !baseType.getUnresolvedName().startsWith("CommonAssignOf$")) {
            return GroovyUtils.getUnionTypeSignature(node, type -> GroovyUtils.getTypeSignatureWithoutGenerics(type, qualified, resolved));
        }
        if (baseType instanceof IntersectionType) {
            return GroovyUtils.getIntersectionTypeSignature(node, type -> GroovyUtils.getTypeSignatureWithoutGenerics(type, qualified, resolved));
        }
        StringBuilder builder = new StringBuilder();
        while (node.isArray()) {
            builder.append('[');
            node = node.getComponentType();
        }
        if (node.isGenericsPlaceHolder()) {
            name = node.getUnresolvedName().replace('#', '!');
        } else if (resolved || node.getOuterClass() == null) {
            name = qualified ? node.getName() : node.getNameWithoutPackage();
        } else {
            List nodes = node.getOuterClasses();
            nodes.add(0, node);
            int i = nodes.size();
            StringBuilder sb = new StringBuilder(((ClassNode)nodes.get(--i)).getName());
            while (i != 0) {
                sb.append('.').append(((ClassNode)nodes.get(--i)).getName().substring(sb.length()));
            }
            if (!qualified && node.getPackageName() != null) {
                sb.delete(0, node.getPackageName().length() + 1);
            }
            name = sb.toString();
        }
        assert (!(name.startsWith("[") || name.contains("<") || name.endsWith(";")));
        int pos = builder.length();
        builder.append(Signature.createTypeSignature((String)name, (boolean)resolved));
        if (resolved && node.isGenericsPlaceHolder()) {
            if (node.getDeclaringClass() != null) {
                return String.valueOf(GroovyUtils.getTypeSignatureWithoutGenerics(node.getDeclaringClass(), qualified, true)) + ':' + 'T' + builder.substring(1);
            }
            builder.setCharAt(pos, 'T');
        }
        return builder.toString();
    }

    private static String getUnionTypeSignature(ClassNode node, Function<ClassNode, String> signer) {
        StringBuilder builder = new StringBuilder();
        while (node.isArray()) {
            builder.append('[');
            node = node.getComponentType();
        }
        ClassNode[] types = node instanceof WideningCategories.LowestUpperBoundClassNode ? node.asGenericsType().getUpperBounds() : (ClassNode[])ReflectionUtils.executePrivateMethod(node.getClass(), "getDelegates", node);
        String signature = Signature.createUnionTypeSignature((String[])((String[])Stream.of(types).map(signer).toArray(String[]::new)));
        return builder.append(signature).toString();
    }

    private static String getIntersectionTypeSignature(ClassNode node, Function<ClassNode, String> signer) {
        StringBuilder builder = new StringBuilder();
        while (node.isArray()) {
            builder.append('[');
            node = node.getComponentType();
        }
        Stream types = ((IntersectionType)node).types.stream();
        String signature = Signature.createIntersectionTypeSignature((String[])((String[])types.map(signer).toArray(String[]::new)));
        return builder.append(signature).toString();
    }

    public static ClassNode getWrapperTypeIfPrimitive(ClassNode type) {
        if (type != null && ClassHelper.isPrimitiveType((ClassNode)type) && !ClassHelper.VOID_TYPE.equals((Object)type)) {
            return ClassHelper.getWrapper((ClassNode)type);
        }
        return type;
    }

    public static List<ImportNode> getAllImportNodes(ModuleNode moduleNode) {
        ArrayList<ImportNode> importNodes = new ArrayList<ImportNode>();
        importNodes.addAll(moduleNode.getImports());
        importNodes.addAll(moduleNode.getStarImports());
        importNodes.addAll(moduleNode.getStaticImports().values());
        importNodes.addAll(moduleNode.getStaticStarImports().values());
        Collections.sort(importNodes, Comparator.comparing(ASTNode::getEnd));
        return importNodes;
    }

    public static MethodNode getAnnotationMethod(AnnotationNode node, String methodName) {
        MethodNode meth = node.getClassNode().getMethod(methodName, Parameter.EMPTY_ARRAY);
        if (meth != null) {
            return meth;
        }
        List nodes = (List)node.getNodeMetaData((Object)"AnnotationCollectorTransform");
        if (nodes != null) {
            for (AnnotationNode aliased : nodes) {
                meth = GroovyUtils.getAnnotationMethod(aliased, methodName);
                if (meth == null) continue;
                return meth;
            }
        }
        return null;
    }

    public static MethodNode getMethod(ClassNode declaringType, String methodName, Parameter ... parameters) {
        MethodNode meth = declaringType.getMethod(methodName, parameters);
        if (meth != null) {
            return meth;
        }
        if (declaringType.isAbstract() || declaringType.isInterface() || GroovyUtils.implementsTrait(declaringType)) {
            HashSet<ClassNode> done = new HashSet<ClassNode>(Collections.singleton(declaringType));
            LinkedList<ClassNode> todo = new LinkedList<ClassNode>();
            ClassNode type = declaringType;
            do {
                ClassNode base;
                if ((base = type.getSuperClass()) != null && !done.contains(base)) {
                    todo.add(base);
                }
                ClassNode[] classNodeArray = type.getInterfaces();
                int n = classNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode face = classNodeArray[n2];
                    if (!done.contains(face)) {
                        todo.add(face);
                    }
                    ++n2;
                }
                type = (ClassNode)todo.peek();
                if (type == null) continue;
                meth = type.getMethod(methodName, parameters);
                if (meth != null) {
                    return meth;
                }
                done.add((ClassNode)todo.remove());
            } while (type != null);
        }
        return null;
    }

    public static Expression getTraitFieldExpression(MethodCallExpression call) {
        Matcher m;
        ClassNode objType;
        Expression objExpr = call.getObjectExpression();
        if (objExpr instanceof TernaryExpression) {
            objExpr = ((TernaryExpression)objExpr).getTrueExpression();
        }
        if ((objType = objExpr.getType()).getName().endsWith("$Trait$FieldHelper")) {
            objType = objType.getOuterClass();
        } else if (objType.equals((Object)ClassHelper.CLASS_Type) && DefaultGroovyMethods.asBoolean((Object[])objType.getGenericsTypes())) {
            objType = objType.getGenericsTypes()[0].getType();
        }
        if (Traits.isTrait((ClassNode)objType) && call.getMethod() instanceof ConstantExpression && (m = Pattern.compile(".+__(\\p{javaJavaIdentifierPart}+)\\$[gs]et").matcher(call.getMethodAsString())).matches()) {
            String fieldName = m.group(1);
            List traitFields = (List)objType.redirect().getNodeMetaData((Object)"trait.fields");
            for (FieldNode field : traitFields) {
                if (!field.getName().equals(fieldName)) continue;
                VariableExpression expr = new VariableExpression((Variable)field);
                expr.setSourcePosition((ASTNode)call);
                return expr;
            }
        }
        return null;
    }

    public static boolean implementsTrait(ClassNode concreteType) {
        return (Boolean)concreteType.getNodeMetaData(Traits.class, x -> {
            ClassNode type = concreteType.redirect();
            do {
                if (!Traits.isTrait((ClassNode)type) && !Stream.of(type.getInterfaces()).anyMatch(Traits::isTrait)) continue;
                return Boolean.TRUE;
            } while ((type = type.getSuperClass()) != null && type != ClassHelper.OBJECT_TYPE);
            return Boolean.FALSE;
        });
    }

    public static ClassNode intersect(List<ClassNode> types) {
        assert (types != null && types.size() > 1);
        return new IntersectionType(types);
    }

    public static boolean isAnonymous(ClassNode node) {
        if (node instanceof InnerClassNode) {
            return ((InnerClassNode)node).isAnonymous();
        }
        if (node != null && node.redirect() instanceof JDTClassNode) {
            return ((JDTClassNode)node.redirect()).isAnonymous();
        }
        return false;
    }

    public static boolean isAssignable(ClassNode source, ClassNode target) {
        return GroovyUtils.isAssignable(false, source, target);
    }

    private static boolean isAssignable(boolean array, ClassNode source, ClassNode target) {
        if (source.isArray() && target.isArray()) {
            return GroovyUtils.isAssignable(true, source.getComponentType(), target.getComponentType());
        }
        if (source.isArray() && !target.equals((Object)ClassHelper.OBJECT_TYPE) && !target.isGenericsPlaceHolder() || target.isArray()) {
            return false;
        }
        boolean result = target.isInterface() ? GeneralUtils.isOrImplements((ClassNode)source, (ClassNode)target) : (array ? (target.isGenericsPlaceHolder() || target.equals((Object)ClassHelper.OBJECT_TYPE) ? !ClassHelper.isPrimitiveType((ClassNode)source) : source.isDerivedFrom(target)) : (source.redirect() instanceof ImmutableClassNode && target.redirect() instanceof ImmutableClassNode ? MetaClassHelper.isAssignableFrom((Class)target.getTypeClass(), (Class)source.getTypeClass()) : GroovyUtils.getWrapperTypeIfPrimitive(source).isDerivedFrom(target)));
        ClassNode[] bounds = GroovyUtils.getTypeParameterBounds(target);
        int i = 1;
        while (i < bounds.length && result) {
            result = GroovyUtils.isAssignable(array, source, bounds[i]);
            ++i;
        }
        return result;
    }

    public static boolean isDeprecated(ASTNode node) {
        if (node instanceof PropertyNode && ((PropertyNode)node).getField() != null) {
            node = ((PropertyNode)node).getField();
        } else if (node instanceof ClassNode) {
            node = ((ClassNode)node).redirect();
        }
        if (node instanceof JDTNode) {
            return ((JDTNode)node).isDeprecated();
        }
        ASTNode o = node instanceof VariableExpression ? ((VariableExpression)node).getAccessedVariable() : node;
        int flags = 0;
        if (o instanceof Variable) {
            flags = ((Variable)o).getModifiers();
        } else if (o instanceof ClassNode) {
            flags = ((ClassNode)o).getModifiers();
        } else if (o instanceof MethodNode) {
            flags = ((MethodNode)o).getModifiers();
        }
        if (Flags.isDeprecated((int)flags)) {
            return true;
        }
        if (!(o instanceof AnnotatedNode)) {
            return false;
        }
        return GroovyUtils.getAnnotations((AnnotatedNode)node, "java.lang.Deprecated").anyMatch(x -> true);
    }

    public static boolean isScript(ClassNode node) {
        return !node.isAbstract() && node.isScript();
    }

    public static boolean isSynthetic(FieldNode node) {
        return Flags.isSynthetic((int)node.getModifiers());
    }

    public static boolean isSynthetic(MethodNode node) {
        return Flags.isSynthetic((int)node.getModifiers());
    }

    public static boolean isUsingGenerics(MethodNode node) {
        if (DefaultGroovyMethods.asBoolean((Object[])node.getGenericsTypes())) {
            return true;
        }
        if (GroovyUtils.getBaseType(node.getReturnType()).isUsingGenerics()) {
            return true;
        }
        for (ClassNode type : GroovyUtils.getParameterTypes(node.getParameters())) {
            if (!GroovyUtils.getBaseType(type).isUsingGenerics()) continue;
            return true;
        }
        return false;
    }

    public static ClassNode makeType(String typeNameWithoutGenerics) {
        int i = typeNameWithoutGenerics.lastIndexOf(91);
        if (i < 0) {
            return ClassHelper.make((String)typeNameWithoutGenerics);
        }
        return GroovyUtils.makeType(typeNameWithoutGenerics.substring(0, i)).makeArray();
    }

    public static void updateClosureWithInferredTypes(ClassNode closureType, ClassNode returnType, Parameter[] parameters) {
        if (closureType.getName().equals("groovy.lang.Closure") && closureType.isRedirectNode()) {
            closureType.setGenericsTypes(new GenericsType[]{GroovyUtils.getWrapperTypeIfPrimitive(returnType).asGenericsType()});
        }
    }
}

