/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug;

import groovy.util.Proxy;
import java.util.Iterator;
import org.codehaus.groovy.eclipse.debug.JDITargetDelegate;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaValue;

public class JDIIterator
implements Iterator<Proxy> {
    private final IJavaObject iteratorObj;
    private final JDITargetDelegate delegate;

    public JDIIterator(IJavaObject iteratorObj, JDITargetDelegate delegate) {
        delegate.disableCollection(iteratorObj);
        this.iteratorObj = iteratorObj;
        this.delegate = delegate;
    }

    @Override
    public boolean hasNext() {
        try {
            IJavaValue next = this.iteratorObj.sendMessage("hasNext", "()Z", new IJavaValue[0], this.delegate.getThread(), false);
            return this.delegate.convertToBoolean(next);
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Proxy next() {
        try {
            IJavaValue next = this.iteratorObj.sendMessage("next", "()Ljava/lang/Object;", new IJavaValue[0], this.delegate.getThread(), false);
            return this.delegate.createProxyFor(next);
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        try {
            this.iteratorObj.sendMessage("remove", "()V", new IJavaValue[0], this.delegate.getThread(), false);
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
    }
}

