/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.domain.model;

import com.katalon.recorder.core.constant.RecordingConnectionStatus;
import com.katalon.recorder.core.constant.WebRecorderEngineType;
import com.katalon.recorder.web.domain.model.IWebRecordingConnection;
import com.katalon.recorder.web.domain.model.IWebRecordingConnectionMetadata;

public class WebRecordingConnection
implements IWebRecordingConnection {
    protected final String recordingConnectionId;
    protected final IWebRecordingConnectionMetadata metadata;
    protected RecordingConnectionStatus status;

    public WebRecordingConnection(String recordingConnectionId, IWebRecordingConnectionMetadata metadata) {
        this.recordingConnectionId = recordingConnectionId;
        this.metadata = metadata;
        this.status = RecordingConnectionStatus.CONNECTED;
    }

    public String getRecordingConnectionId() {
        return this.recordingConnectionId;
    }

    public RecordingConnectionStatus getStatus() {
        return this.status;
    }

    public void setStatus(RecordingConnectionStatus status) {
        this.status = status;
    }

    @Override
    public IWebRecordingConnectionMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean isBuiltInEngine() {
        return WebRecorderEngineType.BUILT_IN.equals((Object)this.metadata.getEngineType());
    }

    @Override
    public boolean isExtensionEngine() {
        return WebRecorderEngineType.EXTENSION.equals((Object)this.metadata.getEngineType());
    }

    @Override
    public boolean isCompatibleEngine() {
        return this.metadata.getEngineCompatible();
    }

    public boolean isActive() {
        return RecordingConnectionStatus.RECORDING.equals((Object)this.status) || RecordingConnectionStatus.PAUSED.equals((Object)this.status);
    }
}

