/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.domain.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.capability.constant.DriverType;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.IRecordingConnection;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.IVariable;
import com.katalon.recorder.core.infrastructure.dto.ASTNodeWrapperAdapter;
import com.katalon.recorder.web.constant.WebRecordingStatus;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.domain.model.IWebDriverConnection;
import com.katalon.recorder.web.domain.model.IWebRecorderSetting;
import com.katalon.recorder.web.domain.model.IWebRecordingConnection;
import com.katalon.recorder.web.domain.model.IWebRecordingSession;
import com.katalon.recorder.web.domain.model.IWebTestDesignSetting;
import com.katalon.recorder.web.domain.model.WebRecordingRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRecordingSession
implements IWebRecordingSession {
    private static final Logger logger = LoggerFactory.getLogger(WebRecordingSession.class);
    private WebRecordingStatus recordingStatus = WebRecordingStatus.CONFIGURING;
    private WebRecordingRequest recordingRequest;
    private IWebRecorderSetting recorderSetting;
    private IWebTestDesignSetting testDesignSetting;
    private final ConcurrentHashMap<String, IWebRecordingConnection> recordingConnections = new ConcurrentHashMap();
    private final ConcurrentHashMap<DriverType, IWebDriverConnection> webDriverConnections = new ConcurrentHashMap();
    private List<IWebCapturedObject> capturedObjects = Collections.synchronizedList(new ArrayList());
    private List<IStep> steps = Collections.synchronizedList(new ArrayList());
    private Map<String, ASTNodeWrapperAdapter> continuedTestCaseNodeWrapperMap;
    private List<IVariable> variables = Collections.synchronizedList(new ArrayList());
    private List<String> globalVariables = Collections.synchronizedList(new ArrayList());

    @Override
    public IWebDriverConnection getActiveWebDriverConnection() {
        IWebRecordingConnection activeConnection = this.getActiveConnection();
        if (activeConnection == null || activeConnection.getMetadata() == null) {
            return null;
        }
        return this.getWebDriverConnection(activeConnection.getMetadata().getDriverType());
    }

    @Override
    public WebRecordingStatus getRecordingStatus() {
        return this.recordingStatus;
    }

    @Override
    public void setRecordingStatus(WebRecordingStatus recordingStatus) {
        this.recordingStatus = recordingStatus;
    }

    @Override
    public WebRecordingRequest getRecordingRequest() {
        return this.recordingRequest;
    }

    @Override
    public void setRecordingRequest(WebRecordingRequest recordingRequest) {
        this.recordingRequest = recordingRequest;
    }

    @Override
    public IWebRecorderSetting getRecorderSetting() {
        return this.recorderSetting;
    }

    @Override
    public void setRecorderSetting(IWebRecorderSetting recorderSetting) {
        this.recorderSetting = recorderSetting;
    }

    @Override
    public IWebTestDesignSetting getTestDesignSetting() {
        return this.testDesignSetting;
    }

    @Override
    public void setTestDesignSetting(IWebTestDesignSetting testDesignSetting) {
        this.testDesignSetting = testDesignSetting;
    }

    @Override
    public IWebRecordingConnection getRecordingConnection(String recordingConnectionId) {
        return this.recordingConnections.get(recordingConnectionId);
    }

    @Override
    public List<IWebRecordingConnection> getRecordingConnections() {
        return this.recordingConnections.values().stream().sorted(Comparator.comparing(c -> c.getMetadata().getEngineCompatible())).toList();
    }

    @Override
    public void addWebRecordingConnection(IWebRecordingConnection connection) {
        this.recordingConnections.put(connection.getRecordingConnectionId(), connection);
        try {
            logger.info("Added connection | connection = {} | Total = {} | connection ids = {}", new Object[]{new ObjectMapper().writeValueAsString((Object)connection), this.recordingConnections.size(), this.recordingConnections.keys()});
        }
        catch (JsonProcessingException jsonProcessingException) {}
    }

    @Override
    public IWebDriverConnection getWebDriverConnection(DriverType driverType) {
        return this.webDriverConnections.get(driverType);
    }

    @Override
    public List<IWebDriverConnection> getWebDriverConnections() {
        return new ArrayList<IWebDriverConnection>(this.webDriverConnections.values());
    }

    @Override
    public void addWebDriverConnection(IWebDriverConnection webDriverConnection) {
        this.webDriverConnections.put(webDriverConnection.getDriverType(), webDriverConnection);
    }

    @Override
    public IWebRecordingConnection removeConnection(String connectionId) {
        try {
            IWebRecordingConnection iWebRecordingConnection = this.recordingConnections.remove(connectionId);
            return iWebRecordingConnection;
        }
        finally {
            logger.info("Removed connection | connectionId = {} | Total = {}", (Object)connectionId, (Object)this.recordingConnections.size());
        }
    }

    @Override
    public IWebRecordingConnection getActiveConnection() {
        return this.recordingConnections.values().stream().filter(IRecordingConnection::isActive).findFirst().orElse(null);
    }

    @Override
    public List<IWebCapturedObject> getCapturedObjects() {
        return this.capturedObjects;
    }

    @Override
    public void setCapturedObjects(List<IWebCapturedObject> capturedObjects) {
        this.capturedObjects = capturedObjects;
    }

    @Override
    public IWebCapturedObject getCapturedObject(String capturedObjectId) {
        return this.capturedObjects.stream().map(obj -> this.findCapturedObjectRecursive((IWebCapturedObject)obj, capturedObjectId)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private IWebCapturedObject findCapturedObjectRecursive(IWebCapturedObject obj, String capturedObjectId) {
        if (obj.getId().equals(capturedObjectId)) {
            return obj;
        }
        if (obj.getChildren() != null && !obj.getChildren().isEmpty()) {
            for (ICapturedObject child : obj.getChildren()) {
                IWebCapturedObject webCapturedObject;
                IWebCapturedObject found;
                if (!(child instanceof IWebCapturedObject) || (found = this.findCapturedObjectRecursive(webCapturedObject = (IWebCapturedObject)child, capturedObjectId)) == null) continue;
                return found;
            }
        }
        return null;
    }

    @Override
    public void addCapturedObjects(List<IWebCapturedObject> capturedObjects) {
        this.capturedObjects.addAll(capturedObjects);
    }

    @Override
    public List<IStep> getSteps() {
        return this.steps;
    }

    @Override
    public void setSteps(List<IStep> steps) {
        this.steps = steps;
    }

    @Override
    public List<IVariable> getVariables() {
        return this.variables;
    }

    @Override
    public void setVariables(List<IVariable> variables) {
        this.variables = variables;
    }

    @Override
    public List<String> getGlobalVariables() {
        return this.globalVariables;
    }

    @Override
    public void setGlobalVariables(List<String> globalVariables) {
        this.globalVariables = globalVariables;
    }

    @Override
    public void addStep(IStep step) {
        this.steps.add(step);
    }

    @Override
    public void updateLastStep(IStep updatedStep) {
        if (this.steps.isEmpty()) {
            return;
        }
        this.steps.set(this.steps.size() - 1, updatedStep);
    }

    @Override
    public Map<String, ASTNodeWrapperAdapter> getContinuedTestCaseNodeWrapperMap() {
        return this.continuedTestCaseNodeWrapperMap;
    }

    @Override
    public void setContinuedTestCaseNodeWrapperMap(Map<String, ASTNodeWrapperAdapter> currentTestCaseNodeWrapperList) {
        this.continuedTestCaseNodeWrapperMap = currentTestCaseNodeWrapperList;
    }

    @Override
    public IWebDriverConnection removeWebDriverConnection(DriverType driverType) {
        return this.webDriverConnections.remove(driverType);
    }
}

