/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.kms.katalon.composer.testcase.model.InputValueEditorProvider;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.webui.recorder.action.HTMLAction;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionMapping;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionParamValueType;
import com.kms.katalon.composer.webui.recorder.action.IHTMLAction;
import com.kms.katalon.composer.webui.recorder.util.HTMLActionUtil;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.util.HTMLElementUtil;
import com.kms.katalon.objectspy.util.WebElementUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class HTMLActionJsonParser {
    public static HTMLActionMapping parseJsonIntoHTMLActionMapping(String jsonString) throws JsonSyntaxException, UnsupportedEncodingException {
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonElement = jsonParser.parse(HTMLElementUtil.decodeURIComponent((String)jsonString));
        if (!(jsonElement instanceof JsonObject)) {
            return null;
        }
        if (!jsonElement.getAsJsonObject().has("action")) {
            return null;
        }
        return new HTMLActionJson((JsonObject)jsonElement).buildActionMapping();
    }

    public static class HTMLActionJson {
        private static final int KEYCODE_ENTER = 13;
        public static final String ACTION_DATA_NEW_VALUE_KEY = "newValue";
        public static final String ACTION_DATA_OLD_VALUE_KEY = "oldValue";
        public static final String DESELECT_ACTION_KEY = "deselect";
        public static final String SELECT_ACTION_KEY = "select";
        public static final String ACTION_WINDOW_ID_KEY = "windowId";
        public static final String SWITCH_TO_WINDOW_ACTION_KEY = "switchToWindow";
        public static final String DOUBLE_CLICK_ACTION_KEY = "doubleClick";
        public static final String MOUSE_CLICK_ACTION_DATA_RIGHT_CLICK = "right";
        public static final String MOUSE_CLICK_ACTION_DATA_LEFT_CLICK = "left";
        public static final String MOUSE_CLICK_ACTION_KEY = "click";
        public static final String MOUSE_OVER = "MouseOver";
        public static final String VERIFY_ELEMENT_TEXT = "VerifyElementText";
        public static final String VERIFY_ELEMENT_PRESENT = "VerifyElementPresent";
        public static final String VERIFY_ELEMENT_NOT_PRESENT = "VerifyElementNotPresent";
        public static final String VERIFY_ELEMENT_VISIBLE = "VerifyElementVisible";
        public static final String VERIFY_ELEMENT_NOT_VISIBLE = "VerifyElementNotVisible";
        public static final String VERIFY_ELEMENT_CLICKABLE = "VerifyElementClickable";
        public static final String VERIFY_ELEMENT_NOT_CLICKABLE = "VerifyElementNotClickable";
        public static final String WAIT_FOR_ELEMENT_PRESENT = "WaitForElementPresent";
        public static final String WAIT_FOR_ELEMENT_NOT_PRESENT = "WaitForElementNotPresent";
        public static final String WAIT_FOR_ELEMENT_VISIBLE = "WaitForElementVisible";
        public static final String WAIT_FOR_ELEMENT_NOT_VISIBLE = "WaitForElementNotVisible";
        public static final String ELEMENT_TYPE_TEXTAREA = "textarea";
        public static final String ELEMENT_TYPE_SELECT = "select";
        public static final String ELEMENT_TYPE_INPUT_CHECKBOX = "checkbox";
        public static final String ELEMENT_TYPE_INPUT = "input";
        public static final String INPUT_CHANGE_ACTION_KEY = "inputChange";
        public static final String NAVIGATE_ACTION_KEY = "navigate";
        public static final String ACTION_DATA_KEY = "actionData";
        public static final String ACTION_NAME_KEY = "actionName";
        public static final String ACTION_KEY = "action";
        public static final String SEND_KEYS_ACTION_KEY = "sendKeys";
        public static final String NEW_TAB_ACTION_KEY = "newTab";
        private JsonObject actionObject;
        private String actionName;
        private String actionData;
        private WebElement element;
        public static final String UTF8_BOM = "\ufeff";

        public HTMLActionJson(JsonObject jsonObject) throws UnsupportedEncodingException {
            this.init(jsonObject);
        }

        private void init(JsonObject jsonObject) throws UnsupportedEncodingException {
            this.actionObject = HTMLActionJson.getActionObject(jsonObject);
            if (this.actionObject == null) {
                throw new IllegalArgumentException();
            }
            this.actionName = HTMLActionJson.getActionName(this.actionObject);
            if (this.actionName == null) {
                throw new IllegalArgumentException();
            }
            this.actionData = HTMLActionJson.getActionData(this.actionObject);
            if (!this.actionName.equals(NAVIGATE_ACTION_KEY)) {
                this.element = WebElementUtils.buildWebElement((JsonObject)jsonObject, (boolean)false);
            }
            if (HTMLActionJson.isSelectOrDeselectAction(this.actionObject, this.actionName, this.element)) {
                JsonObject actionDataObject = this.actionObject.get(ACTION_DATA_KEY).getAsJsonObject();
                List<String> oldValues = HTMLActionJson.getDataValueList(actionDataObject, ACTION_DATA_OLD_VALUE_KEY);
                List<String> newValues = HTMLActionJson.getDataValueList(actionDataObject, ACTION_DATA_NEW_VALUE_KEY);
                if (newValues.size() > oldValues.size()) {
                    newValues.removeAll(oldValues);
                    this.actionName = "select";
                    this.actionData = newValues.get(0);
                } else if (newValues.size() < oldValues.size()) {
                    oldValues.removeAll(newValues);
                    this.actionName = DESELECT_ACTION_KEY;
                    this.actionData = oldValues.get(0);
                } else {
                    this.actionName = "select";
                    this.actionData = newValues.get(0);
                }
            }
        }

        private static boolean isSelectOrDeselectAction(JsonObject actionObject, String actionName, WebElement element) {
            return element != null && element.getTag().toLowerCase().equals("select") && actionName.equals(INPUT_CHANGE_ACTION_KEY) && actionObject.get(ACTION_DATA_KEY).isJsonObject();
        }

        private static String getActionData(JsonObject actionObject) {
            if (actionObject.has(ACTION_DATA_KEY) && actionObject.get(ACTION_DATA_KEY).isJsonPrimitive()) {
                return actionObject.get(ACTION_DATA_KEY).getAsString();
            }
            return null;
        }

        private static JsonObject getActionObject(JsonObject jsonObject) {
            if (jsonObject.has(ACTION_KEY) && jsonObject.get(ACTION_KEY).isJsonObject()) {
                return jsonObject.getAsJsonObject(ACTION_KEY);
            }
            return null;
        }

        private static String getActionName(JsonObject actionObject) {
            if (actionObject.has(ACTION_NAME_KEY) && actionObject.get(ACTION_NAME_KEY).isJsonPrimitive()) {
                return actionObject.get(ACTION_NAME_KEY).getAsString();
            }
            return null;
        }

        private static List<String> getDataValueList(JsonObject actionDataObject, String memberKey) {
            ArrayList<String> dataValuesList = new ArrayList<String>();
            if (!actionDataObject.has(memberKey) || !actionDataObject.get(memberKey).isJsonArray()) {
                return dataValuesList;
            }
            JsonArray valueArray = actionDataObject.get(memberKey).getAsJsonArray();
            int i = 0;
            while (i < valueArray.size()) {
                dataValuesList.add(valueArray.get(i).getAsString());
                ++i;
            }
            return dataValuesList;
        }

        public HTMLActionMapping buildActionMapping() {
            HTMLActionMapping newActionMapping = HTMLActionJson.buildActionMapping(this.actionName, this.actionData, this.element);
            if (this.actionObject.has(ACTION_WINDOW_ID_KEY)) {
                String windowId = this.actionObject.get(ACTION_WINDOW_ID_KEY).getAsString();
                newActionMapping.setWindowId(windowId);
            }
            return newActionMapping;
        }

        private static String removeBomEncoding(String value) {
            if (StringUtils.isNotEmpty((CharSequence)value) && value.contains(UTF8_BOM)) {
                return value.replaceAll(UTF8_BOM, "");
            }
            return value;
        }

        private static HTMLActionMapping buildActionMapping(String recordedActionName, String actionData, WebElement targetElement) {
            switch (recordedActionName) {
                case "navigate": {
                    return new HTMLActionMapping((IHTMLAction)HTMLAction.Navigate, actionData, targetElement);
                }
                case "inputChange": {
                    WebElementPropertyEntity contentEditability = targetElement.getProperty("contenteditable");
                    if (contentEditability != null && contentEditability.getValue().equals("true")) {
                        actionData = HTMLActionJson.removeBomEncoding(actionData);
                        return new HTMLActionMapping((IHTMLAction)HTMLAction.SetText, actionData, targetElement);
                    }
                    switch (targetElement.getTag().toLowerCase()) {
                        case "input": {
                            WebElementPropertyEntity typeProp = targetElement.getProperty("type");
                            if (typeProp == null) {
                                return new HTMLActionMapping((IHTMLAction)HTMLAction.SetText, actionData, targetElement);
                            }
                            switch (typeProp.getValue().toLowerCase()) {
                                case "checkbox": {
                                    return new HTMLActionMapping((IHTMLAction)(HTMLActionJson.isActionDataTrue(actionData) ? HTMLAction.Check : HTMLAction.Uncheck), actionData, targetElement);
                                }
                            }
                            return new HTMLActionMapping((IHTMLAction)HTMLAction.SetText, actionData, targetElement);
                        }
                        case "textarea": {
                            return new HTMLActionMapping((IHTMLAction)HTMLAction.SetText, actionData, targetElement);
                        }
                    }
                    break;
                }
                case "select": {
                    return new HTMLActionMapping((IHTMLAction)HTMLAction.Select, actionData, targetElement);
                }
                case "deselect": {
                    return new HTMLActionMapping((IHTMLAction)HTMLAction.Deselect, actionData, targetElement);
                }
                case "click": {
                    if (actionData == null) {
                        return null;
                    }
                    switch (actionData) {
                        case "left": {
                            return new HTMLActionMapping((IHTMLAction)HTMLAction.LeftClick, "", targetElement);
                        }
                        case "right": {
                            return new HTMLActionMapping((IHTMLAction)HTMLAction.RightClick, "", targetElement);
                        }
                    }
                }
                case "VerifyElementText": {
                    return new HTMLActionMapping((IHTMLAction)HTMLAction.VerifyElementText, actionData, targetElement);
                }
                case "VerifyElementVisible": 
                case "MouseOver": 
                case "WaitForElementPresent": 
                case "WaitForElementVisible": 
                case "VerifyElementNotClickable": 
                case "VerifyElementNotPresent": 
                case "VerifyElementNotVisible": 
                case "WaitForElementNotPresent": 
                case "VerifyElementClickable": 
                case "VerifyElementPresent": 
                case "WaitForElementNotVisible": {
                    return new HTMLActionMapping((IHTMLAction)HTMLAction.valueOf(recordedActionName), "", targetElement);
                }
                case "doubleClick": {
                    return new HTMLActionMapping((IHTMLAction)HTMLAction.DoubleClick, actionData, targetElement);
                }
                case "sendKeys": {
                    int keyCode = Integer.parseInt(actionData);
                    if (keyCode != 13) {
                        return null;
                    }
                    HTMLActionMapping htmlActionMapping = new HTMLActionMapping((IHTMLAction)HTMLAction.SendKeys, actionData, targetElement);
                    htmlActionMapping.getData()[0] = HTMLActionParamValueType.newInstance((InputValueEditorProvider)InputValueType.Keys, HTMLActionUtil.convertToExpressionWrapper("Keys.chord(Keys.ENTER)"));
                    return htmlActionMapping;
                }
                case "switchToWindow": {
                    return new HTMLActionMapping((IHTMLAction)HTMLAction.SwitchToWindow, actionData, targetElement);
                }
                case "newTab": {
                    return new HTMLActionMapping((IHTMLAction)HTMLAction.NewTab, actionData, targetElement);
                }
            }
            return null;
        }

        private static boolean isActionDataTrue(String actionData) {
            return actionData != null && actionData.toLowerCase().equals(Boolean.TRUE.toString().toLowerCase());
        }
    }
}

