/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.action;

import com.kms.katalon.composer.mobile.objectspy.components.MobileActionHandler;
import com.kms.katalon.composer.windows.action.WindowsAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class WindowsActionButtonWrapper {
    private Button button;
    private WindowsAction mobileAction;
    private MobileActionHandler selectionHandler;

    public WindowsActionButtonWrapper(Composite parent, WindowsAction mobileAction, MobileActionHandler selectionHandler) {
        this.selectionHandler = selectionHandler;
        this.mobileAction = mobileAction;
        this.initButton(parent);
    }

    protected void initButton(Composite parent) {
        this.button = new Button(parent, 0);
        this.button.setText(this.mobileAction.getReadableName());
        this.button.setToolTipText(this.mobileAction.getDescription());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (WindowsActionButtonWrapper.this.selectionHandler != null) {
                    WindowsActionButtonWrapper.this.selectionHandler.execute(event);
                }
            }
        });
    }

    public WindowsAction getWindowsAction() {
        return this.mobileAction;
    }

    public void enableButton() {
        this.button.setEnabled(true);
    }

    public void disableButton() {
        this.button.setEnabled(false);
    }

    public void setEnabledButton(boolean isEnabled) {
        if (this.button.isDisposed()) {
            return;
        }
        this.button.setEnabled(isEnabled);
    }
}

