/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.action;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testcase.ast.dialogs.KeysInputBuilderDialog;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.windows.action.WindowsAction;
import com.kms.katalon.composer.windows.action.WindowsActionMapping;
import com.kms.katalon.composer.windows.constant.ComposerWindowsMessage;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.composer.windows.element.SnapshotWindowsElement;
import com.kms.katalon.composer.windows.exception.WindowsComposerException;
import com.kms.katalon.core.enums.windows.LocatorStrategy;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.testobject.WindowsTestObject;
import com.kms.katalon.core.windows.driver.WindowsSession;
import com.kms.katalon.core.windows.keyword.helper.WindowsActionHelper;
import com.kms.katalon.core.windows.model.StringMatchingStrategy;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.openqa.selenium.Keys;

public class WindowsActionHandler {
    private WindowsSession windowsSession;
    private WindowsAction action;

    public WindowsActionHandler(WindowsSession driver, WindowsAction action) {
        this.windowsSession = driver;
        this.action = action;
    }

    private WindowsTestObject findElement(CapturedWindowsElement targetElement) {
        if (targetElement == null) {
            return null;
        }
        WindowsTestObject testObject = new WindowsTestObject(targetElement.getName());
        testObject.setLocator(targetElement.getLocator());
        testObject.setLocatorStrategy(LocatorStrategy.valueOf((String)targetElement.getLocatorStrategy().name()));
        return testObject;
    }

    public WindowsActionMapping perform(SnapshotWindowsElement element, Shell activeShell) throws WindowsComposerException {
        switch (this.action) {
            case ClearText: {
                ClearTextActionHandler handler = new ClearTextActionHandler();
                return handler.perform(element, activeShell);
            }
            case Click: {
                ClickActionHandler handler = new ClickActionHandler();
                return handler.perform(element, activeShell);
            }
            case ClickElementOffset: {
                ClickElementOffsetActionHandler handler = new ClickElementOffsetActionHandler(element);
                return handler.perform(element, activeShell);
            }
            case RightClick: {
                RightClickActionHandler handler = new RightClickActionHandler();
                return handler.perform(element, activeShell);
            }
            case RightClickElementOffset: {
                RightClickElementOffsetActionHandler handler = new RightClickElementOffsetActionHandler();
                return handler.perform(element, activeShell);
            }
            case CloseApplication: {
                CloseAppHandler handler = new CloseAppHandler();
                handler.perform(element, activeShell);
                return handler.getActionMapping();
            }
            case DoubleClick: {
                DoubleClickActionHandler handler = new DoubleClickActionHandler();
                handler.perform(element, activeShell);
                return handler.getActionMapping();
            }
            case GetText: {
                GetTextActionHandler handler = new GetTextActionHandler();
                return handler.perform(element, activeShell);
            }
            case SetText: {
                SetTextActionHandler handler = new SetTextActionHandler();
                return handler.perform(element, activeShell);
            }
            case GetAttribute: {
                GetAttributeActionHandler handler = new GetAttributeActionHandler();
                return handler.perform(element, activeShell);
            }
            case SendKeys: {
                SendKeysActionHandler handler = new SendKeysActionHandler();
                return handler.perform(element, activeShell);
            }
            case SetEncryptedText: {
                SetEncryptedTextHandler hanlder = new SetEncryptedTextHandler();
                return hanlder.perform(element, activeShell);
            }
            case SwitchToApplication: {
                SwitchToApplicationHandler handler = new SwitchToApplicationHandler();
                return handler.perform(element, activeShell);
            }
            case SwitchToDesktop: {
                SwitchToDesktopHandler handler = new SwitchToDesktopHandler();
                return handler.perform(element, activeShell);
            }
            case SwitchToWindowTitle: {
                SwitchToWindowTitleHandler handler = new SwitchToWindowTitleHandler();
                return handler.perform(element, activeShell);
            }
            case SwitchToWindow: {
                SwitchToWindowHandler handler = new SwitchToWindowHandler();
                return handler.perform(element, activeShell);
            }
        }
        return null;
    }

    private class AttachWindowByNameDialog
    extends AbstractDialog {
        private Text txtText;
        private String text;

        protected AttachWindowByNameDialog(Shell parentShell) {
            super(parentShell, false);
        }

        protected void registerControlModifyListeners() {
        }

        protected void setInput() {
            this.txtText.forceFocus();
        }

        protected Control createDialogContainer(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            Label lblText = new Label(composite, 0);
            lblText.setText("Please input the application window's title:");
            this.txtText = new Text(composite, 2624);
            this.txtText.setLayoutData((Object)new GridData(4, 4, true, true));
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "Apply action", true);
            this.createButton(parent, 1, "Cancel action", false);
        }

        protected Point getInitialSize() {
            return new Point(400, 250);
        }

        public String getDialogTitle() {
            return "Switch to window title action";
        }

        protected void okPressed() {
            this.text = this.txtText.getText();
            super.okPressed();
        }
    }

    public class BaseActionHandler {
        protected SnapshotWindowsElement element;
        protected Shell activeShell;

        protected void performActionBeforeProgress() throws InterruptedException {
        }

        protected void performActionAfterProgress() throws InterruptedException {
        }

        protected void performAction() throws InvocationTargetException {
        }

        public WindowsActionMapping getActionMapping() {
            return new WindowsActionMapping(WindowsActionHandler.this.action, null);
        }

        protected IRunnableWithProgress getActionMappingProgress() {
            return new IRunnableWithProgress(){

                private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException("Operation has been canceled");
                    }
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Running commands...", 1);
                        BaseActionHandler.this.performAction();
                        this.checkMonitorCanceled(monitor);
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
        }

        public WindowsActionMapping perform(SnapshotWindowsElement element, Shell activeShell) throws WindowsComposerException {
            try {
                this.element = element;
                this.activeShell = activeShell;
                WindowsActionHandler.this.action.setCanceled(false);
                this.performActionBeforeProgress();
                ProgressMonitorDialogWithThread progressDlg = new ProgressMonitorDialogWithThread(activeShell){

                    public void cancelPressed() {
                        super.cancelPressed();
                        this.finishedRun();
                        this.getProgressMonitor().done();
                        ((BaseActionHandler)BaseActionHandler.this).WindowsActionHandler.this.action.setCanceled(true);
                    }
                };
                IRunnableWithProgress runnable = this.getActionMappingProgress();
                progressDlg.run(true, true, runnable);
                this.performActionAfterProgress();
                return this.getActionMapping();
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof ExecutionException) {
                    ExecutionException executionException = (ExecutionException)e.getTargetException();
                    Throwable cause = executionException.getCause();
                    if (cause instanceof StepFailedException) {
                        throw (StepFailedException)cause;
                    }
                    if (cause instanceof CancellationException) {
                        return null;
                    }
                    throw new WindowsComposerException(cause);
                }
                throw new WindowsComposerException(e.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    public class BaseActionObjectHandler {
        protected SnapshotWindowsElement element;
        protected Shell activeShell;
        protected CapturedWindowsElement capturedElement;

        protected void performActionBeforeProgress() throws InterruptedException, InvocationTargetException {
        }

        protected void performActionAfterProgress() throws InterruptedException, InvocationTargetException {
        }

        protected void performAction(WindowsTestObject testObject) throws InterruptedException, InvocationTargetException {
        }

        protected void safelyBringAppToForegroundIfPossible() {
            try {
                WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).bringAppToForegroundIfPossible();
            }
            catch (Exception ex) {
                LoggerSingleton.logError((Throwable)ex, (String)"Warning: failed to bring app to foreground");
            }
        }

        public WindowsActionMapping getActionMapping() {
            return new WindowsActionMapping(WindowsActionHandler.this.action, this.capturedElement);
        }

        protected IRunnableWithProgress getActionMappingProgress() {
            return new IRunnableWithProgress(){

                private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException("Operation has been canceled");
                    }
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Running commands...", 2);
                        BaseActionObjectHandler.this.capturedElement = BaseActionObjectHandler.this.element.newCapturedElement(((BaseActionObjectHandler)BaseActionObjectHandler.this).WindowsActionHandler.this.windowsSession.getRunningDriver());
                        WindowsTestObject testObject = WindowsActionHandler.this.findElement(BaseActionObjectHandler.this.capturedElement);
                        monitor.worked(1);
                        this.checkMonitorCanceled(monitor);
                        BaseActionObjectHandler.this.performAction(testObject);
                        this.checkMonitorCanceled(monitor);
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
        }

        public WindowsActionMapping perform(SnapshotWindowsElement element, Shell activeShell) throws WindowsComposerException {
            try {
                this.element = element;
                this.activeShell = activeShell;
                WindowsActionHandler.this.action.setCanceled(false);
                this.performActionBeforeProgress();
                ProgressMonitorDialogWithThread progressDlg = new ProgressMonitorDialogWithThread(activeShell){

                    public void cancelPressed() {
                        super.cancelPressed();
                        this.finishedRun();
                        this.getProgressMonitor().done();
                        ((BaseActionObjectHandler)BaseActionObjectHandler.this).WindowsActionHandler.this.action.setCanceled(true);
                    }
                };
                IRunnableWithProgress runnable = this.getActionMappingProgress();
                progressDlg.run(true, true, runnable);
                this.performActionAfterProgress();
                return this.getActionMapping();
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof ExecutionException) {
                    ExecutionException executionException = (ExecutionException)e.getTargetException();
                    Throwable cause = executionException.getCause();
                    if (cause instanceof StepFailedException) {
                        throw (StepFailedException)cause;
                    }
                    if (cause instanceof CancellationException) {
                        return null;
                    }
                    throw new WindowsComposerException(cause);
                }
                throw new WindowsComposerException(e.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
    }

    public class ClearTextActionHandler
    extends BaseActionObjectHandler {
        @Override
        protected void performAction(WindowsTestObject testObject) {
            this.safelyBringAppToForegroundIfPossible();
            WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).clearText(testObject);
        }
    }

    public class ClickActionHandler
    extends BaseActionObjectHandler {
        @Override
        protected void performAction(WindowsTestObject testObject) {
            this.safelyBringAppToForegroundIfPossible();
            WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).click(testObject);
        }
    }

    public class ClickElementOffsetActionHandler
    extends BaseActionObjectHandler {
        private int x = 0;
        private int y = 0;
        private SnapshotWindowsElement element;

        public ClickElementOffsetActionHandler(SnapshotWindowsElement element) {
            this.element = element;
        }

        @Override
        protected void performActionBeforeProgress() throws InterruptedException {
            try {
                int[] offsets = (int[])this.element.getMetaData().get("elementOffsets");
                if (offsets != null && offsets.length == 2) {
                    this.x = offsets[0];
                    this.y = offsets[1];
                    return;
                }
            }
            catch (Throwable e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        @Override
        protected void performAction(WindowsTestObject testObject) throws InterruptedException, InvocationTargetException {
            this.safelyBringAppToForegroundIfPossible();
            WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).clickOffset(testObject, this.x, this.y);
        }

        @Override
        public WindowsActionMapping getActionMapping() {
            WindowsActionMapping actionMapping = super.getActionMapping();
            actionMapping.getData()[0].setValue(new ConstantExpressionWrapper((Object)this.x));
            actionMapping.getData()[1].setValue(new ConstantExpressionWrapper((Object)this.y));
            return actionMapping;
        }
    }

    public class CloseAppHandler
    extends BaseActionHandler {
        @Override
        protected void performAction() {
            WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).closeApp();
        }
    }

    public class DoubleClickActionHandler
    extends BaseActionObjectHandler {
        @Override
        protected void performAction(WindowsTestObject testObject) {
            WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).doubleClick(testObject);
        }
    }

    public class GetAttributeActionHandler
    extends BaseActionObjectHandler {
        private String textInput;
        private String textResult;

        @Override
        protected void performActionBeforeProgress() throws InterruptedException {
            GetAttributeInputDialog inputDialog = new GetAttributeInputDialog(this.activeShell);
            if (inputDialog.open() != 0) {
                throw new InterruptedException();
            }
            this.textInput = StringUtils.defaultString((String)inputDialog.text);
        }

        @Override
        protected void performAction(WindowsTestObject testObject) {
            this.textResult = WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).findElement(testObject).getAttribute(this.textInput);
        }

        @Override
        public WindowsActionMapping getActionMapping() {
            WindowsActionMapping actionMapping = super.getActionMapping();
            actionMapping.getData()[0].setValue(new ConstantExpressionWrapper((Object)this.textInput));
            return actionMapping;
        }

        @Override
        protected void performActionAfterProgress() throws InterruptedException {
            GetAttributeResultDialog resultDialog = new GetAttributeResultDialog(this.activeShell, this.textResult);
            if (resultDialog.open() != 0) {
                throw new InterruptedException();
            }
        }
    }

    private class GetAttributeInputDialog
    extends AbstractDialog {
        private Text txtText;
        private String text;
        private Button btnApplyAction;

        protected GetAttributeInputDialog(Shell parentShell) {
            super(parentShell, false);
        }

        protected void registerControlModifyListeners() {
        }

        protected void setInput() {
            this.txtText.forceFocus();
        }

        protected Control createDialogContainer(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            Label lblText = new Label(composite, 0);
            lblText.setText(ComposerWindowsMessage.LBL_GET_ATTRIBUTE_INPUT);
            this.txtText = new Text(composite, 2048);
            this.txtText.setLayoutData((Object)new GridData(4, 64, true, true));
            this.addControlListeners();
            return composite;
        }

        private void addControlListeners() {
            this.txtText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    String text = GetAttributeInputDialog.this.txtText.getText();
                    if (!StringUtils.isEmpty((CharSequence)text)) {
                        GetAttributeInputDialog.this.btnApplyAction.setEnabled(true);
                    } else {
                        GetAttributeInputDialog.this.btnApplyAction.setEnabled(false);
                    }
                }
            });
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.btnApplyAction = this.createButton(parent, 0, ComposerWindowsMessage.BTN_APPLY, true);
            this.createButton(parent, 1, ComposerWindowsMessage.BTN_CANCEL, false);
            this.btnApplyAction.setEnabled(false);
        }

        protected Point getInitialSize() {
            return new Point(400, super.getInitialSize().y);
        }

        public String getDialogTitle() {
            return ComposerWindowsMessage.TITLE_GET_ATTRIBUTE_DIALOG;
        }

        protected void okPressed() {
            this.text = this.txtText.getText();
            super.okPressed();
        }
    }

    private class GetAttributeResultDialog
    extends AbstractDialog {
        private Text txtText;
        private String text;

        protected GetAttributeResultDialog(Shell parentShell, String text) {
            super(parentShell, false);
            this.text = text;
        }

        protected void registerControlModifyListeners() {
        }

        protected void setInput() {
            this.txtText.setText((String)StringUtils.defaultIfEmpty((CharSequence)this.text, (CharSequence)"<empty>"));
        }

        protected Control createDialogContainer(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            Label lblText = new Label(composite, 0);
            lblText.setText(ComposerWindowsMessage.LBL_GET_ATTRIBUTE_RESULT);
            this.txtText = new Text(composite, 2632);
            this.txtText.setLayoutData((Object)new GridData(4, 4, true, true));
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, ComposerWindowsMessage.BTN_APPLY, true);
            this.createButton(parent, 1, ComposerWindowsMessage.BTN_CANCEL, false);
        }

        protected Point getInitialSize() {
            return new Point(400, 250);
        }

        public String getDialogTitle() {
            return ComposerWindowsMessage.TITLE_GET_ATTRIBUTE_DIALOG;
        }
    }

    public class GetTextActionHandler
    extends BaseActionObjectHandler {
        private String text;

        @Override
        protected void performAction(WindowsTestObject testObject) {
            this.text = WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).getText(testObject);
        }

        @Override
        protected void performActionAfterProgress() throws InterruptedException {
            GetTextDialog getTextActionDialog = new GetTextDialog(this.activeShell, this.text);
            if (getTextActionDialog.open() != 0) {
                throw new InterruptedException();
            }
        }
    }

    private class GetTextDialog
    extends AbstractDialog {
        private Text txtText;
        private String text;

        protected GetTextDialog(Shell parentShell, String text) {
            super(parentShell, false);
            this.text = text;
        }

        protected void registerControlModifyListeners() {
        }

        protected void setInput() {
            this.txtText.setText((String)StringUtils.defaultIfEmpty((CharSequence)this.text, (CharSequence)"<empty>"));
        }

        protected Control createDialogContainer(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            Label lblText = new Label(composite, 0);
            lblText.setText("Text is:");
            this.txtText = new Text(composite, 2632);
            this.txtText.setLayoutData((Object)new GridData(4, 4, true, true));
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "Apply action", true);
            this.createButton(parent, 1, "Cancel action", false);
        }

        protected Point getInitialSize() {
            return new Point(400, 250);
        }

        public String getDialogTitle() {
            return "Get Text action";
        }
    }

    public class RightClickActionHandler
    extends BaseActionObjectHandler {
        @Override
        protected void performAction(WindowsTestObject testObject) {
            this.safelyBringAppToForegroundIfPossible();
            WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).rightClick(testObject);
        }
    }

    public class RightClickElementOffsetActionHandler
    extends BaseActionObjectHandler {
        private int x;
        private int y;

        @Override
        protected void performActionBeforeProgress() throws InterruptedException {
            try {
                int[] offsets = (int[])this.element.getMetaData().get("elementOffsets");
                if (offsets != null && offsets.length == 2) {
                    this.x = offsets[0];
                    this.y = offsets[1];
                    return;
                }
            }
            catch (Throwable e) {
                throw new InterruptedException(e.getMessage());
            }
        }

        @Override
        protected void performAction(WindowsTestObject testObject) throws InterruptedException, InvocationTargetException {
            this.safelyBringAppToForegroundIfPossible();
            WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).rightClickOffset(testObject, this.x, this.y);
        }

        @Override
        public WindowsActionMapping getActionMapping() {
            WindowsActionMapping actionMapping = super.getActionMapping();
            actionMapping.getData()[0].setValue(new ConstantExpressionWrapper((Object)this.x));
            actionMapping.getData()[1].setValue(new ConstantExpressionWrapper((Object)this.y));
            return actionMapping;
        }
    }

    public class SendKeysActionHandler
    extends BaseActionObjectHandler {
        private MethodCallExpressionWrapper keysExpression = (MethodCallExpressionWrapper)GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression((String)"Keys.chord()");

        @Override
        protected void performActionBeforeProgress() throws InterruptedException {
            KeysInputBuilderDialog inputDialog = new KeysInputBuilderDialog(this.activeShell, this.getValue());
            if (inputDialog.open() != 0) {
                throw new InterruptedException();
            }
            this.keysExpression = inputDialog.getReturnValue();
        }

        private MethodCallExpressionWrapper getValue() {
            return this.keysExpression;
        }

        @Override
        protected void performAction(WindowsTestObject testObject) {
            this.safelyBringAppToForegroundIfPossible();
            WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).sendKeys(testObject, new CharSequence[]{this.getKeys()});
        }

        private String getKeys() {
            Object keys = new String();
            ArgumentListExpressionWrapper arguments = this.keysExpression.getArguments();
            boolean isSpecialKey = false;
            for (ExpressionWrapper expr : arguments.getExpressions()) {
                List children = expr.getAstChildren();
                boolean bl = isSpecialKey = children.size() > 0;
                if (isSpecialKey) {
                    keys = (String)keys + children.stream().map(child -> {
                        if (child instanceof ConstantExpressionWrapper) {
                            String keyName = ((ConstantExpressionWrapper)child).getValue().toString();
                            return Keys.valueOf((String)keyName).toString();
                        }
                        return "";
                    }).collect(Collectors.joining());
                    continue;
                }
                children = expr.getParent().getAstChildren();
                keys = (String)keys + children.stream().map(child -> {
                    if (child instanceof ConstantExpressionWrapper) {
                        return ((ConstantExpressionWrapper)child).getValue().toString();
                    }
                    return "";
                }).collect(Collectors.joining());
            }
            return Keys.chord((CharSequence[])new CharSequence[]{keys});
        }

        @Override
        public WindowsActionMapping getActionMapping() {
            WindowsActionMapping actionMapping = super.getActionMapping();
            actionMapping.getData()[0].setValue(this.keysExpression);
            return actionMapping;
        }
    }

    private class SetEncryptedTextDialog
    extends AbstractDialog {
        private Text txtRawText;
        private Text txtEncryptedText;
        private String rawText;
        private String encryptedText;
        private Button btnApplyAction;

        protected SetEncryptedTextDialog(Shell parentShell) {
            super(parentShell, false);
        }

        protected void setInput() {
            this.txtRawText.forceFocus();
        }

        protected Control createDialogContainer(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label lblRawText = new Label(composite, 0);
            lblRawText.setText(ComposerWindowsMessage.LBL_RAW_TEXT);
            this.txtRawText = new Text(composite, 2048);
            this.txtRawText.setLayoutData((Object)new GridData(4, 4, true, false));
            Label lblEncryptedText = new Label(composite, 0);
            lblEncryptedText.setText(ComposerWindowsMessage.LBL_ENCRYPTED_TEXT);
            this.txtEncryptedText = new Text(composite, 2048);
            this.txtEncryptedText.setLayoutData((Object)new GridData(4, 4, true, false));
            this.txtEncryptedText.setEditable(false);
            this.addControlListeners();
            return composite;
        }

        private void addControlListeners() {
            this.txtRawText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    SetEncryptedTextDialog.this.rawText = SetEncryptedTextDialog.this.txtRawText.getText();
                    if (!StringUtils.isEmpty((CharSequence)SetEncryptedTextDialog.this.rawText)) {
                        try {
                            CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)SetEncryptedTextDialog.this.rawText);
                            SetEncryptedTextDialog.this.encryptedText = CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo);
                            SetEncryptedTextDialog.this.txtEncryptedText.setText(SetEncryptedTextDialog.this.encryptedText);
                            SetEncryptedTextDialog.this.btnApplyAction.setEnabled(true);
                        }
                        catch (UnsupportedEncodingException | GeneralSecurityException error) {
                            LoggerSingleton.logError((Throwable)error);
                        }
                    } else {
                        SetEncryptedTextDialog.this.txtEncryptedText.setText("");
                        SetEncryptedTextDialog.this.encryptedText = SetEncryptedTextDialog.this.txtEncryptedText.getText();
                        SetEncryptedTextDialog.this.btnApplyAction.setEnabled(false);
                    }
                }
            });
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.btnApplyAction = this.createButton(parent, 0, ComposerWindowsMessage.BTN_APPLY, true);
            this.createButton(parent, 1, ComposerWindowsMessage.BTN_CANCEL, false);
            this.btnApplyAction.setEnabled(false);
        }

        protected Point getInitialSize() {
            return new Point(400, super.getInitialSize().y);
        }

        public String getDialogTitle() {
            return ComposerWindowsMessage.TITLE_SET_ENCRYPTED_TEXT_DIALOG;
        }

        protected void okPressed() {
            super.okPressed();
        }

        protected void registerControlModifyListeners() {
        }
    }

    public class SetEncryptedTextHandler
    extends BaseActionObjectHandler {
        private String encryptedTextInput;
        private String rawTextInput;

        @Override
        protected void performActionBeforeProgress() throws InterruptedException {
            SetEncryptedTextDialog dialog = new SetEncryptedTextDialog(this.activeShell);
            if (dialog.open() != 0) {
                throw new InterruptedException();
            }
            this.rawTextInput = StringUtils.defaultString((String)dialog.rawText);
            this.encryptedTextInput = StringUtils.defaultString((String)dialog.encryptedText);
        }

        @Override
        protected void performAction(WindowsTestObject testObject) {
            this.safelyBringAppToForegroundIfPossible();
            WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).setText(testObject, this.rawTextInput);
        }

        @Override
        public WindowsActionMapping getActionMapping() {
            WindowsActionMapping actionMapping = super.getActionMapping();
            actionMapping.getData()[0].setValue(new ConstantExpressionWrapper((Object)this.encryptedTextInput));
            return actionMapping;
        }
    }

    public class SetTextActionHandler
    extends BaseActionObjectHandler {
        private String textInput;

        @Override
        protected void performActionBeforeProgress() throws InterruptedException {
            SetTextDialog inputDialog = new SetTextDialog(this.activeShell);
            if (inputDialog.open() != 0) {
                throw new InterruptedException();
            }
            this.textInput = StringUtils.defaultString((String)inputDialog.text);
        }

        @Override
        protected void performAction(WindowsTestObject testObject) {
            this.safelyBringAppToForegroundIfPossible();
            WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).setText(testObject, this.textInput);
        }

        @Override
        public WindowsActionMapping getActionMapping() {
            WindowsActionMapping actionMapping = super.getActionMapping();
            actionMapping.getData()[0].setValue(new ConstantExpressionWrapper((Object)this.textInput));
            return actionMapping;
        }
    }

    private class SetTextDialog
    extends AbstractDialog {
        private Text txtText;
        private String text;

        protected SetTextDialog(Shell parentShell) {
            super(parentShell, false);
        }

        protected void registerControlModifyListeners() {
        }

        protected void setInput() {
            this.txtText.forceFocus();
        }

        protected Control createDialogContainer(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            Label lblText = new Label(composite, 0);
            lblText.setText("Please input text value to set to element:");
            this.txtText = new Text(composite, 2624);
            this.txtText.setLayoutData((Object)new GridData(4, 4, true, true));
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "Apply action", true);
            this.createButton(parent, 1, "Cancel action", false);
        }

        protected Point getInitialSize() {
            return new Point(400, 250);
        }

        public String getDialogTitle() {
            return "Set Text action";
        }

        protected void okPressed() {
            this.text = this.txtText.getText();
            super.okPressed();
        }
    }

    public class SwitchToApplicationHandler
    extends BaseActionHandler {
        @Override
        protected void performAction() {
            WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).switchToApplication();
        }
    }

    public class SwitchToDesktopHandler
    extends BaseActionHandler {
        @Override
        protected void performAction() throws InvocationTargetException {
            try {
                WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).switchToDesktop();
            }
            catch (IOException | URISyntaxException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    public class SwitchToWindowHandler
    extends BaseActionObjectHandler {
        @Override
        protected void performAction(WindowsTestObject windowsObject) throws InterruptedException, InvocationTargetException {
            try {
                WindowsActionHelper.create((WindowsSession)WindowsActionHandler.this.windowsSession).switchToWindow(windowsObject);
            }
            catch (IOException | IllegalAccessException | URISyntaxException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    public class SwitchToWindowTitleHandler
    extends BaseActionHandler {
        private String textInput;

        @Override
        protected void performActionBeforeProgress() throws InterruptedException {
            AttachWindowByNameDialog inputDialog = new AttachWindowByNameDialog(this.activeShell);
            if (inputDialog.open() != 0) {
                throw new InterruptedException();
            }
            this.textInput = StringUtils.defaultString((String)inputDialog.text);
        }

        @Override
        protected IRunnableWithProgress getActionMappingProgress() {
            return new IRunnableWithProgress(){

                private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException("Operation has been canceled");
                    }
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask("Running command...", 1);
                            WindowsActionHelper.create((WindowsSession)((SwitchToWindowTitleHandler)SwitchToWindowTitleHandler.this).WindowsActionHandler.this.windowsSession).switchToWindowTitle(SwitchToWindowTitleHandler.this.textInput, StringMatchingStrategy.CONTAINS);
                            this.checkMonitorCanceled(monitor);
                            monitor.worked(1);
                        }
                        catch (IOException | URISyntaxException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
        }

        @Override
        public WindowsActionMapping getActionMapping() {
            WindowsActionMapping actionMapping = super.getActionMapping();
            actionMapping.getData()[0].setValue(new ConstantExpressionWrapper((Object)this.textInput));
            return actionMapping;
        }
    }
}

